/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import isabelle.Base64$;
import isabelle.Bytes$;
import isabelle.Bytes$Builder$;
import isabelle.Bytes$Subarray$;
import isabelle.Compress;
import isabelle.Compress$Cache$;
import isabelle.Compress$Options$;
import isabelle.Path;
import isabelle.SHA1;
import isabelle.SHA1$;
import isabelle.Space$;
import isabelle.UTF8$;
import isabelle.YXML;
import isabelle.YXML$;
import isabelle.Zstd$;
import isabelle.package$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Bytes
implements YXML.Source {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Bytes.class.getDeclaredField("sha1_digest$lzy1"));
    private final Option chunks;
    private final byte[] chunk0;
    private final long offset;
    private final long size;
    private volatile Object sha1_digest$lzy1;

    public static void append(File file, Bytes bytes) {
        Bytes$.MODULE$.append(file, bytes);
    }

    public static void append(Path path, Bytes bytes) {
        Bytes$.MODULE$.append(path, bytes);
    }

    public static Bytes apply(byte[] byArray) {
        return Bytes$.MODULE$.apply(byArray);
    }

    public static Bytes apply(byte[] byArray, int n, int n2) {
        return Bytes$.MODULE$.apply(byArray, n, n2);
    }

    public static Bytes apply(String string) {
        return Bytes$.MODULE$.apply(string);
    }

    public static long array_size() {
        return Bytes$.MODULE$.array_size();
    }

    public static int block_size() {
        return Bytes$.MODULE$.block_size();
    }

    public static long chunk_size() {
        return Bytes$.MODULE$.chunk_size();
    }

    public static Bytes empty() {
        return Bytes$.MODULE$.empty();
    }

    public static Bytes newline() {
        return Bytes$.MODULE$.newline();
    }

    public static Bytes raw(String string) {
        return Bytes$.MODULE$.raw(string);
    }

    public static Bytes read(File file) {
        return Bytes$.MODULE$.read(file);
    }

    public static Bytes read(Path path) {
        return Bytes$.MODULE$.read(path);
    }

    public static Bytes read_file(Path path, long l, long l2) {
        return Bytes$.MODULE$.read_file(path, l, l2);
    }

    public static Bytes read_stream(InputStream inputStream, long l, long l2) {
        return Bytes$.MODULE$.read_stream(inputStream, l, l2);
    }

    public static Bytes read_url(String string) {
        return Bytes$.MODULE$.read_url(string);
    }

    public static long string_size() {
        return Bytes$.MODULE$.string_size();
    }

    public static void write(File file, Bytes bytes) {
        Bytes$.MODULE$.write(file, bytes);
    }

    public static void write(Path path, Bytes bytes) {
        Bytes$.MODULE$.write(path, bytes);
    }

    public static long read_file$default$2() {
        return Bytes$.MODULE$.read_file$default$2();
    }

    public static long read_stream$default$2() {
        return Bytes$.MODULE$.read_stream$default$2();
    }

    public static long read_file$default$3() {
        return Bytes$.MODULE$.read_file$default$3();
    }

    public static long read_stream$default$3() {
        return Bytes$.MODULE$.read_stream$default$3();
    }

    public Bytes(Option<byte[][]> chunks, byte[] chunk0, long offset, long size) {
        Object object;
        Object object2;
        this.chunks = chunks;
        this.chunk0 = chunk0;
        this.offset = offset;
        this.size = size;
        if (!((chunks.isEmpty() || ArrayOps$.MODULE$.nonEmpty$extension(object2 = Predef$.MODULE$.refArrayOps((Object[])chunks.get())) && ArrayOps$.MODULE$.forall$extension(object = Predef$.MODULE$.refArrayOps((Object[])chunks.get()), (Function1 & Serializable)chunk -> (long)((byte[])chunk).length == Bytes$.MODULE$.chunk_size())) && (long)chunk0.length < Bytes$.MODULE$.chunk_size())) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
    }

    public Option<byte[][]> chunks() {
        return this.chunks;
    }

    public byte[] chunk0() {
        return this.chunk0;
    }

    public long offset() {
        return this.offset;
    }

    public long size() {
        return this.size;
    }

    @Override
    public boolean is_empty() {
        return this.size() == 0L;
    }

    public Option<Bytes> proper() {
        if (this.is_empty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean is_sliced() {
        if (this.offset() != 0L) return true;
        Option<byte[][]> option = this.chunks();
        if (None$.MODULE$.equals(option)) {
            if (this.size() == (long)this.chunk0().length) return false;
            return true;
        }
        if (!(option instanceof Some)) throw new MatchError(option);
        byte[][] cs = (byte[][])((Some)option).value();
        Object object = Predef$.MODULE$.refArrayOps((Object[])cs);
        long physical_size = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(object, (Object)BoxesRunTime.boxToLong((long)this.chunk0().length), (Function2 & Serializable)(n, c) -> Bytes.$anonfun$1(BoxesRunTime.unboxToLong((Object)n), (byte[])c)));
        if (this.size() == physical_size) return false;
        return true;
    }

    public String toString() {
        if (this.is_empty()) {
            return "Bytes.empty";
        }
        return "Bytes(" + Space$.MODULE$.print$extension(Space$.MODULE$.bytes(this.size())) + package$.MODULE$.if_proper(this.is_sliced(), (Function0<String>)((Function0 & Serializable)Bytes::toString$$anonfun$1)) + ")";
    }

    public byte byte_unchecked(long i) {
        long a = this.offset() + i;
        Option<byte[][]> option = this.chunks();
        if (None$.MODULE$.equals(option)) {
            return this.chunk0()[(int)a];
        }
        if (option instanceof Some) {
            byte[][] cs = (byte[][])((Some)option).value();
            long b = a % Bytes$.MODULE$.chunk_size();
            long c = a / Bytes$.MODULE$.chunk_size();
            if (c < (long)cs.length) {
                return cs[(int)c][(int)b];
            }
            return this.chunk0()[(int)b];
        }
        throw new MatchError(option);
    }

    public byte byte(long i) {
        if (0L <= i && i < this.size()) {
            return this.byte_unchecked(i);
        }
        throw new IndexOutOfBoundsException();
    }

    public char char(long i) {
        return (char)(this.byte(i) & 0xFF);
    }

    public Iterator<Subarray> subarray_iterator() {
        if (this.is_empty()) {
            return scala.package$.MODULE$.Iterator().empty();
        }
        if (this.chunks().isEmpty()) {
            return scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subarray[]{Bytes$Subarray$.MODULE$.apply(this.chunk0(), (int)this.offset(), (int)this.size())}));
        }
        long end_offset = this.offset() + this.size();
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.chunks().get());
        return ArrayOps$.MODULE$.iterator$extension(object).$plus$plus(this::subarray_iterator$$anonfun$1).zipWithIndex().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                byte[] array = (byte[])tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                byte[] array = (byte[])tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                long array_start = Bytes$.MODULE$.chunk_size() * (long)index;
                long array_stop = array_start + (long)array.length;
                if (this.offset() < array_stop && array_start < end_offset) {
                    long i = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(array_start), this.offset()) - array_start;
                    long j = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(array_stop), end_offset) - array_start;
                    return Bytes$Subarray$.MODULE$.apply(array, (int)i, (int)(j - i));
                }
                return Bytes$Subarray$.MODULE$.empty();
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Iterator<Object> byte_iterator() {
        return this.subarray_iterator().flatMap((Function1 & Serializable)a -> a.byte_iterator().map((Function1 & Serializable)b -> BoxesRunTime.unboxToByte((Object)b)));
    }

    public Bytes slice(long i, long j) {
        if (0L <= i && i <= j && j <= this.size()) {
            if (i == j) {
                return Bytes$.MODULE$.empty();
            }
            return new Bytes(this.chunks(), this.chunk0(), this.offset() + i, j - i);
        }
        throw new IndexOutOfBoundsException();
    }

    public Bytes unslice() {
        if (this.is_sliced()) {
            return Bytes$Builder$.MODULE$.use(this.size(), (Function1<Builder, BoxedUnit>)(JProcedure1 & Serializable)builder -> this.subarray_iterator().foreach((Function1)(JProcedure1 & Serializable)a -> builder.$plus$eq((Subarray)a)));
        }
        return this;
    }

    public boolean terminated_line() {
        return this.size() >= 1L && (this.byte_unchecked(this.size() - 1L) == 13 || this.byte_unchecked(this.size() - 1L) == 10);
    }

    public Bytes trim_line() {
        if (this.size() >= 2L && this.byte_unchecked(this.size() - 2L) == 13 && this.byte_unchecked(this.size() - 1L) == 10) {
            return this.slice(0L, this.size() - 2L);
        }
        if (this.size() >= 1L && (this.byte_unchecked(this.size() - 1L) == 13 || this.byte_unchecked(this.size() - 1L) == 10)) {
            return this.slice(0L, this.size() - 1L);
        }
        return this;
    }

    public Iterator<Bytes> separated_chunks(byte sep) {
        return new Iterator<Bytes>(sep, this){
            private final byte sep$1;
            private long start;
            private long stop;
            private final /* synthetic */ Bytes $outer;
            {
                this.sep$1 = sep$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.start = -1L;
                this.stop = -1L;
                if (!$outer.is_empty()) {
                    this.start = 0L;
                    this.stop = this.end(0L);
                }
            }

            private long end(long i) {
                long j;
                for (j = i; j < this.$outer.size() && this.$outer.byte_unchecked(j) != this.sep$1; ++j) {
                }
                return j;
            }

            public boolean hasNext() {
                return 0L <= this.start && this.start <= this.stop && this.stop <= this.$outer.size();
            }

            public Bytes next() {
                if (this.hasNext()) {
                    Bytes chunk = this.$outer.slice(this.start, this.stop);
                    if (this.stop < this.$outer.size()) {
                        this.start = this.stop + 1L;
                        this.stop = this.end(this.start);
                    } else {
                        this.start = -1L;
                        this.stop = -1L;
                    }
                    return chunk;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public List<Bytes> space_explode(byte sep) {
        return this.separated_chunks(sep).toList();
    }

    public List<Bytes> split_lines() {
        return this.space_explode((byte)10);
    }

    @Override
    public boolean is_X() {
        return this.size() == 1L && this.byte_unchecked(0L) == YXML$.MODULE$.X_byte();
    }

    @Override
    public boolean is_Y() {
        return this.size() == 1L && this.byte_unchecked(0L) == YXML$.MODULE$.Y_byte();
    }

    public Iterator<Bytes> iterator_X() {
        return this.separated_chunks(YXML$.MODULE$.X_byte());
    }

    public Iterator<Bytes> iterator_Y() {
        return this.separated_chunks(YXML$.MODULE$.Y_byte());
    }

    public SHA1.Digest sha1_digest() {
        Object object = this.sha1_digest$lzy1;
        if (object instanceof SHA1.Digest) {
            return (SHA1.Digest)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SHA1.Digest)this.sha1_digest$lzyINIT1();
    }

    private Object sha1_digest$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.sha1_digest$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SHA1.Digest digest = null;
                    try {
                        SHA1.Digest digest2 = digest = this.is_empty() ? SHA1$.MODULE$.digest_empty() : SHA1$.MODULE$.make_digest((Function1<MessageDigest, BoxedUnit>)(JProcedure1 & Serializable)sha -> this.subarray_iterator().withFilter((Function1 & Serializable)a -> a.length() > 0).foreach((Function1)(JProcedure1 & Serializable)a -> sha.update(a.array(), a.offset(), a.length())));
                        object2 = digest == null ? LazyVals.NullValue$.MODULE$ : digest;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.sha1_digest$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return digest;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int hashCode() {
        return this.sha1_digest().hashCode();
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof Bytes) {
            Bytes other = (Bytes)object;
            if (this == other) {
                return true;
            }
            if (this.size() != other.size()) {
                return false;
            }
            if (this.chunks().isEmpty() && other.chunks().isEmpty()) {
                return Arrays.equals(this.chunk0(), (int)this.offset(), (int)(this.offset() + this.size()), other.chunk0(), (int)other.offset(), (int)(other.offset() + other.size()));
            }
            if (!this.is_sliced() && !other.is_sliced()) {
                return this.subarray_iterator().zip(other.subarray_iterator()).forall((Function1 & Serializable)x$1 -> {
                    Subarray subarray = (Subarray)x$1._1();
                    Subarray subarray2 = (Subarray)x$1._2();
                    return Arrays.equals(subarray.array(), subarray2.array());
                });
            }
            SHA1.Digest digest = this.sha1_digest();
            SHA1.Digest digest2 = other.sha1_digest();
            return !(digest != null ? !((Object)digest).equals(digest2) : digest2 != null);
        }
        return false;
    }

    public Bytes $plus(Bytes other) {
        if (other.is_empty()) {
            return this;
        }
        if (this.is_empty()) {
            return other;
        }
        return Bytes$Builder$.MODULE$.use(this.size() + other.size(), (Function1<Builder, BoxedUnit>)(JProcedure1 & Serializable)builder -> this.subarray_iterator().$plus$plus(() -> Bytes.$plus$$anonfun$1$$anonfun$1(other)).foreach((Function1)(JProcedure1 & Serializable)a -> builder.$plus$eq((Subarray)a)));
    }

    public byte[] make_array() {
        if (this.size() > Bytes$.MODULE$.array_size()) {
            throw new Too_Large(this.size(), Bytes$.MODULE$.array_size());
        }
        int n = (int)this.size();
        ByteArrayOutputStream buf = new ByteArrayOutputStream(n);
        this.subarray_iterator().foreach((Function1)(JProcedure1 & Serializable)a -> buf.write(a.array(), a.offset(), a.length()));
        return buf.toByteArray();
    }

    @Override
    public String text() {
        if (this.is_empty()) {
            return "";
        }
        InputStreamReader reader = new InputStreamReader(this.stream(), UTF8$.MODULE$.charset());
        char[] buf = new char[(int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(this.size()), Bytes$.MODULE$.string_size()) + 1];
        int m = 0;
        int n = 0;
        while (m >= 0 && n < buf.length) {
            m = reader.read(buf, n, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(buf.length - n), Bytes$.MODULE$.block_size()));
            if (m <= 0) continue;
            n += m;
        }
        Predef$.MODULE$.require(m == -1, Bytes::text$$anonfun$1);
        return new String(buf, 0, n);
    }

    public Option<String> wellformed_text() {
        Object object;
        try {
            String s = this.text();
            Bytes bytes = this;
            Bytes bytes2 = Bytes$.MODULE$.apply(s);
            object = !(bytes != null ? !((Object)bytes).equals(bytes2) : bytes2 != null) ? Some$.MODULE$.apply((Object)s) : None$.MODULE$;
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                object = None$.MODULE$;
            }
            throw throwable;
        }
        return object;
    }

    public Bytes encode_base64() {
        return Bytes$Builder$.MODULE$.use_stream(RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)this.size() * 1.5)), (Function1<OutputStream, BoxedUnit>)(JProcedure1 & Serializable)out -> package$.MODULE$.using(Base64$.MODULE$.encode_stream((OutputStream)out), (JProcedure1 & Serializable)stream -> this.write_stream((OutputStream)stream)));
    }

    public Bytes decode_base64() {
        return (Bytes)package$.MODULE$.using(Base64$.MODULE$.decode_stream(this.stream()), (Function1 & Serializable)_$2 -> {
            long l = RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)this.size() / 1.2));
            long l2 = Bytes$.MODULE$.read_stream$default$2();
            return Bytes$.MODULE$.read_stream((InputStream)_$2, l2, l);
        });
    }

    public Tuple2<Object, String> maybe_encode_base64() {
        Option<String> option = this.wellformed_text();
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)s);
        }
        if (None$.MODULE$.equals(option)) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)this.encode_base64().text());
        }
        throw new MatchError(option);
    }

    public InputStream stream() {
        if (this.chunks().isEmpty()) {
            return new ByteArrayInputStream(this.chunk0(), (int)this.offset(), (int)this.size());
        }
        return new InputStream(this){
            private long index;
            private final /* synthetic */ Bytes $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.index = 0L;
            }

            public int read() {
                if (this.index < this.$outer.size()) {
                    int res = this.$outer.byte_unchecked(this.index) & 0xFF;
                    ++this.index;
                    return res;
                }
                return -1;
            }

            public int read(byte[] buffer, int start, int length) {
                if (length < 16) {
                    return super.read(buffer, start, length);
                }
                long index0 = this.index;
                this.index = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(this.index + (long)length), this.$outer.size());
                int n = (int)(this.index - index0);
                if (n == 0) {
                    return -1;
                }
                IntRef i = IntRef.create((int)start);
                this.$outer.slice(index0, this.index).subarray_iterator().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> Bytes.isabelle$Bytes$$anon$2$$_$read$$anonfun$1(buffer, i, arg_0)));
                return n;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{isabelle$Bytes$$anon$2$$_$read$$anonfun$1(byte[] scala.runtime.IntRef isabelle.Bytes$Subarray )}, serializedLambda);
            }
        };
    }

    public void write_stream(OutputStream stream) {
        this.subarray_iterator().withFilter((Function1 & Serializable)a -> a.length() > 0).foreach((Function1)(JProcedure1 & Serializable)a -> stream.write(a.array(), a.offset(), a.length()));
    }

    public boolean detect_xz() {
        return this.size() >= 6L && this.byte_unchecked(0L) == (byte)253 && this.byte_unchecked(1L) == (byte)55 && this.byte_unchecked(2L) == (byte)122 && this.byte_unchecked(3L) == (byte)88 && this.byte_unchecked(4L) == (byte)90 && this.byte_unchecked(5L) == (byte)0;
    }

    public boolean detect_zstd() {
        return this.size() >= 4L && this.byte_unchecked(0L) == (byte)40 && this.byte_unchecked(1L) == (byte)181 && this.byte_unchecked(2L) == (byte)47 && this.byte_unchecked(3L) == (byte)253;
    }

    public Bytes uncompress_xz(Compress.Cache cache) {
        return (Bytes)package$.MODULE$.using(new XZInputStream(this.stream(), cache.for_xz()), (Function1 & Serializable)_$3 -> Bytes$.MODULE$.read_stream((InputStream)_$3, Bytes$.MODULE$.read_stream$default$2(), this.size()));
    }

    public Compress.Cache uncompress_xz$default$1() {
        return Compress$Cache$.MODULE$.none();
    }

    public Bytes uncompress_zstd(Compress.Cache cache) {
        Zstd$.MODULE$.init();
        return (Bytes)package$.MODULE$.using(new ZstdInputStream(this.stream(), cache.for_zstd()), (Function1 & Serializable)_$4 -> Bytes$.MODULE$.read_stream((InputStream)_$4, Bytes$.MODULE$.read_stream$default$2(), this.size()));
    }

    public Compress.Cache uncompress_zstd$default$1() {
        return Compress$Cache$.MODULE$.none();
    }

    public Bytes uncompress(Compress.Cache cache) {
        if (this.detect_xz()) {
            return this.uncompress_xz(cache);
        }
        if (this.detect_zstd()) {
            return this.uncompress_zstd(cache);
        }
        return (Bytes)package$.MODULE$.error().apply((Object)"Cannot detect compression scheme");
    }

    public Compress.Cache uncompress$default$1() {
        return Compress$Cache$.MODULE$.none();
    }

    public Bytes compress(Compress.Options options, Compress.Cache cache) {
        return Bytes$Builder$.MODULE$.use_stream(this.size(), (Function1<OutputStream, BoxedUnit>)(JProcedure1 & Serializable)out -> {
            XZOutputStream xZOutputStream;
            Compress.Options options = options;
            if (options instanceof Compress.Options_XZ) {
                Compress.Options_XZ options_xz = (Compress.Options_XZ)options;
                xZOutputStream = new XZOutputStream(out, (FilterOptions)options_xz.make(), cache.for_xz());
            } else if (options instanceof Compress.Options_Zstd) {
                Compress.Options_Zstd options_zstd = (Compress.Options_Zstd)options;
                xZOutputStream = new ZstdOutputStream(out, cache.for_zstd(), options_zstd.level());
            } else {
                throw new MatchError((Object)options);
            }
            package$.MODULE$.using(xZOutputStream, (JProcedure1 & Serializable)s -> this.subarray_iterator().foreach((Function1)(JProcedure1 & Serializable)a -> s.write(a.array(), a.offset(), a.length())));
        });
    }

    public Compress.Options compress$default$1() {
        return Compress$Options$.MODULE$.apply();
    }

    public Compress.Cache compress$default$2() {
        return Compress$Cache$.MODULE$.none();
    }

    public Tuple2<Object, Bytes> maybe_compress(Compress.Options options, Compress.Cache cache) {
        Bytes compressed = this.compress(options, cache);
        if (compressed.size() < this.size()) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)compressed);
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)this);
    }

    public Compress.Options maybe_compress$default$1() {
        return Compress$Options$.MODULE$.apply();
    }

    public Compress.Cache maybe_compress$default$2() {
        return Compress$Cache$.MODULE$.none();
    }

    private static final /* synthetic */ long $anonfun$1(long n, byte[] c) {
        return n + (long)c.length;
    }

    private static final String toString$$anonfun$1() {
        return ", sliced";
    }

    private final IterableOnce subarray_iterator$$anonfun$1() {
        return scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{this.chunk0()}));
    }

    private static final IterableOnce $plus$$anonfun$1$$anonfun$1(Bytes other$2) {
        return other$2.subarray_iterator();
    }

    private static final Object text$$anonfun$1() {
        return "Malformed UTF-8 string: overlong result";
    }

    public static final /* synthetic */ void isabelle$Bytes$$anon$2$$_$read$$anonfun$1(byte[] buffer$1, IntRef i$1, Subarray a) {
        int l = a.length();
        if (l > 0) {
            System.arraycopy(a.array(), a.offset(), buffer$1, i$1.elem, l);
            i$1.elem += l;
            return;
        }
    }

    public static final class Builder {
        private ArrayBuffer<byte[]> chunks;
        private ListBuffer<byte[]> buffer_list;
        private byte[] buffer;
        private int buffer_index;
        private int buffer_total;

        public static Bytes use(long l, Function1<Builder, BoxedUnit> function1) {
            return Bytes$Builder$.MODULE$.use(l, function1);
        }

        public static Bytes use_stream(long l, Function1<OutputStream, BoxedUnit> function1) {
            return Bytes$Builder$.MODULE$.use_stream(l, function1);
        }

        public static long $lessinit$greater$default$1() {
            return Bytes$Builder$.MODULE$.$lessinit$greater$default$1();
        }

        public static long use$default$1() {
            return Bytes$Builder$.MODULE$.use$default$1();
        }

        public static long use_stream$default$1() {
            return Bytes$Builder$.MODULE$.use_stream$default$1();
        }

        public Builder(long hint) {
            this.chunks = new ArrayBuffer(hint <= 0L ? 16 : (int)(hint / Bytes$.MODULE$.chunk_size()));
            this.buffer_list = null;
            this.buffer = new byte[hint <= 0L ? 1024 : (int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(hint), Bytes$.MODULE$.chunk_size())), Bytes$.MODULE$.array_size())];
            this.buffer_index = 0;
            this.buffer_total = 0;
        }

        private byte[] buffer_content() {
            if (this.buffer_list != null) {
                byte[] array = new byte[this.buffer_total];
                IntRef i = IntRef.create((int)0);
                this.buffer_list.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> Bytes$.isabelle$Bytes$Builder$$_$buffer_content$$anonfun$1(array, i, arg_0)));
                System.arraycopy(this.buffer, 0, array, i.elem, this.buffer_index);
                return array;
            }
            if (this.buffer_index == this.buffer.length) {
                return this.buffer;
            }
            return Arrays.copyOf(this.buffer, this.buffer_index);
        }

        private void buffer_check(int request) {
            if (this.buffer_index == this.buffer.length) {
                if ((long)this.buffer_total == Bytes$.MODULE$.chunk_size()) {
                    this.chunks.$plus$eq((Object)this.buffer_content());
                    this.buffer_list = null;
                    this.buffer = new byte[(int)Bytes$.MODULE$.chunk_size()];
                    this.buffer_total = 0;
                    this.buffer_index = 0;
                    return;
                }
                if (this.buffer_list == null) {
                    this.buffer_list = new ListBuffer();
                }
                this.buffer_list.$plus$eq((Object)this.buffer);
                this.buffer_index = 0;
                int limit = (int)(Bytes$.MODULE$.chunk_size() - (long)this.buffer_total);
                this.buffer = new byte[RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.buffer_total), request)), limit)];
                return;
            }
        }

        private int buffer_check$default$1() {
            return 0;
        }

        public void $plus$eq(byte b) {
            this.buffer[this.buffer_index] = b;
            ++this.buffer_total;
            ++this.buffer_index;
            this.buffer_check(this.buffer_check$default$1());
        }

        public void $plus$eq(byte[] array, int offset, int length) {
            if (offset < 0 || length < 0 || (long)offset + (long)length > (long)array.length) {
                throw new IndexOutOfBoundsException();
            }
            int i = offset;
            int n = length;
            while (n > 0) {
                int l = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(n), this.buffer.length - this.buffer_index);
                System.arraycopy(array, i, this.buffer, this.buffer_index, l);
                this.buffer_total += l;
                this.buffer_index += l;
                i += l;
                this.buffer_check(n -= l);
            }
        }

        public void $plus$eq(String s) {
            if (s.length() > 0) {
                this.$plus$eq(UTF8$.MODULE$.bytes(s));
                return;
            }
        }

        public void $plus$eq(byte[] array) {
            this.$plus$eq(array, 0, array.length);
        }

        public void $plus$eq(Subarray a) {
            this.$plus$eq(a.array(), a.offset(), a.length());
        }

        public Bytes done() {
            byte[][] cs = (byte[][])this.chunks.toArray(ClassTag$.MODULE$.apply(Byte.TYPE).wrap());
            byte[] b = this.buffer_content();
            Object object = Predef$.MODULE$.refArrayOps((Object[])cs);
            long size = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(object, (Object)BoxesRunTime.boxToLong((long)b.length), Bytes$::isabelle$Bytes$Builder$$_$_$$anonfun$adapted$2));
            this.chunks = null;
            this.buffer_list = null;
            this.buffer = null;
            if (size == 0L) {
                return Bytes$.MODULE$.empty();
            }
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])cs);
            return new Bytes((Option<byte[][]>)(ArrayOps$.MODULE$.isEmpty$extension(object2) ? None$.MODULE$ : Some$.MODULE$.apply((Object)cs)), b, 0L, size);
        }
    }

    public static final class Subarray {
        private final byte[] array;
        private final int offset;
        private final int length;

        public static Subarray apply(byte[] byArray, int n, int n2) {
            return Bytes$Subarray$.MODULE$.apply(byArray, n, n2);
        }

        public static Subarray empty() {
            return Bytes$Subarray$.MODULE$.empty();
        }

        public Subarray(byte[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        public byte[] array() {
            return this.array;
        }

        public int offset() {
            return this.offset;
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return "Bytes.Subarray(" + Space$.MODULE$.print$extension(Space$.MODULE$.bytes(Int$.MODULE$.int2long(this.length()))) + ")";
        }

        public Iterator<Object> byte_iterator() {
            if (this.length() == 0) {
                return scala.package$.MODULE$.Iterator().empty();
            }
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.offset()), this.offset() + this.length()).iterator().map((Function1 & Serializable)i -> this.byte_iterator$$anonfun$2(BoxesRunTime.unboxToInt((Object)i)));
        }

        private final /* synthetic */ byte byte_iterator$$anonfun$2(int i) {
            return this.array()[i];
        }
    }

    public static class Too_Large
    extends IndexOutOfBoundsException {
        private final long size;
        private final long limit;

        public Too_Large(long size, long limit) {
            this.size = size;
            this.limit = limit;
        }

        @Override
        public String getMessage() {
            return "Bytes too large for particular operation: " + Space$.MODULE$.print$extension(Space$.MODULE$.bytes(this.size)) + " > " + Space$.MODULE$.print$extension(Space$.MODULE$.bytes(this.limit));
        }
    }
}

