/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bytes;
import isabelle.Bytes$Builder$;
import isabelle.Bytes$Subarray$;
import isabelle.File$;
import isabelle.Path;
import isabelle.Space$;
import isabelle.Url$;
import isabelle.package$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichLong$;
import scala.runtime.function.JProcedure1;

public final class Bytes$
implements Serializable {
    private static final long array_size;
    private static final long string_size;
    private static final int block_size;
    private static final long chunk_size;
    private static final Bytes empty;
    private static final Bytes newline;
    public static final Bytes$Builder$ Builder;
    public static final Bytes$Subarray$ Subarray;
    public static final Bytes$ MODULE$;

    private Bytes$() {
    }

    static {
        MODULE$ = new Bytes$();
        array_size = 0x7FFFFFF7L;
        string_size = 0x3FFFFFFFL;
        block_size = 16384;
        chunk_size = Space$.MODULE$.MiB(100.0);
        empty = new Bytes((Option<byte[][]>)None$.MODULE$, new byte[0], 0L, 0L);
        newline = MODULE$.apply("\n");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Bytes$.class);
    }

    public long array_size() {
        return array_size;
    }

    public long string_size() {
        return string_size;
    }

    public int block_size() {
        return block_size;
    }

    public long chunk_size() {
        return chunk_size;
    }

    public Bytes empty() {
        return empty;
    }

    public Bytes raw(String s) {
        if (s.isEmpty()) {
            return this.empty();
        }
        return Bytes$Builder$.MODULE$.use(Int$.MODULE$.int2long(s.length()), (Function1<Bytes.Builder, BoxedUnit>)(JProcedure1 & Serializable)builder -> builder.$plus$eq(s.getBytes(StandardCharsets.ISO_8859_1)));
    }

    public Bytes apply(String s) {
        if (s.isEmpty()) {
            return this.empty();
        }
        return Bytes$Builder$.MODULE$.use(Int$.MODULE$.int2long(s.length()), (Function1<Bytes.Builder, BoxedUnit>)(JProcedure1 & Serializable)builder -> builder.$plus$eq(s));
    }

    public Bytes apply(byte[] a) {
        return this.apply(a, 0, a.length);
    }

    public Bytes apply(byte[] a, int offset, int length) {
        return Bytes$Builder$.MODULE$.use(Int$.MODULE$.int2long(length), (Function1<Bytes.Builder, BoxedUnit>)(JProcedure1 & Serializable)builder -> builder.$plus$eq(a, offset, length));
    }

    public Bytes newline() {
        return newline;
    }

    public Bytes read_stream(InputStream stream, long limit, long hint) {
        if (limit == 0L) {
            return this.empty();
        }
        return Bytes$Builder$.MODULE$.use(limit > 0L ? limit : hint, (Function1<Bytes.Builder, BoxedUnit>)(JProcedure1 & Serializable)builder -> {
            int buf_size = MODULE$.block_size();
            byte[] buf = new byte[MODULE$.block_size()];
            int m = 0;
            long n = 0L;
            do {
                int l;
                if ((m = stream.read(buf, 0, l = limit > 0L ? (int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(limit - n), Int$.MODULE$.int2long(buf_size)) : buf_size)) <= 0) continue;
                builder.$plus$eq(buf, 0, m);
                n += (long)m;
            } while (m != -1 && (limit < 0L || limit > n));
        });
    }

    public long read_stream$default$2() {
        return -1L;
    }

    public long read_stream$default$3() {
        return 0L;
    }

    public Bytes read_url(String name) {
        return (Bytes)package$.MODULE$.using(Url$.MODULE$.apply(name).open_stream(), (Function1 & Serializable)_$1 -> this.read_stream((InputStream)_$1, this.read_stream$default$2(), this.read_stream$default$3()));
    }

    public Bytes read_file(Path path, long offset, long limit) {
        long start;
        long length = File$.MODULE$.size(path);
        long len = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(length - (start = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(offset), 0L))), 0L)), limit < 0L ? Long.MAX_VALUE : limit);
        if (len == 0L) {
            return this.empty();
        }
        return Bytes$Builder$.MODULE$.use(len, (Function1<Bytes.Builder, BoxedUnit>)(JProcedure1 & Serializable)builder -> package$.MODULE$.using(FileChannel.open(path.java_path(), StandardOpenOption.READ), (JProcedure1 & Serializable)channel -> {
            channel.position(start);
            int buf_size = MODULE$.block_size();
            ByteBuffer buf = ByteBuffer.allocate(buf_size);
            int m = 0;
            long n = 0L;
            do {
                int l = (int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(len - n), Int$.MODULE$.int2long(buf_size));
                buf.limit(l);
                m = channel.read(buf);
                if (m <= 0) continue;
                builder.$plus$eq(buf.array(), 0, m);
                buf.clear();
                n += (long)m;
            } while (m != -1 && len > n);
        }));
    }

    public long read_file$default$2() {
        return 0L;
    }

    public long read_file$default$3() {
        return -1L;
    }

    public Bytes read(Path path) {
        return this.read_file(path, this.read_file$default$2(), this.read_file$default$3());
    }

    public Bytes read(File file) {
        return this.read_file(File$.MODULE$.path(file), this.read_file$default$2(), this.read_file$default$3());
    }

    public void write(File file, Bytes bytes) {
        package$.MODULE$.using(new FileOutputStream(file), (JProcedure1 & Serializable)stream -> bytes.write_stream((OutputStream)stream));
    }

    public void write(Path path, Bytes bytes) {
        this.write(path.file(), bytes);
    }

    public void append(File file, Bytes bytes) {
        package$.MODULE$.using(new FileOutputStream(file, true), (JProcedure1 & Serializable)stream -> bytes.write_stream((OutputStream)stream));
    }

    public void append(Path path, Bytes bytes) {
        this.append(path.file(), bytes);
    }

    public static final /* synthetic */ void isabelle$Bytes$Builder$$_$buffer_content$$anonfun$1(byte[] array$1, IntRef i$2, byte[] b) {
        int n = b.length;
        System.arraycopy(b, 0, array$1, i$2.elem, n);
        i$2.elem += n;
    }

    private static final /* synthetic */ long $anonfun$2(long x$1, byte[] x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)x$1), (Object)x$2);
        if (tuple2 != null) {
            long n = BoxesRunTime.unboxToLong((Object)tuple2._1());
            byte[] a = (byte[])tuple2._2();
            return n + (long)a.length;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* bridge */ /* synthetic */ long isabelle$Bytes$Builder$$_$_$$anonfun$adapted$2(Object x$1, Object x$2) {
        return Bytes$.$anonfun$2(BoxesRunTime.unboxToLong((Object)x$1), (byte[])x$2);
    }
}

