/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Build;
import isabelle.Build$Results$;
import isabelle.Build_Cluster;
import isabelle.Build_Cluster$;
import isabelle.Build_Cluster$none$;
import isabelle.Build_Job;
import isabelle.Build_Job$;
import isabelle.Build_Job$Session_Context$;
import isabelle.Build_Log$;
import isabelle.Build_Process$;
import isabelle.Build_Process$Build$;
import isabelle.Build_Process$Job$;
import isabelle.Build_Process$Result$;
import isabelle.Build_Process$Sessions$;
import isabelle.Build_Process$Snapshot$;
import isabelle.Build_Process$State$;
import isabelle.Build_Process$Task$;
import isabelle.Build_Process$Worker$;
import isabelle.Build_Process$private_data$;
import isabelle.Database_Progress;
import isabelle.Database_Progress$private_data$;
import isabelle.Date;
import isabelle.Graph;
import isabelle.Host;
import isabelle.Host$;
import isabelle.Host$Node_Info$;
import isabelle.Host$private_data$;
import isabelle.Isabelle_Thread;
import isabelle.Isabelle_Thread$;
import isabelle.Library$;
import isabelle.Logger;
import isabelle.Logger$;
import isabelle.Long_Name$;
import isabelle.ML_Heap$;
import isabelle.Name;
import isabelle.Options;
import isabelle.Process_Result;
import isabelle.Process_Result$;
import isabelle.Progress;
import isabelle.SHA1;
import isabelle.SQL;
import isabelle.SSH;
import isabelle.Sessions;
import isabelle.Sessions$;
import isabelle.Store;
import isabelle.Store$private_data$;
import isabelle.Symbol$;
import isabelle.Time;
import isabelle.Time$;
import isabelle.UUID$;
import isabelle.Update;
import isabelle.package$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class Build_Process
implements AutoCloseable {
    private final Build.Context build_context;
    private final Progress build_progress;
    private final SSH.Server server;
    private final Store store;
    private final Options build_options;
    private final Sessions.Deps build_deps;
    private final String hostname;
    private final String build_uuid;
    private Set<String> warning_seen;
    private final Option _database_server;
    private final Option _heaps_database;
    private final Option _build_database;
    private final long build_delay;
    private final int build_expire;
    private final SQL.Database _host_database;
    private final Progress progress;
    private final String worker_uuid;
    private final Logger log;
    private final Date build_start;
    private final long build_id;
    private final Build_Cluster _build_cluster;
    private State _state;
    private long _build_tick;

    public static long init_build(SQL.Database database, Build.Context context, Date date) {
        return Build_Process$.MODULE$.init_build(database, context, date);
    }

    public static List<Build> read_builds(SQL.Database database) {
        return Build_Process$.MODULE$.read_builds(database);
    }

    public Build_Process(Build.Context build_context, Progress build_progress, SSH.Server server) {
        Build_Cluster build_Cluster;
        long l;
        Tuple2 tuple2;
        SQL.Database database;
        Option option;
        Option<SQL.Database> option2;
        Option<SQL.Database> option3;
        this.build_context = build_context;
        this.build_progress = build_progress;
        this.server = server;
        this.store = build_context.store();
        this.build_options = this.store().options();
        this.build_deps = build_context.deps();
        this.hostname = build_context.hostname();
        this.build_uuid = build_context.build_uuid();
        this.warning_seen = Predef$.MODULE$.Set().empty();
        Build_Process build_Process = this;
        try {
            option3 = this.store().maybe_open_database_server(server, this.store().maybe_open_database_server$default$2());
        }
        catch (Throwable exn) {
            this.close();
            throw exn;
        }
        Option<SQL.Database> option4 = option3;
        Build_Process build_Process2 = build_Process;
        build_Process = null;
        Option<SQL.Database> option5 = option4;
        option4 = null;
        build_Process2._database_server = option5;
        Build_Process build_Process3 = this;
        try {
            option2 = this.store().maybe_open_heaps_database(this._database_server(), server);
        }
        catch (Throwable exn) {
            this.close();
            throw exn;
        }
        Option<SQL.Database> option6 = option2;
        Build_Process build_Process4 = build_Process3;
        build_Process3 = null;
        Option<SQL.Database> option7 = option6;
        option6 = null;
        build_Process4._heaps_database = option7;
        Build_Process build_Process5 = this;
        try {
            option = this.store().maybe_open_build_database(this.store().maybe_open_build_database$default$1(), server).map((Function1 & Serializable)db -> {
                if (!db.is_postgresql()) {
                    package$.MODULE$.error().apply((Object)"Distributed build requires PostgreSQL (option build_database_server)");
                }
                boolean store_tables = db.is_postgresql();
                Build_Process$private_data$.MODULE$.transaction_lock((SQL.Database)db, true, "Build_Process.build_database", Build_Process$private_data$.MODULE$.transaction_lock$default$4(), (Function0 & Serializable)() -> {
                    Build_Process.$init$$$anonfun$1$$anonfun$1(db, store_tables);
                    return BoxedUnit.UNIT;
                });
                if (build_context.master()) {
                    db.vacuum(Build_Process$private_data$.MODULE$.tables().list());
                    if (store_tables) {
                        db.vacuum(Store$private_data$.MODULE$.tables().list());
                    }
                }
                return db;
            });
        }
        catch (Throwable exn) {
            this.close();
            throw exn;
        }
        Option option8 = option;
        Build_Process build_Process6 = build_Process5;
        build_Process5 = null;
        Option option9 = option8;
        option8 = null;
        build_Process6._build_database = option9;
        this.build_delay = this.build_options().seconds(!this.build_cluster() ? "build_delay" : (build_context.master() ? "build_delay_master" : "build_delay_worker"));
        this.build_expire = !this.build_cluster() || build_context.master() ? 1 : RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)this.build_options().int().apply("build_cluster_expire"))), 1);
        Build_Process build_Process7 = this;
        try {
            database = this.store().open_build_database(Host$private_data$.MODULE$.database(), server);
        }
        catch (Throwable exn) {
            this.close();
            throw exn;
        }
        SQL.Database database2 = database;
        Build_Process build_Process8 = build_Process7;
        build_Process7 = null;
        SQL.Database database3 = database2;
        database2 = null;
        build_Process8._host_database = database3;
        Build_Process build_Process9 = this;
        synchronized (build_Process9) {
            Tuple2 tuple22;
            block22: {
                if (this._build_database().isEmpty()) {
                    tuple22 = Tuple2$.MODULE$.apply((Object)build_progress, (Object)UUID$.MODULE$.random_string());
                    break block22;
                }
                try {
                    SQL.Database db2 = this.store().open_build_database(Database_Progress$private_data$.MODULE$.database(), server);
                    Some some = Some$.MODULE$.apply((Object)new Time(this.build_delay()));
                    Database_Progress progress = new Database_Progress(db2, build_progress, build_context.master(), "build_process", this.hostname(), this.build_uuid(), (Option<Time>)some, this.build_expire());
                    tuple22 = Tuple2$.MODULE$.apply((Object)progress, (Object)progress.agent_uuid());
                }
                catch (Throwable exn) {
                    this.close();
                    throw exn;
                }
            }
            tuple2 = tuple22;
        }
        Tuple2 tuple23 = tuple2;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Progress progress = (Progress)tuple23._1();
        String worker_uuid = (String)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)progress, (Object)worker_uuid);
        this.progress = (Progress)tuple24._1();
        this.worker_uuid = (String)tuple24._2();
        this.log = Logger$.MODULE$.make_system_log((Function0<Progress>)((Function0 & Serializable)this::$init$$$anonfun$2), this.build_options(), Logger$.MODULE$.make_system_log$default$3());
        this.build_start = (Date)build_context.build_start().getOrElse(this::$init$$$anonfun$3);
        Option<SQL.Database> option10 = this._build_database();
        if (None$.MODULE$.equals(option10)) {
            l = 0L;
        } else if (option10 instanceof Some) {
            SQL.Database db3 = (SQL.Database)((Some)option10).value();
            l = Build_Process$.MODULE$.init_build(db3, build_context, this.build_start());
        } else {
            throw new MatchError(option10);
        }
        this.build_id = l;
        Build_Process build_Process10 = this;
        try {
            build_Cluster = build_context.master() && this._build_database().isDefined() ? this.open_build_cluster() : Build_Cluster$none$.MODULE$;
        }
        catch (Throwable exn) {
            this.close();
            throw exn;
        }
        Build_Cluster$none$ build_Cluster$none$ = build_Cluster;
        Build_Process build_Process11 = build_Process10;
        build_Process10 = null;
        Build_Cluster$none$ build_Cluster$none$2 = build_Cluster$none$;
        build_Cluster$none$ = null;
        build_Process11._build_cluster = build_Cluster$none$2;
        this._state = Build_Process$State$.MODULE$.apply(Build_Process$State$.MODULE$.$lessinit$greater$default$1(), Build_Process$State$.MODULE$.$lessinit$greater$default$2(), Build_Process$State$.MODULE$.$lessinit$greater$default$3(), Build_Process$State$.MODULE$.$lessinit$greater$default$4(), Build_Process$State$.MODULE$.$lessinit$greater$default$5());
        this._build_tick = 0L;
    }

    public final Build.Context build_context() {
        return this.build_context;
    }

    public final Progress build_progress() {
        return this.build_progress;
    }

    public final SSH.Server server() {
        return this.server;
    }

    public final Store store() {
        return this.store;
    }

    public final Options build_options() {
        return this.build_options;
    }

    public final Sessions.Deps build_deps() {
        return this.build_deps;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String build_uuid() {
        return this.build_uuid;
    }

    public void warning(String msg) {
        Build_Process build_Process = this;
        synchronized (build_Process) {
            if (!this.warning_seen.apply((Object)msg)) {
                this.build_progress().echo_warning(msg, this.build_progress().echo_warning$default$2());
                this.warning_seen = (Set)this.warning_seen.$plus((Object)msg);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
        }
    }

    public Option<SQL.Database> _database_server() {
        return this._database_server;
    }

    public Option<SQL.Database> _heaps_database() {
        return this._heaps_database;
    }

    public Option<SQL.Database> _build_database() {
        return this._build_database;
    }

    public List<SQL.Notification> build_receive(Function1<SQL.Notification, Object> filter) {
        return (List)this._build_database().flatMap((Function1 & Serializable)_$17 -> _$17.receive(filter)).getOrElse(Build_Process::build_receive$$anonfun$2);
    }

    public void build_send(SQL.Notification notification) {
        this._build_database().foreach((Function1)(JProcedure1 & Serializable)_$18 -> _$18.send(notification));
    }

    public boolean build_cluster() {
        Option<SQL.Database> option = this._build_database();
        if (option instanceof Some) {
            SQL.Database db = (SQL.Database)((Some)option).value();
            return db.is_postgresql();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public long build_delay() {
        return this.build_delay;
    }

    public int build_expire() {
        return this.build_expire;
    }

    public SQL.Database _host_database() {
        return this._host_database;
    }

    public Progress progress() {
        return this.progress;
    }

    public String worker_uuid() {
        return this.worker_uuid;
    }

    public Logger log() {
        return this.log;
    }

    public Date build_start() {
        return this.build_start;
    }

    public long build_id() {
        return this.build_id;
    }

    public Build_Cluster open_build_cluster() {
        return Build_Cluster$.MODULE$.make(this.build_context(), this.build_progress()).open();
    }

    public Build_Cluster _build_cluster() {
        return this._build_cluster;
    }

    @Override
    public void close() {
        Build_Process build_Process = this;
        synchronized (build_Process) {
            Option$.MODULE$.apply(this._database_server()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).foreach((Function1)(JProcedure1 & Serializable)_$19 -> _$19.close());
            Option$.MODULE$.apply(this._heaps_database()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).foreach((Function1)(JProcedure1 & Serializable)_$20 -> _$20.close());
            Option$.MODULE$.apply(this._build_database()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).foreach((Function1)(JProcedure1 & Serializable)_$21 -> _$21.close());
            Option$.MODULE$.apply((Object)this._host_database()).foreach((Function1)(JProcedure1 & Serializable)_$22 -> _$22.close());
            Option$.MODULE$.apply((Object)this._build_cluster()).foreach((Function1)(JProcedure1 & Serializable)_$23 -> _$23.close());
            Progress progress = this.progress();
            if (progress instanceof Database_Progress) {
                Database_Progress db_progress = (Database_Progress)progress;
                db_progress.close();
            }
        }
    }

    public State _state() {
        return this._state;
    }

    public void _state_$eq(State x$1) {
        this._state = x$1;
    }

    public <A> A synchronized_database(String label, Function0<A> body) {
        Object object;
        Build_Process build_Process = this;
        synchronized (build_Process) {
            Object object2;
            Option<SQL.Database> option = this._build_database();
            if (None$.MODULE$.equals(option)) {
                object2 = body.apply();
            } else if (option instanceof Some) {
                SQL.Database db = (SQL.Database)((Some)option).value();
                object2 = Build_Process$private_data$.MODULE$.transaction_lock(db, Build_Process$private_data$.MODULE$.transaction_lock$default$2(), label, Build_Process$private_data$.MODULE$.transaction_lock$default$4(), () -> this.synchronized_database$$anonfun$1(db, body));
            } else {
                throw new MatchError(option);
            }
            object = object2;
        }
        return (A)object;
    }

    public List<String> next_jobs(State state) {
        int limit;
        int n = this.progress().stopped() ? (this.build_context().master() ? Integer.MAX_VALUE : 0) : (limit = this.build_context().jobs() - state.build_running().length());
        if (limit > 0) {
            return ((List)state.next_ready().sortBy((Function1 & Serializable)_$24 -> _$24.name(), state.sessions().ordering())).take(limit).map((Function1 & Serializable)_$25 -> _$25.name());
        }
        return scala.package$.MODULE$.Nil();
    }

    public Host.Node_Info next_node_info(State state, String session_name) {
        List<Object> available_nodes = this.build_context().numa_nodes();
        Set used_nodes = Predef$.MODULE$.Set().from((IterableOnce)state.running().valuesIterator().flatMap((Function1 & Serializable)job -> job.node_info().numa_node().map((Function1)(JFunction1.mcII.sp & Serializable)i -> i)));
        Option<Object> numa_node = Host$.MODULE$.next_numa_node(this._host_database(), this.hostname(), available_nodes, (Function0<Set<Object>>)((Function0 & Serializable)() -> Build_Process.$anonfun$2(used_nodes)));
        return Host$Node_Info$.MODULE$.apply(this.hostname(), numa_node, (List<Object>)scala.package$.MODULE$.Nil());
    }

    public State start_session(State state, String session_name, List<Result> ancestor_results) {
        boolean cancelled;
        SHA1.Shasum sources_shasum = state.sessions().apply(session_name).sources_shasum();
        SHA1.Shasum input_shasum = this.store().make_shasum((List<SHA1.Shasum>)ancestor_results.map((Function1 & Serializable)_$26 -> _$26.output_shasum()));
        boolean store_heap = this.build_context().store_heap() || state.sessions().store_heap(session_name);
        Tuple2<Object, SHA1.Shasum> tuple2 = this.store().check_output(this._database_server(), session_name, sources_shasum, input_shasum, this.build_context().sessions_structure().apply(session_name).build_thorough(), this.build_context().fresh_build(), store_heap);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean current = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
        SHA1.Shasum output_shasum = (SHA1.Shasum)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)current), (Object)output_shasum);
        boolean current2 = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
        SHA1.Shasum output_shasum2 = (SHA1.Shasum)tuple22._2();
        boolean finished = current2 && ancestor_results.forall((Function1 & Serializable)_$27 -> _$27.current());
        boolean skipped = this.build_context().no_build();
        boolean bl = cancelled = this.progress().stopped() || !ancestor_results.forall((Function1 & Serializable)_$28 -> _$28.ok());
        if (!skipped && !cancelled) {
            this._database_server().orElse(this::start_session$$anonfun$1).foreach((Function1)(JProcedure1 & Serializable)db -> {
                List hierarchy = ancestor_results.map((Function1 & Serializable)_$29 -> _$29.name()).$colon$colon((Object)session_name).map((Function1 & Serializable)_$30 -> this.store().output_session((String)_$30, true));
                ML_Heap$.MODULE$.restore((SQL.Database)db, (List<Store.Session>)hierarchy, this.store().cache().compress(), ML_Heap$.MODULE$.restore$default$4());
            });
        }
        Tuple3 result_name = Tuple3$.MODULE$.apply((Object)session_name, (Object)this.worker_uuid(), (Object)this.build_uuid());
        Date start = this.progress().now();
        if (finished) {
            State state2 = state.remove_pending(session_name);
            Process_Result process_Result = Process_Result$.MODULE$.ok();
            Host.Node_Info node_Info = state2.make_result$default$5();
            return state2.make_result((Tuple3<String, String, String>)result_name, process_Result, output_shasum2, start, node_Info, true);
        }
        if (skipped) {
            this.progress().echo("Skipping " + session_name + " ...", true);
            State state3 = state.remove_pending(session_name);
            return state3.make_result((Tuple3<String, String, String>)result_name, Process_Result$.MODULE$.error(), output_shasum2, start, state3.make_result$default$5(), state3.make_result$default$6());
        }
        if (cancelled) {
            this.progress().echo(session_name + " CANCELLED", this.progress().echo$default$2());
            State state4 = state.remove_pending(session_name);
            return state4.make_result((Tuple3<String, String, String>)result_name, Process_Result$.MODULE$.undefined(), output_shasum2, start, state4.make_result$default$5(), state4.make_result$default$6());
        }
        boolean build_log_verbose = BoxesRunTime.unboxToBoolean((Object)this.build_options().bool().apply("build_log_verbose"));
        long start_time = start.$minus(this.build_start());
        boolean start_time_msg = build_log_verbose;
        Host.Node_Info node_info = this.next_node_info(state, session_name);
        boolean node_info_msg = node_info.numa() || build_log_verbose;
        this.progress().echo((store_heap ? "Building " : "Running ") + session_name + package$.MODULE$.if_proper(start_time_msg || node_info_msg, (Function0<String>)((Function0 & Serializable)() -> Build_Process.start_session$$anonfun$3(start_time_msg, start_time, node_info_msg, node_info))) + " ...", this.progress().echo$default$2());
        Build_Job.Session_Context session = state.sessions().apply(session_name);
        Sessions.Background background = this.build_deps().background(session_name);
        Build_Job.Session_Job build = Build_Job$.MODULE$.start_session(this.build_context(), session, this.progress(), this.log(), this.server(), background, sources_shasum, input_shasum, node_info, store_heap);
        return state.add_running(Build_Process$Job$.MODULE$.apply(session_name, this.worker_uuid(), this.build_uuid(), node_info, start, (Option<Build_Job>)Some$.MODULE$.apply((Object)build)));
    }

    public final boolean is_session_name(String job_name) {
        return !Long_Name$.MODULE$.is_qualified(job_name);
    }

    public final void stop_build() {
        this.synchronized_database("Build_Process.stop_build", (Function0 & Serializable)() -> {
            this.stop_build$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public final void start_worker() {
        this.synchronized_database("Build_Process.start_worker", (Function0 & Serializable)() -> {
            this.start_worker$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public final void stop_worker() {
        this.synchronized_database("Build_Process.stop_worker", (Function0 & Serializable)() -> {
            this.stop_worker$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public void prepare() {
        this.build_context().clean_sessions().foreach((Function1)(JProcedure1 & Serializable)name -> {
            Option option = this._database_server().orElse(this::$anonfun$8);
            boolean bl = this.store().clean_output$default$3();
            this.store().clean_output((Option<SQL.Database>)option, (String)name, bl, this.progress());
        });
    }

    public boolean finished() {
        boolean bl;
        Build_Process build_Process = this;
        synchronized (build_Process) {
            bl = !this.build_context().master() && this.progress().stopped() ? this._state().build_running().isEmpty() : this._state().pending().isEmpty();
        }
        return bl;
    }

    public boolean build_action() {
        return BoxesRunTime.unboxToBoolean(Isabelle_Thread$.MODULE$.interrupt_handler((Function1<Isabelle_Thread, BoxedUnit>)(JProcedure1 & Serializable)_$31 -> this.progress().stop(), this::build_action$$anonfun$2));
    }

    public void init_unsynchronized() {
        if (this.build_context().master()) {
            Sessions sessions1 = this._state().sessions().init(this.build_context(), this._database_server(), this.build_progress());
            Map pending1 = (Map)sessions1.iterator().foldLeft(this._state().pending(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Build_Job.Session_Context session;
                    Map map = (Map)tuple2._1();
                    if (map.isDefinedAt((Object)(session = (Build_Job.Session_Context)tuple2._2()).name())) {
                        return map;
                    }
                    return (Map)map.$plus(Build_Process$Task$.MODULE$.entry(session, this.build_context()));
                }
                throw new MatchError((Object)tuple2);
            });
            State state = this._state();
            this._state_$eq(state.copy(state.copy$default$1(), sessions1, (Map<String, Task>)pending1, state.copy$default$4(), state.copy$default$5()));
            return;
        }
    }

    public void main_unsynchronized() {
        this._state().running().valuesIterator().foreach((Function1)(JProcedure1 & Serializable)job -> job.build().withFilter((Function1 & Serializable)build -> build.is_finished()).foreach((Function1)(JProcedure1 & Serializable)build -> {
            Build_Job.Result result = build.join();
            Tuple3 result_name = Tuple3$.MODULE$.apply((Object)job.name(), (Object)this.worker_uuid(), (Object)this.build_uuid());
            State state = this._state().remove_pending(job.name()).remove_running(job.name());
            this._state_$eq(state.make_result((Tuple3<String, String, String>)result_name, result.process_result(), result.output_shasum(), job.start_date(), job.node_info(), state.make_result$default$6()));
        }));
        this.next_jobs(this._state()).foreach((Function1)(JProcedure1 & Serializable)name -> {
            if (this.is_session_name((String)name)) {
                if (this.build_context().sessions_structure().defined((String)name)) {
                    Option<List<Result>> option = this._state().ancestor_results((String)name);
                    if (option instanceof Some) {
                        List results = (List)((Some)option).value();
                        this._state_$eq(this.start_session(this._state(), (String)name, (List<Result>)results));
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.warning("Bad build job " + package$.MODULE$.quote().apply(name) + ": no ancestor results");
                        return;
                    }
                    throw new MatchError(option);
                }
                this.warning("Bad build job " + package$.MODULE$.quote().apply(name) + ": no session info");
                return;
            }
            this.warning("Bad build job " + package$.MODULE$.quote().apply(name));
        });
    }

    public Build.Results run() {
        boolean vacuous = BoxesRunTime.unboxToBoolean(this.synchronized_database("Build_Process.init", this::$anonfun$11));
        if (vacuous) {
            this.progress().echo_warning("Nothing to build", this.progress().echo_warning$default$2());
            if (this.build_context().master()) {
                this.stop_build();
            }
            return Build$Results$.MODULE$.apply(this.build_context(), Build$Results$.MODULE$.apply$default$2(), Build$Results$.MODULE$.apply$default$3());
        }
        this.start_worker();
        this._build_cluster().start();
        try {
            while (!this.finished()) {
                this.synchronized_database("Build_Process.main", (Function0 & Serializable)() -> {
                    this.run$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
                while (!this.build_action()) {
                }
            }
        }
        finally {
            this._build_cluster().stop();
            this.stop_worker();
            if (this.build_context().master()) {
                this.stop_build();
            }
        }
        return (Build.Results)this.synchronized_database("Build_Process.result", this::run$$anonfun$2);
    }

    public Snapshot snapshot() {
        return (Snapshot)this.synchronized_database("Build_Process.snapshot", this::snapshot$$anonfun$1);
    }

    public String toString() {
        return "Build_Process(worker_uuid = " + package$.MODULE$.quote().apply((Object)this.worker_uuid()) + ", build_uuid = " + package$.MODULE$.quote().apply((Object)this.build_uuid()) + package$.MODULE$.if_proper(this.build_context().master(), (Function0<String>)((Function0 & Serializable)Build_Process::toString$$anonfun$1)) + ")";
    }

    private static final void $init$$$anonfun$1$$anonfun$1(SQL.Database db$1, boolean store_tables$1) {
        Build_Process$private_data$.MODULE$.clean_build(db$1);
        if (store_tables$1) {
            Store$private_data$.MODULE$.tables().lock(db$1, true);
            return;
        }
    }

    private final Progress $init$$$anonfun$2() {
        return this.progress();
    }

    private final Date $init$$$anonfun$3() {
        return this.progress().now();
    }

    private static final List build_receive$$anonfun$2() {
        return scala.package$.MODULE$.Nil();
    }

    private final Object synchronized_database$$anonfun$1(SQL.Database db$2, Function0 body$7) {
        State old_state = Build_Process$private_data$.MODULE$.pull_state(db$2, this.build_id(), this.worker_uuid(), this._state());
        this._state_$eq(old_state);
        Object res = body$7.apply();
        this._state_$eq(Build_Process$private_data$.MODULE$.push_state(db$2, this.build_id(), this.worker_uuid(), this._state(), old_state));
        return res;
    }

    private static final Set $anonfun$2(Set used_nodes$1) {
        return used_nodes$1;
    }

    private final Option start_session$$anonfun$1() {
        return this._heaps_database();
    }

    private static final String start_session$$anonfun$3$$anonfun$1(long start_time$2) {
        return "started " + Time$.MODULE$.message_hms$extension(start_time$2);
    }

    private static final String start_session$$anonfun$3$$anonfun$2() {
        return " ";
    }

    private static final String start_session$$anonfun$3$$anonfun$3(Host.Node_Info node_info$3) {
        return "on " + node_info$3.toString();
    }

    private static final String start_session$$anonfun$3(boolean start_time_msg$1, long start_time$1, boolean node_info_msg$1, Host.Node_Info node_info$2) {
        return " (" + package$.MODULE$.if_proper(start_time_msg$1, (Function0<String>)((Function0 & Serializable)() -> Build_Process.start_session$$anonfun$3$$anonfun$1(start_time$1))) + package$.MODULE$.if_proper(start_time_msg$1 && node_info_msg$1, (Function0<String>)((Function0 & Serializable)Build_Process::start_session$$anonfun$3$$anonfun$2)) + package$.MODULE$.if_proper(node_info_msg$1, (Function0<String>)((Function0 & Serializable)() -> Build_Process.start_session$$anonfun$3$$anonfun$3(node_info$2))) + ")";
    }

    private final void stop_build$$anonfun$1() {
        this._build_database().foreach((Function1)(JProcedure1 & Serializable)db -> Build_Process$private_data$.MODULE$.stop_build((SQL.Database)db, this.build_uuid()));
    }

    private final void start_worker$$anonfun$1() {
        this._build_database().foreach((Function1)(JProcedure1 & Serializable)db -> {
            State state = this._state();
            this._state_$eq(state.copy(this._state().next_serial(), state.copy$default$2(), state.copy$default$3(), state.copy$default$4(), state.copy$default$5()));
            Build_Process$private_data$.MODULE$.start_worker((SQL.Database)db, this.worker_uuid(), this.build_uuid(), this._state().serial());
        });
    }

    private final void stop_worker$$anonfun$1() {
        this._build_database().foreach((Function1)(JProcedure1 & Serializable)db -> Build_Process$private_data$.MODULE$.stamp_worker((SQL.Database)db, this.worker_uuid(), this._state().serial(), true));
    }

    private final Option $anonfun$8() {
        return this._heaps_database();
    }

    private static final /* synthetic */ boolean $anonfun$9(SQL.Notification n) {
        String string = n.channel();
        String string2 = Build_Process$private_data$.MODULE$.channel();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final boolean sleep$1(boolean reactive$1) {
        boolean bl;
        Time$.MODULE$.sleep$extension(this.build_delay());
        Build_Process build_Process = this;
        synchronized (build_Process) {
            ++this._build_tick;
            bl = this._build_tick % (long)this.build_expire() == 0L;
        }
        boolean expired = bl;
        return expired || reactive$1 || this.progress().stopped();
    }

    /*
     * Unable to fully structure code
     */
    private final boolean build_action$$anonfun$2() {
        received = this.build_receive((Function1<SQL.Notification, Object>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$9(isabelle.SQL$Notification ), (Lisabelle/SQL$Notification;)Z)());
        ready = received.contains((Object)Build_Process$private_data$.MODULE$.channel_ready());
        if (!ready) ** GOTO lbl-1000
        var4_3 = this;
        synchronized (var4_3) {
            var5_4 = this._state().busy_running(this.build_context().jobs()) == false;
        }
        if (var5_4) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reactive = v1;
        var7_6 = this;
        synchronized (var7_6) {
            var8_7 = this._state().finished_running();
        }
        finished = var8_7;
        return finished != false || this.sleep$1(reactive) != false;
    }

    private final boolean $anonfun$11() {
        this._build_cluster().init();
        this.init_unsynchronized();
        return this.build_context().master() && this._state().pending().isEmpty();
    }

    private final void run$$anonfun$1() {
        if (this.progress().stopped()) {
            this._state().build_running().foreach((Function1)(JProcedure1 & Serializable)_$32 -> _$32.cancel());
        }
        this.main_unsynchronized();
        if (this.build_context().master() && this._state().exists_ready()) {
            this.build_send(Build_Process$private_data$.MODULE$.channel_ready());
            return;
        }
    }

    private final Build.Results run$$anonfun$2() {
        Map results = (Map)this._state().results().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Result result = (Result)tuple2._2();
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Result result = (Result)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)result.process_result());
            }
            throw new MatchError((Object)tuple2);
        });
        return Build$Results$.MODULE$.apply(this.build_context(), (Map<String, Process_Result>)results, this._build_cluster().rc());
    }

    private final Snapshot snapshot$$anonfun$1() {
        Tuple2 tuple2;
        Option<SQL.Database> option = this._build_database();
        if (None$.MODULE$.equals(option)) {
            tuple2 = Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.Nil(), (Object)scala.package$.MODULE$.Nil());
        } else if (option instanceof Some) {
            SQL.Database db = (SQL.Database)((Some)option).value();
            tuple2 = Tuple2$.MODULE$.apply(Build_Process$private_data$.MODULE$.read_builds(db), Build_Process$private_data$.MODULE$.read_workers(db, Build_Process$private_data$.MODULE$.read_workers$default$2(), Build_Process$private_data$.MODULE$.read_workers$default$3()));
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple22 = tuple2;
        List builds = (List)tuple22._1();
        List workers = (List)tuple22._2();
        return Build_Process$Snapshot$.MODULE$.apply((List<Build>)builds, (List<Worker>)workers, this._state().sessions(), this._state().pending(), this._state().running(), this._state().results());
    }

    private static final String toString$$anonfun$1() {
        return ", master = true";
    }

    public static class Build
    implements Product,
    Serializable {
        private final String build_uuid;
        private final long build_id;
        private final String ml_platform;
        private final String options;
        private final Date start;
        private final Option stop;
        private final List sessions;

        public static Build apply(String string, long l, String string2, String string3, Date date, Option<Date> option, List<String> list) {
            return Build_Process$Build$.MODULE$.apply(string, l, string2, string3, date, option, list);
        }

        public static Build fromProduct(Product product) {
            return Build_Process$Build$.MODULE$.fromProduct(product);
        }

        public static Build unapply(Build build) {
            return Build_Process$Build$.MODULE$.unapply(build);
        }

        public Build(String build_uuid, long build_id, String ml_platform, String options, Date start, Option<Date> stop, List<String> sessions) {
            this.build_uuid = build_uuid;
            this.build_id = build_id;
            this.ml_platform = ml_platform;
            this.options = options;
            this.start = start;
            this.stop = stop;
            this.sessions = sessions;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.build_uuid()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.build_id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ml_platform()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.options()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.start()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.stop()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.sessions()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Build)) return false;
            Build build = (Build)object;
            if (this.build_id() != build.build_id()) return false;
            String string = this.build_uuid();
            String string2 = build.build_uuid();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.ml_platform();
            String string4 = build.ml_platform();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.options();
            String string6 = build.options();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Date date = this.start();
            Date date2 = build.start();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            Option<Date> option = this.stop();
            Option<Date> option2 = build.stop();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            List<String> list = this.sessions();
            List<String> list2 = build.sessions();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!build.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Build;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "Build";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "build_uuid";
                }
                case 1: {
                    return "build_id";
                }
                case 2: {
                    return "ml_platform";
                }
                case 3: {
                    return "options";
                }
                case 4: {
                    return "start";
                }
                case 5: {
                    return "stop";
                }
                case 6: {
                    return "sessions";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String build_uuid() {
            return this.build_uuid;
        }

        public long build_id() {
            return this.build_id;
        }

        public String ml_platform() {
            return this.ml_platform;
        }

        public String options() {
            return this.options;
        }

        public Date start() {
            return this.start;
        }

        public Option<Date> stop() {
            return this.stop;
        }

        public List<String> sessions() {
            return this.sessions;
        }

        public boolean active() {
            return this.stop().isEmpty();
        }

        public Option<String> active_build_uuid() {
            if (this.active()) {
                return Some$.MODULE$.apply((Object)this.build_uuid());
            }
            return None$.MODULE$;
        }

        public String print() {
            return this.build_uuid() + " (platform: " + this.ml_platform() + ", start: " + Build_Log$.MODULE$.print_date(this.start()) + package$.MODULE$.if_proper(Option$.MODULE$.option2Iterable(this.stop()), (Function0<String>)((Function0 & Serializable)this::print$$anonfun$1)) + ")";
        }

        public Build copy(String build_uuid, long build_id, String ml_platform, String options, Date start, Option<Date> stop, List<String> sessions) {
            return new Build(build_uuid, build_id, ml_platform, options, start, stop, sessions);
        }

        public String copy$default$1() {
            return this.build_uuid();
        }

        public long copy$default$2() {
            return this.build_id();
        }

        public String copy$default$3() {
            return this.ml_platform();
        }

        public String copy$default$4() {
            return this.options();
        }

        public Date copy$default$5() {
            return this.start();
        }

        public Option<Date> copy$default$6() {
            return this.stop();
        }

        public List<String> copy$default$7() {
            return this.sessions();
        }

        public String _1() {
            return this.build_uuid();
        }

        public long _2() {
            return this.build_id();
        }

        public String _3() {
            return this.ml_platform();
        }

        public String _4() {
            return this.options();
        }

        public Date _5() {
            return this.start();
        }

        public Option<Date> _6() {
            return this.stop();
        }

        public List<String> _7() {
            return this.sessions();
        }

        private final String print$$anonfun$1() {
            return ", stop: " + Build_Log$.MODULE$.print_date((Date)this.stop().get());
        }
    }

    public static class Job
    implements Name.T,
    Product,
    Serializable {
        private final String name;
        private final String worker_uuid;
        private final String build_uuid;
        private final Host.Node_Info node_info;
        private final Date start_date;
        private final Option build;

        public static Job apply(String string, String string2, String string3, Host.Node_Info node_Info, Date date, Option<Build_Job> option) {
            return Build_Process$Job$.MODULE$.apply(string, string2, string3, node_Info, date, option);
        }

        public static Job fromProduct(Product product) {
            return Build_Process$Job$.MODULE$.fromProduct(product);
        }

        public static Job unapply(Job job) {
            return Build_Process$Job$.MODULE$.unapply(job);
        }

        public Job(String name, String worker_uuid, String build_uuid, Host.Node_Info node_info, Date start_date, Option<Build_Job> build) {
            this.name = name;
            this.worker_uuid = worker_uuid;
            this.build_uuid = build_uuid;
            this.node_info = node_info;
            this.start_date = start_date;
            this.build = build;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Job)) return false;
            Job job = (Job)object;
            String string = this.name();
            String string2 = job.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.worker_uuid();
            String string4 = job.worker_uuid();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.build_uuid();
            String string6 = job.build_uuid();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Host.Node_Info node_Info = this.node_info();
            Host.Node_Info node_Info2 = job.node_info();
            if (node_Info == null) {
                if (node_Info2 != null) {
                    return false;
                }
            } else if (!((Object)node_Info).equals(node_Info2)) return false;
            Date date = this.start_date();
            Date date2 = job.start_date();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            Option<Build_Job> option = this.build();
            Option<Build_Job> option2 = job.build();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!job.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Job;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "Job";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "worker_uuid";
                }
                case 2: {
                    return "build_uuid";
                }
                case 3: {
                    return "node_info";
                }
                case 4: {
                    return "start_date";
                }
                case 5: {
                    return "build";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String name() {
            return this.name;
        }

        public String worker_uuid() {
            return this.worker_uuid;
        }

        public String build_uuid() {
            return this.build_uuid;
        }

        public Host.Node_Info node_info() {
            return this.node_info;
        }

        public Date start_date() {
            return this.start_date;
        }

        public Option<Build_Job> build() {
            return this.build;
        }

        public Job copy(String name, String worker_uuid, String build_uuid, Host.Node_Info node_info, Date start_date, Option<Build_Job> build) {
            return new Job(name, worker_uuid, build_uuid, node_info, start_date, build);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.worker_uuid();
        }

        public String copy$default$3() {
            return this.build_uuid();
        }

        public Host.Node_Info copy$default$4() {
            return this.node_info();
        }

        public Date copy$default$5() {
            return this.start_date();
        }

        public Option<Build_Job> copy$default$6() {
            return this.build();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.worker_uuid();
        }

        public String _3() {
            return this.build_uuid();
        }

        public Host.Node_Info _4() {
            return this.node_info();
        }

        public Date _5() {
            return this.start_date();
        }

        public Option<Build_Job> _6() {
            return this.build();
        }
    }

    public static class Result
    implements Name.T,
    Product,
    Serializable {
        private final String name;
        private final String worker_uuid;
        private final String build_uuid;
        private final Host.Node_Info node_info;
        private final Date start_date;
        private final Process_Result process_result;
        private final SHA1.Shasum output_shasum;
        private final boolean current;

        public static Result apply(String string, String string2, String string3, Host.Node_Info node_Info, Date date, Process_Result process_Result, SHA1.Shasum shasum, boolean bl) {
            return Build_Process$Result$.MODULE$.apply(string, string2, string3, node_Info, date, process_Result, shasum, bl);
        }

        public static Result fromProduct(Product product) {
            return Build_Process$Result$.MODULE$.fromProduct(product);
        }

        public static Result unapply(Result result) {
            return Build_Process$Result$.MODULE$.unapply(result);
        }

        public Result(String name, String worker_uuid, String build_uuid, Host.Node_Info node_info, Date start_date, Process_Result process_result, SHA1.Shasum output_shasum, boolean current) {
            this.name = name;
            this.worker_uuid = worker_uuid;
            this.build_uuid = build_uuid;
            this.node_info = node_info;
            this.start_date = start_date;
            this.process_result = process_result;
            this.output_shasum = output_shasum;
            this.current = current;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.worker_uuid()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.build_uuid()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.node_info()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.start_date()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.process_result()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.output_shasum()));
            n = Statics.mix((int)n, (int)(this.current() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            if (this.current() != result.current()) return false;
            String string = this.name();
            String string2 = result.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.worker_uuid();
            String string4 = result.worker_uuid();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.build_uuid();
            String string6 = result.build_uuid();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Host.Node_Info node_Info = this.node_info();
            Host.Node_Info node_Info2 = result.node_info();
            if (node_Info == null) {
                if (node_Info2 != null) {
                    return false;
                }
            } else if (!((Object)node_Info).equals(node_Info2)) return false;
            Date date = this.start_date();
            Date date2 = result.start_date();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            Process_Result process_Result = this.process_result();
            Process_Result process_Result2 = result.process_result();
            if (process_Result == null) {
                if (process_Result2 != null) {
                    return false;
                }
            } else if (!((Object)process_Result).equals(process_Result2)) return false;
            SHA1.Shasum shasum = this.output_shasum();
            SHA1.Shasum shasum2 = result.output_shasum();
            if (shasum == null) {
                if (shasum2 != null) {
                    return false;
                }
            } else if (!((Object)shasum).equals(shasum2)) return false;
            if (!result.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return BoxesRunTime.boxToBoolean((boolean)this._8());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "worker_uuid";
                }
                case 2: {
                    return "build_uuid";
                }
                case 3: {
                    return "node_info";
                }
                case 4: {
                    return "start_date";
                }
                case 5: {
                    return "process_result";
                }
                case 6: {
                    return "output_shasum";
                }
                case 7: {
                    return "current";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String name() {
            return this.name;
        }

        public String worker_uuid() {
            return this.worker_uuid;
        }

        public String build_uuid() {
            return this.build_uuid;
        }

        public Host.Node_Info node_info() {
            return this.node_info;
        }

        public Date start_date() {
            return this.start_date;
        }

        public Process_Result process_result() {
            return this.process_result;
        }

        public SHA1.Shasum output_shasum() {
            return this.output_shasum;
        }

        public boolean current() {
            return this.current;
        }

        public boolean ok() {
            return this.process_result().ok();
        }

        public Result copy(String name, String worker_uuid, String build_uuid, Host.Node_Info node_info, Date start_date, Process_Result process_result, SHA1.Shasum output_shasum, boolean current) {
            return new Result(name, worker_uuid, build_uuid, node_info, start_date, process_result, output_shasum, current);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.worker_uuid();
        }

        public String copy$default$3() {
            return this.build_uuid();
        }

        public Host.Node_Info copy$default$4() {
            return this.node_info();
        }

        public Date copy$default$5() {
            return this.start_date();
        }

        public Process_Result copy$default$6() {
            return this.process_result();
        }

        public SHA1.Shasum copy$default$7() {
            return this.output_shasum();
        }

        public boolean copy$default$8() {
            return this.current();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.worker_uuid();
        }

        public String _3() {
            return this.build_uuid();
        }

        public Host.Node_Info _4() {
            return this.node_info();
        }

        public Date _5() {
            return this.start_date();
        }

        public Process_Result _6() {
            return this.process_result();
        }

        public SHA1.Shasum _7() {
            return this.output_shasum();
        }

        public boolean _8() {
            return this.current();
        }
    }

    public static final class Sessions {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Sessions.class.getDeclaredField("ordering$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Sessions.class.getDeclaredField("max_time$lzy1"));
        private final Graph graph;
        private volatile Object max_time$lzy1;
        private volatile Object ordering$lzy1;

        public static Sessions empty() {
            return Build_Process$Sessions$.MODULE$.empty();
        }

        public Sessions(Graph<String, Build_Job.Session_Context> graph) {
            this.graph = graph;
        }

        public Graph<String, Build_Job.Session_Context> graph() {
            return this.graph;
        }

        public String toString() {
            return this.graph().toString();
        }

        public boolean defined(String name) {
            return this.graph().defined(name);
        }

        public Build_Job.Session_Context apply(String name) {
            return this.graph().get_node(name);
        }

        public Iterator<Build_Job.Session_Context> iterator() {
            return this.graph().topological_order().iterator().map((Function1 & Serializable)name -> this.apply((String)name));
        }

        public boolean store_heap(String name) {
            return Sessions$.MODULE$.is_pure(name) || this.iterator().exists(arg_0 -> Build_Process$.isabelle$Build_Process$Sessions$$_$store_heap$$anonfun$1(name, arg_0));
        }

        public Map<String, Build_Job.Session_Context> data() {
            return Predef$.MODULE$.Map().from((IterableOnce)this.graph().iterator().withFilter(Build_Process$::isabelle$Build_Process$Sessions$$_$data$$anonfun$1).map(Build_Process$::isabelle$Build_Process$Sessions$$_$data$$anonfun$2));
        }

        public Sessions make(Graph<String, Build_Job.Session_Context> new_graph) {
            Graph<String, Build_Job.Session_Context> graph = this.graph();
            Graph<String, Build_Job.Session_Context> graph2 = new_graph;
            if (!(graph != null ? !((Object)graph).equals(graph2) : graph2 != null)) {
                return this;
            }
            return new Sessions((Graph)new_graph.iterator().foldLeft(new_graph, Build_Process$::isabelle$Build_Process$Sessions$$_$make$$anonfun$1));
        }

        public Sessions update(List<Update.Op<Build_Job.Session_Context>> updates) {
            Graph graph1 = (Graph)updates.foldLeft(this.graph(), Build_Process$::isabelle$Build_Process$Sessions$$_$_$$anonfun$15);
            return this.make(graph1);
        }

        public Sessions init(Build.Context build_context, Option<SQL.Database> database_server, Progress progress) {
            Sessions.Structure sessions_structure = build_context.sessions_structure();
            return this.make((Graph)sessions_structure.build_graph().iterator().foldLeft(this.graph(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Graph graph0 = (Graph)tuple2._1();
                    if (tuple22 != null) {
                        Tuple2 tuple23 = (Tuple2)tuple22._2();
                        String name = (String)tuple22._1();
                        if (tuple23 != null) {
                            Sessions.Info info = (Sessions.Info)tuple23._1();
                            List deps = info.parent().toList();
                            String prefs = info.session_prefs();
                            List<String> ancestors = sessions_structure.build_requirements((List<String>)deps);
                            SHA1.Shasum sources_shasum = build_context.deps().sources_shasum(name);
                            if (graph0.defined(name)) {
                                Build_Job.Session_Context session0 = (Build_Job.Session_Context)graph0.get_node(name);
                                String prefs0 = session0.session_prefs();
                                List<String> ancestors0 = session0.ancestors();
                                SHA1.Shasum sources_shasum0 = session0.sources_shasum();
                                String string = prefs0;
                                String string2 = prefs;
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    throw this.err$1(name, "preferences disagree", Symbol$.MODULE$.cartouche_decoded(prefs0), Symbol$.MODULE$.cartouche_decoded(prefs));
                                }
                                List<String> list = ancestors0;
                                List<String> list2 = ancestors;
                                if (list == null ? list2 != null : !list.equals(list2)) {
                                    throw this.err$1(name, "ancestors disagree", (String)package$.MODULE$.commas_quote().apply(ancestors0), (String)package$.MODULE$.commas_quote().apply(ancestors));
                                }
                                SHA1.Shasum shasum = sources_shasum0;
                                SHA1.Shasum shasum2 = sources_shasum;
                                if (shasum == null ? shasum2 != null : !((Object)shasum).equals(shasum2)) {
                                    SHA1.Shasum a = sources_shasum0.$minus(sources_shasum);
                                    SHA1.Shasum b = sources_shasum.$minus(sources_shasum0);
                                    throw this.err$1(name, "sources disagree", Library$.MODULE$.trim_line(a.toString()), Library$.MODULE$.trim_line(b.toString()));
                                }
                                return graph0;
                            }
                            Build_Job.Session_Context session = Build_Job$Session_Context$.MODULE$.load(database_server, build_context.build_uuid(), name, (List<String>)deps, ancestors, prefs, sources_shasum, info.timeout(), build_context.store(), progress);
                            return graph0.new_node(name, session);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }));
        }

        public Progress init$default$3() {
            return new Progress();
        }

        public Map<String, Object> max_time() {
            Object object = this.max_time$lzy1;
            if (object instanceof Map) {
                return (Map)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Map)this.max_time$lzyINIT1();
        }

        private Object max_time$lzyINIT1() {
            Object object;
            block7: {
                while (true) {
                    if ((object = this.max_time$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Map map = null;
                        try {
                            Set maximals = this.graph().maximals().toSet();
                            map = Predef$.MODULE$.Map().from((IterableOnce)this.graph().keys_iterator().map((Function1 & Serializable)name -> {
                                String string = (String)Predef$.MODULE$.ArrowAssoc(name);
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToDouble((double)this.descendants_time$1(maximals, (String)name)));
                            })).withDefaultValue((Object)BoxesRunTime.boxToDouble((double)0.0));
                            object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                        }
                        catch (Throwable throwable) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.max_time$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                            throw throwable;
                        }
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.max_time$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        return map;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Ordering<String> ordering() {
            Object object = this.ordering$lzy1;
            if (object instanceof Ordering) {
                return (Ordering)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Ordering)this.ordering$lzyINIT1();
        }

        private Object ordering$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.ordering$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Ordering<String> ordering = null;
                        try {
                            ordering = new Ordering<String>(this){
                                private final /* synthetic */ Sessions $outer;
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    PartialOrdering.$init$((PartialOrdering)this);
                                    Ordering.$init$((Ordering)this);
                                }

                                public final int compare(String a, String b) {
                                    return this.$outer.isabelle$Build_Process$Sessions$$_$ordering$lzyINIT1$$anonfun$1(a, b);
                                }
                            };
                            object2 = ordering == null ? LazyVals.NullValue$.MODULE$ : ordering;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.ordering$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return ordering;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private final Nothing$ err$1(String name$3, String msg, String a, String b) {
            return (Nothing$)package$.MODULE$.error().apply((Object)("Conflicting dependencies for session " + package$.MODULE$.quote().apply((Object)name$3) + ": " + msg + "\n" + Library$.MODULE$.indent_lines(2, a) + "\nvs.\n" + Library$.MODULE$.indent_lines(2, b)));
        }

        private final double descendants_time$1(Set maximals$1, String name) {
            if (maximals$1.contains((Object)name)) {
                return Time$.MODULE$.seconds$extension(this.apply(name).old_time());
            }
            Set descendants = this.graph().all_succs((List<String>)((List)new .colon.colon((Object)name, (List)Nil$.MODULE$))).toSet();
            Graph<String, Build_Job.Session_Context> g = this.graph().restrict((Function1<String, Object>)descendants);
            return BoxesRunTime.unboxToDouble((Object)g.maximals().flatMap((Function1 & Serializable)desc -> {
                List ps = g.all_preds((List)new .colon.colon(desc, (List)Nil$.MODULE$));
                if (ps.exists((Function1 & Serializable)p -> !this.graph().defined((String)p))) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply(ps.map((Function1 & Serializable)p -> Time$.MODULE$.seconds$extension(this.apply((String)p).old_time())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            }).$colon$colon((Object)BoxesRunTime.boxToDouble((double)0.0)).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        }

        public final /* synthetic */ int isabelle$Build_Process$Sessions$$_$ordering$lzyINIT1$$anonfun$1(String a, String b) {
            int n = new RichDouble(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble((Object)this.max_time().apply((Object)b)))).compare(this.max_time().apply((Object)a));
            if (0 == n) {
                int n2 = Time$.MODULE$.compare$extension(this.apply(b).timeout(), this.apply(a).timeout());
                if (0 == n2) {
                    return StringOps$.MODULE$.compare$extension(Predef$.MODULE$.augmentString(a), b);
                }
                int ord = n2;
                return ord;
            }
            int ord = n;
            return ord;
        }
    }

    public static class Snapshot
    implements Product,
    Serializable {
        private final List builds;
        private final List workers;
        private final Sessions sessions;
        private final Map pending;
        private final Map running;
        private final Map results;

        public static Snapshot apply(List<Build> list, List<Worker> list2, Sessions sessions, Map<String, Task> map, Map<String, Job> map2, Map<String, Result> map3) {
            return Build_Process$Snapshot$.MODULE$.apply(list, list2, sessions, map, map2, map3);
        }

        public static Snapshot fromProduct(Product product) {
            return Build_Process$Snapshot$.MODULE$.fromProduct(product);
        }

        public static Snapshot unapply(Snapshot snapshot) {
            return Build_Process$Snapshot$.MODULE$.unapply(snapshot);
        }

        public Snapshot(List<Build> builds, List<Worker> workers, Sessions sessions, Map<String, Task> pending, Map<String, Job> running, Map<String, Result> results) {
            this.builds = builds;
            this.workers = workers;
            this.sessions = sessions;
            this.pending = pending;
            this.running = running;
            this.results = results;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Snapshot)) return false;
            Snapshot snapshot = (Snapshot)object;
            List<Build> list = this.builds();
            List<Build> list2 = snapshot.builds();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            List<Worker> list3 = this.workers();
            List<Worker> list4 = snapshot.workers();
            if (list3 == null) {
                if (list4 != null) {
                    return false;
                }
            } else if (!list3.equals(list4)) return false;
            Sessions sessions = this.sessions();
            Sessions sessions2 = snapshot.sessions();
            if (sessions == null) {
                if (sessions2 != null) {
                    return false;
                }
            } else if (!sessions.equals(sessions2)) return false;
            Map<String, Task> map = this.pending();
            Map<String, Task> map2 = snapshot.pending();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Map<String, Job> map3 = this.running();
            Map<String, Job> map4 = snapshot.running();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            Map<String, Result> map5 = this.results();
            Map<String, Result> map6 = snapshot.results();
            if (map5 == null) {
                if (map6 != null) {
                    return false;
                }
            } else if (!map5.equals(map6)) return false;
            if (!snapshot.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Snapshot;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "Snapshot";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "builds";
                }
                case 1: {
                    return "workers";
                }
                case 2: {
                    return "sessions";
                }
                case 3: {
                    return "pending";
                }
                case 4: {
                    return "running";
                }
                case 5: {
                    return "results";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Build> builds() {
            return this.builds;
        }

        public List<Worker> workers() {
            return this.workers;
        }

        public Sessions sessions() {
            return this.sessions;
        }

        public Map<String, Task> pending() {
            return this.pending;
        }

        public Map<String, Job> running() {
            return this.running;
        }

        public Map<String, Result> results() {
            return this.results;
        }

        public Snapshot copy(List<Build> builds, List<Worker> workers, Sessions sessions, Map<String, Task> pending, Map<String, Job> running, Map<String, Result> results) {
            return new Snapshot(builds, workers, sessions, pending, running, results);
        }

        public List<Build> copy$default$1() {
            return this.builds();
        }

        public List<Worker> copy$default$2() {
            return this.workers();
        }

        public Sessions copy$default$3() {
            return this.sessions();
        }

        public Map<String, Task> copy$default$4() {
            return this.pending();
        }

        public Map<String, Job> copy$default$5() {
            return this.running();
        }

        public Map<String, Result> copy$default$6() {
            return this.results();
        }

        public List<Build> _1() {
            return this.builds();
        }

        public List<Worker> _2() {
            return this.workers();
        }

        public Sessions _3() {
            return this.sessions();
        }

        public Map<String, Task> _4() {
            return this.pending();
        }

        public Map<String, Job> _5() {
            return this.running();
        }

        public Map<String, Result> _6() {
            return this.results();
        }
    }

    public static class State
    implements Product,
    Serializable {
        private final long serial;
        private final Sessions sessions;
        private final Map pending;
        private final Map running;
        private final Map results;

        public static State apply(long l, Sessions sessions, Map<String, Task> map, Map<String, Job> map2, Map<String, Result> map3) {
            return Build_Process$State$.MODULE$.apply(l, sessions, map, map2, map3);
        }

        public static State fromProduct(Product product) {
            return Build_Process$State$.MODULE$.fromProduct(product);
        }

        public static long inc_serial(long l) {
            return Build_Process$State$.MODULE$.inc_serial(l);
        }

        public static State unapply(State state) {
            return Build_Process$State$.MODULE$.unapply(state);
        }

        public static long $lessinit$greater$default$1() {
            return Build_Process$State$.MODULE$.$lessinit$greater$default$1();
        }

        public static Sessions $lessinit$greater$default$2() {
            return Build_Process$State$.MODULE$.$lessinit$greater$default$2();
        }

        public static Map<String, Task> $lessinit$greater$default$3() {
            return Build_Process$State$.MODULE$.$lessinit$greater$default$3();
        }

        public static Map<String, Job> $lessinit$greater$default$4() {
            return Build_Process$State$.MODULE$.$lessinit$greater$default$4();
        }

        public static Map<String, Result> $lessinit$greater$default$5() {
            return Build_Process$State$.MODULE$.$lessinit$greater$default$5();
        }

        public State(long serial, Sessions sessions, Map<String, Task> pending, Map<String, Job> running, Map<String, Result> results) {
            this.serial = serial;
            this.sessions = sessions;
            this.pending = pending;
            this.running = running;
            this.results = results;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.serial()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sessions()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.pending()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.running()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.results()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.serial() != state.serial()) return false;
            Sessions sessions = this.sessions();
            Sessions sessions2 = state.sessions();
            if (sessions == null) {
                if (sessions2 != null) {
                    return false;
                }
            } else if (!sessions.equals(sessions2)) return false;
            Map<String, Task> map = this.pending();
            Map<String, Task> map2 = state.pending();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Map<String, Job> map3 = this.running();
            Map<String, Job> map4 = state.running();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            Map<String, Result> map5 = this.results();
            Map<String, Result> map6 = state.results();
            if (map5 == null) {
                if (map6 != null) {
                    return false;
                }
            } else if (!map5.equals(map6)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "serial";
                }
                case 1: {
                    return "sessions";
                }
                case 2: {
                    return "pending";
                }
                case 3: {
                    return "running";
                }
                case 4: {
                    return "results";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long serial() {
            return this.serial;
        }

        public Sessions sessions() {
            return this.sessions;
        }

        public Map<String, Task> pending() {
            return this.pending;
        }

        public Map<String, Job> running() {
            return this.running;
        }

        public Map<String, Result> results() {
            return this.results;
        }

        public long next_serial() {
            return Build_Process$State$.MODULE$.inc_serial(this.serial());
        }

        public List<Task> ready() {
            return (List)this.pending().valuesIterator().filter(Build_Process$::isabelle$Build_Process$State$$_$ready$$anonfun$1).toList().sortBy(Build_Process$::isabelle$Build_Process$State$$_$ready$$anonfun$2, (Ordering)Ordering.String$.MODULE$);
        }

        public List<Task> next_ready() {
            return this.ready().filter((Function1 & Serializable)task -> !this.is_running(task.name()));
        }

        public boolean exists_ready() {
            return this.pending().valuesIterator().exists((Function1 & Serializable)task -> task.is_ready() && !this.is_running(task.name()));
        }

        public State remove_pending(String a) {
            Map map = (Map)this.pending().foldLeft(this.pending(), (arg_0, arg_1) -> Build_Process$.isabelle$Build_Process$State$$_$_$$anonfun$16(a, arg_0, arg_1));
            long l = this.copy$default$1();
            Sessions sessions = this.copy$default$2();
            Map<String, Job> map2 = this.copy$default$4();
            Map<String, Result> map3 = this.copy$default$5();
            return this.copy(l, sessions, (Map<String, Task>)map, map2, map3);
        }

        public boolean is_running(String name) {
            return this.running().isDefinedAt((Object)name);
        }

        public List<Build_Job> build_running() {
            return this.running().valuesIterator().flatMap(Build_Process$::isabelle$Build_Process$State$$_$build_running$$anonfun$1).toList();
        }

        public boolean finished_running() {
            return this.build_running().exists(Build_Process$::isabelle$Build_Process$State$$_$finished_running$$anonfun$1);
        }

        public boolean busy_running(int jobs) {
            return jobs <= 0 || jobs <= this.build_running().length();
        }

        public State add_running(Job job) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)job.name());
            Map map = (Map)this.running().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)job));
            long l = this.copy$default$1();
            Sessions sessions = this.copy$default$2();
            Map<String, Task> map2 = this.copy$default$3();
            Map<String, Result> map3 = this.copy$default$5();
            return this.copy(l, sessions, map2, (Map<String, Job>)map, map3);
        }

        public State remove_running(String name) {
            Map map = (Map)this.running().$minus((Object)name);
            long l = this.copy$default$1();
            Sessions sessions = this.copy$default$2();
            Map<String, Task> map2 = this.copy$default$3();
            Map<String, Result> map3 = this.copy$default$5();
            return this.copy(l, sessions, map2, (Map<String, Job>)map, map3);
        }

        public State make_result(Tuple3<String, String, String> result_name, Process_Result process_result, SHA1.Shasum output_shasum, Date start_date, Host.Node_Info node_info, boolean current) {
            Tuple3<String, String, String> tuple3 = result_name;
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String name = (String)tuple3._1();
            String worker_uuid = (String)tuple3._2();
            String build_uuid = (String)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)name, (Object)worker_uuid, (Object)build_uuid);
            String name2 = (String)tuple32._1();
            String worker_uuid2 = (String)tuple32._2();
            String build_uuid2 = (String)tuple32._3();
            Result result = Build_Process$Result$.MODULE$.apply(name2, worker_uuid2, build_uuid2, node_info, start_date, process_result, output_shasum, current);
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name2);
            Map map = (Map)this.results().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)result));
            long l = this.copy$default$1();
            Sessions sessions = this.copy$default$2();
            Map<String, Task> map2 = this.copy$default$3();
            Map<String, Job> map3 = this.copy$default$4();
            return this.copy(l, sessions, map2, map3, (Map<String, Result>)map);
        }

        public Host.Node_Info make_result$default$5() {
            return Host$Node_Info$.MODULE$.none();
        }

        public boolean make_result$default$6() {
            return false;
        }

        public Option<List<Result>> ancestor_results(String name) {
            boolean defined;
            boolean bl = defined = this.sessions().defined(name) && this.sessions().apply(name).ancestors().forall((Function1 & Serializable)a -> this.sessions().defined((String)a) && this.results().isDefinedAt(a));
            if (defined) {
                return Some$.MODULE$.apply((Object)this.sessions().apply(name).ancestors().map(this.results()));
            }
            return None$.MODULE$;
        }

        public State copy(long serial, Sessions sessions, Map<String, Task> pending, Map<String, Job> running, Map<String, Result> results) {
            return new State(serial, sessions, pending, running, results);
        }

        public long copy$default$1() {
            return this.serial();
        }

        public Sessions copy$default$2() {
            return this.sessions();
        }

        public Map<String, Task> copy$default$3() {
            return this.pending();
        }

        public Map<String, Job> copy$default$4() {
            return this.running();
        }

        public Map<String, Result> copy$default$5() {
            return this.results();
        }

        public long _1() {
            return this.serial();
        }

        public Sessions _2() {
            return this.sessions();
        }

        public Map<String, Task> _3() {
            return this.pending();
        }

        public Map<String, Job> _4() {
            return this.running();
        }

        public Map<String, Result> _5() {
            return this.results();
        }
    }

    public static class Task
    implements Name.T,
    Product,
    Serializable {
        private final String name;
        private final List deps;
        private final String build_uuid;

        public static Task apply(String string, List<String> list, String string2) {
            return Build_Process$Task$.MODULE$.apply(string, list, string2);
        }

        public static Tuple2<String, Task> entry(Build_Job.Session_Context session_Context, Build.Context context) {
            return Build_Process$Task$.MODULE$.entry(session_Context, context);
        }

        public static Task fromProduct(Product product) {
            return Build_Process$Task$.MODULE$.fromProduct(product);
        }

        public static Task unapply(Task task) {
            return Build_Process$Task$.MODULE$.unapply(task);
        }

        public Task(String name, List<String> deps, String build_uuid) {
            this.name = name;
            this.deps = deps;
            this.build_uuid = build_uuid;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Task)) return false;
            Task task = (Task)object;
            String string = this.name();
            String string2 = task.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            List<String> list = this.deps();
            List<String> list2 = task.deps();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            String string3 = this.build_uuid();
            String string4 = task.build_uuid();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!task.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Task;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Task";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "deps";
                }
                case 2: {
                    return "build_uuid";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String name() {
            return this.name;
        }

        public List<String> deps() {
            return this.deps;
        }

        public String build_uuid() {
            return this.build_uuid;
        }

        public boolean is_ready() {
            return this.deps().isEmpty();
        }

        public Option<Task> resolve(String dep) {
            if (this.deps().contains((Object)dep)) {
                List list = this.deps().filterNot(arg_0 -> Build_Process$.isabelle$Build_Process$Task$$_$_$$anonfun$14(dep, arg_0));
                String string = this.copy$default$1();
                String string2 = this.copy$default$3();
                return Some$.MODULE$.apply((Object)this.copy(string, (List<String>)list, string2));
            }
            return None$.MODULE$;
        }

        public Task copy(String name, List<String> deps, String build_uuid) {
            return new Task(name, deps, build_uuid);
        }

        public String copy$default$1() {
            return this.name();
        }

        public List<String> copy$default$2() {
            return this.deps();
        }

        public String copy$default$3() {
            return this.build_uuid();
        }

        public String _1() {
            return this.name();
        }

        public List<String> _2() {
            return this.deps();
        }

        public String _3() {
            return this.build_uuid();
        }
    }

    public static class Worker
    implements Product,
    Serializable {
        private final String worker_uuid;
        private final String build_uuid;
        private final Date start;
        private final Date stamp;
        private final Option stop;
        private final long serial;

        public static Worker apply(String string, String string2, Date date, Date date2, Option<Date> option, long l) {
            return Build_Process$Worker$.MODULE$.apply(string, string2, date, date2, option, l);
        }

        public static Worker fromProduct(Product product) {
            return Build_Process$Worker$.MODULE$.fromProduct(product);
        }

        public static Worker unapply(Worker worker) {
            return Build_Process$Worker$.MODULE$.unapply(worker);
        }

        public Worker(String worker_uuid, String build_uuid, Date start, Date stamp, Option<Date> stop, long serial) {
            this.worker_uuid = worker_uuid;
            this.build_uuid = build_uuid;
            this.start = start;
            this.stamp = stamp;
            this.stop = stop;
            this.serial = serial;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.worker_uuid()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.build_uuid()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.start()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.stamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.stop()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.serial()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Worker)) return false;
            Worker worker = (Worker)object;
            if (this.serial() != worker.serial()) return false;
            String string = this.worker_uuid();
            String string2 = worker.worker_uuid();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.build_uuid();
            String string4 = worker.build_uuid();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Date date = this.start();
            Date date2 = worker.start();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            Date date3 = this.stamp();
            Date date4 = worker.stamp();
            if (date3 == null) {
                if (date4 != null) {
                    return false;
                }
            } else if (!((Object)date3).equals(date4)) return false;
            Option<Date> option = this.stop();
            Option<Date> option2 = worker.stop();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!worker.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Worker;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "Worker";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToLong((long)this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "worker_uuid";
                }
                case 1: {
                    return "build_uuid";
                }
                case 2: {
                    return "start";
                }
                case 3: {
                    return "stamp";
                }
                case 4: {
                    return "stop";
                }
                case 5: {
                    return "serial";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String worker_uuid() {
            return this.worker_uuid;
        }

        public String build_uuid() {
            return this.build_uuid;
        }

        public Date start() {
            return this.start;
        }

        public Date stamp() {
            return this.stamp;
        }

        public Option<Date> stop() {
            return this.stop;
        }

        public long serial() {
            return this.serial;
        }

        public Worker copy(String worker_uuid, String build_uuid, Date start, Date stamp, Option<Date> stop, long serial) {
            return new Worker(worker_uuid, build_uuid, start, stamp, stop, serial);
        }

        public String copy$default$1() {
            return this.worker_uuid();
        }

        public String copy$default$2() {
            return this.build_uuid();
        }

        public Date copy$default$3() {
            return this.start();
        }

        public Date copy$default$4() {
            return this.stamp();
        }

        public Option<Date> copy$default$5() {
            return this.stop();
        }

        public long copy$default$6() {
            return this.serial();
        }

        public String _1() {
            return this.worker_uuid();
        }

        public String _2() {
            return this.build_uuid();
        }

        public Date _3() {
            return this.start();
        }

        public Date _4() {
            return this.stamp();
        }

        public Option<Date> _5() {
            return this.stop();
        }

        public long _6() {
            return this.serial();
        }
    }
}

