/*
 * Decompiled with CFR 0.152.
 */
package isabelle.naproche;

import isabelle.Bash;
import isabelle.Browser_Info;
import isabelle.Build;
import isabelle.Build$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Options;
import isabelle.Options$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.Rich_Text;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.Sessions;
import isabelle.Synchronized;
import isabelle.Synchronized$;
import isabelle.Time$;
import isabelle.Value;
import isabelle.naproche.Naproche$;
import isabelle.naproche.Naproche_File_Format;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.function.JProcedure1;

public final class Naproche_Test$
implements Serializable {
    private static final Isabelle_Tool isabelle_tool;
    public static final Naproche_Test$ MODULE$;

    private Naproche_Test$() {
    }

    static {
        MODULE$ = new Naproche_Test$();
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("naproche_test", "run Naproche tests", Scala_Project$.MODULE$.here(), (Function1)(JProcedure1 & Serializable)args -> {
            Rich_Text.Cache cache;
            Function2 function2;
            Function1 function1;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            List list;
            List list2;
            Option option;
            boolean bl7;
            boolean bl8;
            boolean bl9;
            Browser_Info.Config config;
            Sessions.Selection selection;
            List list3;
            ObjectRef log_dir = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef max_jobs = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef options = ObjectRef.create((Object)Options$.MODULE$.init(Options$.MODULE$.init$default$1(), Options$.MODULE$.init$default$2()));
            LongRef timeout = LongRef.create((long)Time$.MODULE$.zero());
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                log_dir$1.elem = Some$.MODULE$.apply((Object)Path$.MODULE$.explode(arg));
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"j:");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)arg -> {
                max_jobs$2.elem = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Value.Nat$.MODULE$.parse(arg)));
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"o:");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (JProcedure1 & Serializable)arg -> {
                options$2.elem = ((Options)options$2.elem).$plus(arg);
            });
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"t:");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (JProcedure1 & Serializable)arg -> {
                timeout$1.elem = Time$.MODULE$.seconds(Value.Double$.MODULE$.parse(arg));
            });
            Getopts getopts = Getopts$.MODULE$.apply(this::$anonfun$1, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List more_args = getopts.apply(args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            Options options2 = (Options)options.elem;
            List list4 = (List)new .colon.colon((Object)Naproche$.MODULE$.NAPROCHE_HOME(), (List)Nil$.MODULE$);
            Option option2 = (Option)max_jobs.elem;
            Option option3 = Build$.MODULE$.build$default$2();
            Build.Results results = Build$.MODULE$.build(options2, option3, list3 = Build$.MODULE$.build$default$3(), selection = Build$.MODULE$.build$default$4(), config = Build$.MODULE$.build$default$5(), (Progress)progress, bl9 = Build$.MODULE$.build$default$7(), bl8 = Build$.MODULE$.build$default$8(), bl7 = Build$.MODULE$.build$default$9(), option = Build$.MODULE$.build$default$10(), list2 = Build$.MODULE$.build$default$11(), list4, list = Build$.MODULE$.build$default$13(), bl6 = Build$.MODULE$.build$default$14(), option2, bl5 = Build$.MODULE$.build$default$16(), bl4 = Build$.MODULE$.build$default$17(), bl3 = Build$.MODULE$.build$default$18(), bl2 = Build$.MODULE$.build$default$19(), bl = Build$.MODULE$.build$default$20(), function1 = Build$.MODULE$.build$default$21(), function2 = Build$.MODULE$.build$default$22(), cache = Build$.MODULE$.build$default$23());
            if (!results.ok()) {
                throw scala.sys.package$.MODULE$.exit(results.rc());
            }
            this.run_tests((Progress)progress, (Option<Path>)((Option)log_dir.elem), (Option<Object>)((Option)max_jobs.elem), timeout.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Naproche_Test$.class);
    }

    public void run_tests(Progress progress, Option<Path> log_dir, Option<Object> max_jobs, long timeout) {
        Naproche_File_Format file_format = new Naproche_File_Format();
        List tests = (List)File$.MODULE$.find_files(Naproche$.MODULE$.NAPROCHE_MATH().file(), (Function1 & Serializable)file -> file_format.detect(file.getName()) && !this.contains_flams_dir$1(this.isabelle$naproche$Naproche_Test$$$_$relative$1((File)file).implode()), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).sortBy((Function1 & Serializable)file -> this.relative_name$1((File)file), (Ordering)Ordering.String$.MODULE$);
        Synchronized bad = Synchronized$.MODULE$.apply((Object)scala.package$.MODULE$.List().empty());
        ExecutorService executor = Executors.newFixedThreadPool(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)max_jobs.getOrElse(Naproche_Test$::$anonfun$8))), 1));
        tests.foreach((Function1 & Serializable)test -> executor.submit(new Runnable((File)test, progress, timeout, (Option)log_dir, bad){
            private final File test$1;
            private final Progress progress$2;
            private final long timeout$3;
            private final Option log_dir$3;
            private final Synchronized bad$2;
            {
                this.test$1 = test$2;
                this.progress$2 = progress$3;
                this.timeout$3 = timeout$4;
                this.log_dir$3 = log_dir$4;
                this.bad$2 = bad$3;
            }

            public void run() {
                boolean expect_ok;
                Path path = File$.MODULE$.path(this.test$1);
                String text = File$.MODULE$.read(path);
                boolean test_failure = Predef$.MODULE$.wrapString(text).containsSlice((Seq)Predef$.MODULE$.wrapString("# test: FAILURE"));
                boolean test_ignore = Predef$.MODULE$.wrapString(text).containsSlice((Seq)Predef$.MODULE$.wrapString("# test: IGNORE"));
                Path path_relative = Naproche_Test$.MODULE$.isabelle$naproche$Naproche_Test$$$_$relative$1(this.test$1);
                if (test_ignore) {
                    this.progress$2.echo("Ignoring " + path_relative, this.progress$2.echo$default$2());
                    return;
                }
                this.progress$2.expose_interrupt();
                this.progress$2.echo("Checking " + path_relative + " ...", this.progress$2.echo$default$2());
                long start = Time$.MODULE$.now();
                VolatileBooleanRef was_timeout = VolatileBooleanRef.create((boolean)false);
                String string = "\"$NAPROCHE_EXE\" -v -- " + File$.MODULE$.bash_platform_path(path);
                Path path2 = Naproche$.MODULE$.NAPROCHE_HOME();
                Bash.Watchdog watchdog = this.timeout$3 == Time$.MODULE$.zero() ? Bash.Watchdog$.MODULE$.none() : Bash.Watchdog$.MODULE$.apply(Time$.MODULE$.seconds(0.1), (Function1 & Serializable)_$1 -> this.progress$2.stopped() || this.check_timeout$1(start, was_timeout));
                String string2 = Isabelle_System$.MODULE$.bash$default$2();
                SSH.System system = Isabelle_System$.MODULE$.bash$default$3();
                Map map = Isabelle_System$.MODULE$.bash$default$5();
                boolean bl = Isabelle_System$.MODULE$.bash$default$6();
                String string3 = Isabelle_System$.MODULE$.bash$default$7();
                Function1 function1 = Isabelle_System$.MODULE$.bash$default$8();
                Function1 function12 = Isabelle_System$.MODULE$.bash$default$9();
                Function0 function0 = Isabelle_System$.MODULE$.bash$default$12();
                Process_Result result = Isabelle_System$.MODULE$.bash(string, string2, system, path2, map, bl, string3, function1, function12, watchdog, false, function0);
                long stop = Time$.MODULE$.now();
                long timing = Time$.MODULE$.$minus$extension(stop, start);
                boolean bl2 = expect_ok = !test_failure;
                String status = "Finished " + path_relative + ": " + (String)(was_timeout.elem ? "TIMEOUT" : (result.interrupted() ? "INTERRUPT" : (result.ok() ? "OK" : "FAILURE") + (String)(result.ok() == expect_ok ? "" : ", but expected " + (expect_ok ? "OK" : "FAILURE")))) + (" (" + Time$.MODULE$.message$extension(timing) + " elapsed time)" + (String)(result.ok() != expect_ok ? "\n" + result.err() : ""));
                this.progress$2.echo(status, this.progress$2.echo$default$2());
                this.log_dir$3.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> Naproche_Test$.isabelle$naproche$Naproche_Test$$anon$1$$_$run$$anonfun$1(path_relative, status, result, arg_0)));
                if (result.ok() != expect_ok) {
                    this.bad$2.change(arg_0 -> Naproche_Test$.isabelle$naproche$Naproche_Test$$anon$1$$_$run$$anonfun$2(path_relative, arg_0));
                    return;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean check_timeout$1(long start$1, VolatileBooleanRef was_timeout$1) {
                if (!Time$.MODULE$.$greater$extension(Time$.MODULE$.now(), Time$.MODULE$.$plus$extension(start$1, this.timeout$3))) return false;
                was_timeout$1.elem = true;
                if (!true) return false;
                return true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$9(long scala.runtime.VolatileBooleanRef isabelle.Bash$Process ), isabelle$naproche$Naproche_Test$$anon$1$$_$run$$anonfun$1(isabelle.Path java.lang.String isabelle.Process_Result isabelle.Path ), isabelle$naproche$Naproche_Test$$anon$1$$_$run$$anonfun$2(isabelle.Path scala.collection.immutable.List )}, serializedLambda);
            }
        }));
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        List list = (List)bad.value();
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return;
        }
        List bad_tests = list;
        package$.MODULE$.error().apply((Object)("Bad tests: " + bad_tests.mkString(", ")));
    }

    public Progress run_tests$default$1() {
        return new Progress();
    }

    public Option<Path> run_tests$default$2() {
        return None$.MODULE$;
    }

    public Option<Object> run_tests$default$3() {
        return None$.MODULE$;
    }

    public long run_tests$default$4() {
        return Time$.MODULE$.zero();
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle naproche_test\n\n  Options are:\n    -D DIR       directory for log files (default: none)\n    -j JOBS      maximum number of parallel jobs (default: 1)\n    -o OPTION    override Isabelle system OPTION (via NAME=VAL or NAME)\n    -t SECONDS   timeout in seconds (default: 0, which means disabled)\n\n  Run Naproche tests.\n";
    }

    public final Path isabelle$naproche$Naproche_Test$$$_$relative$1(File file) {
        return (Path)File$.MODULE$.relative_path(Naproche$.MODULE$.NAPROCHE_MATH(), File$.MODULE$.path(file)).get();
    }

    private final String relative_name$1(File file) {
        return this.isabelle$naproche$Naproche_Test$$$_$relative$1(file).implode();
    }

    private final boolean contains_flams_dir$1(String path) {
        return Predef$.MODULE$.wrapString(path).containsSlice((Seq)Predef$.MODULE$.wrapString("/.flams/"));
    }

    private static final int $anonfun$8() {
        return 1;
    }

    public static final /* synthetic */ void isabelle$naproche$Naproche_Test$$anon$1$$_$run$$anonfun$1(Path path_relative$1, String status$1, Process_Result result$1, Path dir0) {
        Path dir = Isabelle_System$.MODULE$.make_directory(dir0.$plus(path_relative$1));
        File$.MODULE$.write(dir.$plus(Path$.MODULE$.basic("status")), status$1);
        File$.MODULE$.write(dir.$plus(Path$.MODULE$.basic("output")), result$1.out());
        File$.MODULE$.write(dir.$plus(Path$.MODULE$.basic("error")), result$1.err());
    }

    public static final /* synthetic */ List isabelle$naproche$Naproche_Test$$anon$1$$_$run$$anonfun$2(Path path_relative$2, List _$2) {
        return _$2.$colon$colon((Object)path_relative$2);
    }
}

