/*
 * Decompiled with CFR 0.152.
 */
package isabelle.naproche;

import isabelle.Bash;
import isabelle.Bash$;
import isabelle.File$;
import isabelle.File_Format;
import isabelle.Future;
import isabelle.Future$;
import isabelle.Isabelle_System$;
import isabelle.Options;
import isabelle.Output$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Process_Result;
import isabelle.SSH;
import isabelle.Server;
import isabelle.Session;
import isabelle.package$;
import java.io.Serializable;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class Naproche_File_Format
extends File_Format {
    private final String file_ext;

    public Naproche_File_Format() {
        this.file_ext = "";
    }

    public String format_name() {
        return "forthel";
    }

    public String file_ext() {
        return this.file_ext;
    }

    public boolean detect_tex(String name) {
        return name.endsWith(".ftl.tex") || name.endsWith(".ftl.en.tex");
    }

    public boolean detect(String name) {
        return name.endsWith(".ftl") || this.detect_tex(name);
    }

    public String theory_suffix() {
        return "forthel_file";
    }

    public String theory_content(String name) {
        return "theory " + package$.MODULE$.quote().apply((Object)(this.detect_tex(name) ? "tex" : "ftl")) + " imports Naproche.Naproche begin forthel_file " + package$.MODULE$.quote().apply((Object)("../" + name)) + " end";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean theory_excluded(String name) {
        String string = name;
        String string2 = "tex";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = name;
        String string4 = "ftl";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public File_Format.Agent start(Session session) {
        boolean enabled;
        boolean bl = enabled = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(Isabelle_System$.MODULE$.getenv("NAPROCHE_EXE", Isabelle_System$.MODULE$.getenv$default$2()))) && BoxesRunTime.unboxToBoolean((Object)session.session_options().bool().apply("naproche_server"));
        if (enabled) {
            return new Agent((Function0<Options>)((Function0 & Serializable)() -> Naproche_File_Format.start$$anonfun$1(session)));
        }
        return File_Format.No_Agent$.MODULE$;
    }

    private static final Options start$$anonfun$1(Session session$1) {
        return session$1.session_options();
    }

    public static class Agent
    implements File_Format.Agent {
        private final Function0<Options> session_options;
        private final Bash.Process process;
        private final Option<Server.Info> server_info;
        private final Future<Process_Result> process_result;

        public Agent(Function0<Options> session_options) {
            this.session_options = session_options;
            Path path = Path$.MODULE$.explode("$NAPROCHE_HOME");
            String string = Bash$.MODULE$.process$default$2();
            SSH.System system = Bash$.MODULE$.process$default$3();
            Map map = Bash$.MODULE$.process$default$5();
            boolean bl = Bash$.MODULE$.process$default$6();
            Function0 function0 = Bash$.MODULE$.process$default$7();
            this.process = Bash$.MODULE$.process("\"$NAPROCHE_EXE\" --server", string, system, path, map, bl, function0);
            this.server_info = File$.MODULE$.read_line(this.process.stdout()).flatMap((Function1 & Serializable)line -> Server.Info$.MODULE$.parse(line).map((Function1 & Serializable)info -> info));
            this.process_result = Future$.MODULE$.thread("Naproche", Future$.MODULE$.thread$default$2(), Future$.MODULE$.thread$default$3(), Future$.MODULE$.thread$default$4(), Future$.MODULE$.thread$default$5(), Future$.MODULE$.thread$default$6(), this::$init$$$anonfun$2);
            if (this.server_info.isEmpty()) {
                Thread.sleep(50L);
                this.process.terminate();
                List errs = ((Process_Result)this.process_result.join()).err_lines();
                package$.MODULE$.error().apply(package$.MODULE$.cat_lines().apply((Object)errs.$colon$colon((Object)"Naproche server failure")));
            }
        }

        private boolean debugging() {
            return BoxesRunTime.unboxToBoolean((Object)((Options)this.session_options.apply()).bool().apply("naproche_server_debugging"));
        }

        public String toString() {
            return ((Server.Info)this.server_info.get()).toString();
        }

        public Options prover_options(Options options) {
            return options.$plus("naproche_server_address=" + ((Server.Info)this.server_info.get()).address()).$plus("naproche_server_password=" + ((Server.Info)this.server_info.get()).password());
        }

        public void stop() {
            this.process.terminate();
            this.process_result.join();
        }

        private final Process_Result $init$$$anonfun$2() {
            return this.process.result(this.process.result$default$1(), (Function1)(JProcedure1 & Serializable)line -> {
                if (this.debugging()) {
                    Output$.MODULE$.writeln(line, Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
                    return;
                }
            }, (Function1)(JProcedure1 & Serializable)line -> {
                if (this.debugging()) {
                    Output$.MODULE$.writeln(line, Output$.MODULE$.writeln$default$2(), Output$.MODULE$.writeln$default$3());
                    return;
                }
            }, this.process.result$default$4(), false);
        }
    }
}

