/*
 * Decompiled with CFR 0.152.
 */
package isabelle.naproche;

import isabelle.Bash$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Isabelle_Tool$;
import isabelle.Library$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.Scala_Project$;
import isabelle.naproche.Naproche$;
import isabelle.package$;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public final class Naproche_Component$
implements Serializable {
    private static final List cleanup_names;
    private static final List cleanup_trees;
    private static final int output_tail;
    private static final Isabelle_Tool isabelle_tool;
    public static final Naproche_Component$ MODULE$;

    private Naproche_Component$() {
    }

    static {
        MODULE$ = new Naproche_Component$();
        cleanup_names = (List)new .colon.colon((Object)"_config.yml", (List)Nil$.MODULE$);
        cleanup_trees = (List)new .colon.colon((Object)".git", (List)new .colon.colon((Object)".gitignore", (List)new .colon.colon((Object)".travis.yml", (List)new .colon.colon((Object)"math_pdf", (List)new .colon.colon((Object)"examples/test", (List)new .colon.colon((Object)"Isabelle/Admin", (List)Nil$.MODULE$))))));
        output_tail = 20;
        isabelle_tool = Isabelle_Tool$.MODULE$.apply("naproche_component", "build Isabelle/Naproche component from repository", Scala_Project$.MODULE$.here(), (Function1)(JProcedure1 & Serializable)args -> {
            ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
            BooleanRef pdf_documents = BooleanRef.create((boolean)false);
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"D:");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (JProcedure1 & Serializable)arg -> {
                target_dir$1.elem = Path$.MODULE$.explode(arg);
            });
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"P");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (JProcedure1 & Serializable)_$4 -> {
                pdf_documents$1.elem = true;
            });
            Getopts getopts = Getopts$.MODULE$.apply(this::$anonfun$1, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List more_args = getopts.apply(args);
            if (more_args.nonEmpty()) {
                throw getopts.usage(getopts.usage$default$1());
            }
            Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2(), Console_Progress$.MODULE$.$lessinit$greater$default$3(), Console_Progress$.MODULE$.$lessinit$greater$default$4());
            this.build_component((Progress)progress, (Path)target_dir.elem, pdf_documents.elem);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Naproche_Component$.class);
    }

    public List<String> cleanup_names() {
        return cleanup_names;
    }

    public List<String> cleanup_trees() {
        return cleanup_trees;
    }

    public int output_tail() {
        return output_tail;
    }

    public void build_component(Progress progress, Path target_dir, boolean pdf_documents) {
        Isabelle_System$.MODULE$.require_command("git", Isabelle_System$.MODULE$.require_command$default$2());
        Path path = Naproche$.MODULE$.NAPROCHE_HOME();
        SSH.System system = progress.bash$default$2();
        Map map = progress.bash$default$4();
        boolean bl = progress.bash$default$5();
        boolean bl2 = progress.bash$default$6();
        long l = progress.bash$default$7();
        boolean bl3 = progress.bash$default$8();
        Process_Result git_show = progress.bash("git show", system, path, map, bl, bl2, l, bl3).check();
        Option opt_version = git_show.out_lines().headOption().flatMap((Function1 & Serializable)line -> Library$.MODULE$.try_unprefix("commit ", line).map((Function1 & Serializable)id -> id.substring(0, 12)));
        String version = (String)opt_version.getOrElse(() -> Naproche_Component$.$anonfun$5(git_show));
        String component = "naproche-" + version;
        Path component_dir = Isabelle_System$.MODULE$.new_directory(target_dir.$plus(Path$.MODULE$.basic(component)));
        progress.echo("Component directory " + component_dir, progress.echo$default$2());
        Isabelle_System$.MODULE$.with_tmp_file("archive", "tar", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (Function1 & Serializable)archive -> {
            String string = "git archive --output=" + File$.MODULE$.bash_path(archive) + " -- " + Bash$.MODULE$.string(version);
            Path path = Naproche$.MODULE$.NAPROCHE_HOME();
            SSH.System system = progress.bash$default$2();
            Map map = progress.bash$default$4();
            boolean bl = progress.bash$default$5();
            boolean bl2 = progress.bash$default$6();
            long l = progress.bash$default$7();
            boolean bl3 = progress.bash$default$8();
            progress.bash(string, system, path, map, bl, bl2, l, bl3).check();
            String string2 = "tar -x -f " + File$.MODULE$.bash_path(archive);
            SSH.System system2 = progress.bash$default$2();
            Map map2 = progress.bash$default$4();
            boolean bl4 = progress.bash$default$5();
            boolean bl5 = progress.bash$default$6();
            long l2 = progress.bash$default$7();
            boolean bl6 = progress.bash$default$8();
            return progress.bash(string2, system2, component_dir, map2, bl4, bl5, l2, bl6).check();
        });
        progress.echo("Copying " + Naproche$.MODULE$.NAPROCHE_EXE_DIR().expand(), progress.echo$default$2());
        Isabelle_System$.MODULE$.copy_dir(Naproche$.MODULE$.NAPROCHE_EXE_DIR(), component_dir, Isabelle_System$.MODULE$.copy_dir$default$3());
        progress.echo("Copying " + Naproche$.MODULE$.jar().expand(), progress.echo$default$2());
        Isabelle_System$.MODULE$.copy_file(Naproche$.MODULE$.jar(), component_dir.$plus(Path$.MODULE$.explode("Isabelle")));
        File$.MODULE$.change(component_dir.$plus(Path$.MODULE$.explode("etc/build.props")), File$.MODULE$.change$default$2(), File$.MODULE$.change$default$3(), (Function1 & Serializable)s -> s.replaceAll("no_build\\s*=.*", "no_build = true"));
        File$.MODULE$.change(component_dir.$plus(Path$.MODULE$.explode("etc/settings")), File$.MODULE$.change$default$2(), File$.MODULE$.change$default$3(), (Function1 & Serializable)s -> s + "\nclasspath \"$ISABELLE_NAPROCHE/naproche.jar\"\n");
        ObjectRef tex_failed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        if (pdf_documents) {
            Regex TeX_Program = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^% +!TEX +program += +(\\w+) *$"));
            Path math = component_dir.$plus(Path$.MODULE$.explode("math"));
            Path math_pdf = component_dir.$plus(Path$.MODULE$.explode("math_pdf"));
            Isabelle_System$.MODULE$.copy_dir(math, math_pdf, Isabelle_System$.MODULE$.copy_dir$default$3());
            ((List)File$.MODULE$.find_files(math_pdf.file(), (Function1 & Serializable)_$1 -> _$1.getName().endsWith(".tex"), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).sortBy((Function1 & Serializable)file -> this.relative_name$1(math_pdf, (File)file), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)file -> {
                String text = File$.MODULE$.read(file);
                return Tuple2$.MODULE$.apply(file, (Object)text);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String text = (String)tuple2._2();
                    return Predef$.MODULE$.wrapString(text).containsSlice((Seq)Predef$.MODULE$.wrapString("\\documentclass"));
                }
                throw new MatchError((Object)tuple2);
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    String text = (String)tuple2._2();
                    Path archive_pdf = math_pdf.$plus(Path$.MODULE$.explode("archive"));
                    String mathhub_pdf = archive_pdf.absolute().implode();
                    Path tex_path = this.relative$1(math_pdf, file);
                    Path tex_dir = File$.MODULE$.path(file).dir();
                    String tex_name = tex_path.base().implode();
                    String tex_program = (String)((IterableOnceOps)package$.MODULE$.split_lines().apply((Object)text)).collectFirst((PartialFunction)new Serializable(TeX_Program){
                        private final Regex TeX_Program$2;
                        {
                            this.TeX_Program$2 = TeX_Program$3;
                        }

                        public final boolean isDefinedAt(String x) {
                            List list;
                            Option option;
                            String string = x;
                            if (string != null && !(option = this.TeX_Program$2.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                                String string2;
                                String prg = string2 = (String)list.apply(0);
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(String x, Function1 function1) {
                            List list;
                            Option option;
                            String string = x;
                            if (string != null && !(option = this.TeX_Program$2.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                                String string2;
                                String prg = string2 = (String)list.apply(0);
                                return prg;
                            }
                            return function1.apply((Object)x);
                        }
                    }).getOrElse(Naproche_Component$::$anonfun$6);
                    String bibtex_program = "bibtex";
                    List bibtex_env = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"MATHHUB");
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"STEX_WRITESMS");
                    List tex_env_writesms = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)mathhub_pdf), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"true"), (List)Nil$.MODULE$));
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"MATHHUB");
                    String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"STEX_USESMS");
                    List tex_env_usesms = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)mathhub_pdf), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"true"), (List)Nil$.MODULE$));
                    Path pdf_path = Path$.MODULE$.explode((String)Library$.MODULE$.try_unsuffix(".tex", tex_path.implode()).get()).pdf();
                    String raw_file = (String)Library$.MODULE$.try_unsuffix(".tex", tex_name).get();
                    String raw_path = (String)Library$.MODULE$.try_unsuffix(".tex", tex_path.implode()).get();
                    Path bbl_path = Path$.MODULE$.explode(raw_path + ".bbl");
                    progress.expose_interrupt();
                    progress.echo("Building " + pdf_path + " with " + tex_program + " (1st run)", progress.echo$default$2());
                    String string5 = Bash$.MODULE$.string(tex_program) + " " + Bash$.MODULE$.string(tex_name);
                    Map map = Isabelle_System.Settings$.MODULE$.env(tex_env_writesms);
                    SSH.System system = progress.bash$default$2();
                    boolean bl = progress.bash$default$5();
                    boolean bl2 = progress.bash$default$6();
                    long l = progress.bash$default$7();
                    boolean bl3 = progress.bash$default$8();
                    Process_Result result = progress.bash(string5, system, tex_dir, map, bl, bl2, l, bl3);
                    if (!result.ok()) {
                        tex_failed$1.elem = (Set)((Set)tex_failed$1.elem).$plus((Object)tex_path);
                        progress.echo_error_message((String)package$.MODULE$.cat_lines().apply((Object)((List)result.out_lines().drop(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(result.out_lines().length() - this.output_tail()), 0))).$colon$colon((Object)"LaTeX failed:")), progress.echo_error_message$default$2());
                    } else {
                        progress.echo("Building " + bbl_path + " with " + bibtex_program, progress.echo$default$2());
                        String string6 = Bash$.MODULE$.string(bibtex_program) + " " + Bash$.MODULE$.string(raw_file);
                        Map map2 = Isabelle_System.Settings$.MODULE$.env(bibtex_env);
                        SSH.System system2 = progress.bash$default$2();
                        boolean bl4 = progress.bash$default$5();
                        boolean bl5 = progress.bash$default$6();
                        long l2 = progress.bash$default$7();
                        boolean bl6 = progress.bash$default$8();
                        progress.bash(string6, system2, tex_dir, map2, bl4, bl5, l2, bl6);
                        progress.echo("Building " + pdf_path + " with " + tex_program + " (2nd run)", progress.echo$default$2());
                        String string7 = Bash$.MODULE$.string(tex_program) + " " + Bash$.MODULE$.string(tex_name);
                        Map map3 = Isabelle_System.Settings$.MODULE$.env(tex_env_usesms);
                        SSH.System system3 = progress.bash$default$2();
                        boolean bl7 = progress.bash$default$5();
                        boolean bl8 = progress.bash$default$6();
                        long l3 = progress.bash$default$7();
                        boolean bl9 = progress.bash$default$8();
                        Process_Result result2 = progress.bash(string7, system3, tex_dir, map3, bl7, bl8, l3, bl9);
                        if (!result2.ok()) {
                            tex_failed$1.elem = (Set)((Set)tex_failed$1.elem).$plus((Object)tex_path);
                            progress.echo_error_message((String)package$.MODULE$.cat_lines().apply((Object)((List)result2.out_lines().drop(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(result2.out_lines().length() - this.output_tail()), 0))).$colon$colon((Object)"LaTeX failed:")), progress.echo_error_message$default$2());
                        } else {
                            progress.echo("Building " + pdf_path + " with " + tex_program + " (3rd run)", progress.echo$default$2());
                            String string8 = Bash$.MODULE$.string(tex_program) + " " + Bash$.MODULE$.string(tex_name);
                            Map map4 = Isabelle_System.Settings$.MODULE$.env(tex_env_usesms);
                            SSH.System system4 = progress.bash$default$2();
                            boolean bl10 = progress.bash$default$5();
                            boolean bl11 = progress.bash$default$6();
                            long l4 = progress.bash$default$7();
                            boolean bl12 = progress.bash$default$8();
                            Process_Result result3 = progress.bash(string8, system4, tex_dir, map4, bl10, bl11, l4, bl12);
                        }
                    }
                    if (!((Set)tex_failed$1.elem).apply((Object)tex_path)) {
                        Isabelle_System$.MODULE$.copy_file(math_pdf.$plus(pdf_path), math.$plus(pdf_path.dir()));
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        }
        File$.MODULE$.find_files(component_dir.absolute_file(), (Function1 & Serializable)file -> MODULE$.cleanup_names().contains((Object)file.getName()), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).foreach((Function1 & Serializable)_$2 -> _$2.delete());
        this.cleanup_trees().foreach((Function1)(JProcedure1 & Serializable)name -> Isabelle_System$.MODULE$.rm_tree(component_dir.$plus(Path$.MODULE$.explode(name))));
        Path component_archive = Path$.MODULE$.explode(component + "_" + Naproche$.MODULE$.platform() + ".tar.gz");
        progress.echo("Component archive " + target_dir.$plus(component_archive), progress.echo$default$2());
        String string = "tar -czf " + File$.MODULE$.bash_path(component_archive) + " " + Bash$.MODULE$.string(component);
        SSH.System system2 = progress.bash$default$2();
        Map map2 = progress.bash$default$4();
        boolean bl4 = progress.bash$default$5();
        boolean bl5 = progress.bash$default$6();
        long l2 = progress.bash$default$7();
        boolean bl6 = progress.bash$default$8();
        progress.bash(string, system2, target_dir, map2, bl4, bl5, l2, bl6).check();
        if (((Set)tex_failed.elem).nonEmpty()) {
            package$.MODULE$.error().apply((Object)("LaTeX failed for " + ((Set)tex_failed.elem).size() + " files:\n  " + ((IterableOnceOps)((Set)tex_failed.elem).toList().map((Function1 & Serializable)_$3 -> _$3.implode()).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n  ")));
            return;
        }
    }

    public Progress build_component$default$1() {
        return new Progress();
    }

    public Path build_component$default$2() {
        return Path$.MODULE$.current();
    }

    public boolean build_component$default$3() {
        return false;
    }

    public Isabelle_Tool isabelle_tool() {
        return isabelle_tool;
    }

    private final String $anonfun$1() {
        return "\nUsage: isabelle naproche_component [OPTIONS]\n\n  Options are:\n    -D DIR       target directory (default \".\")\n    -P           produce PDF documents\n\n  Build Isabelle/Naproche component from repository.\n";
    }

    private static final String $anonfun$5(Process_Result git_show$1) {
        return (String)package$.MODULE$.error().apply((Object)("Malformed output of git show:\n" + package$.MODULE$.cat_lines().apply((Object)git_show$1.out_lines().take(1))));
    }

    private final Path relative$1(Path math_pdf$1, File file) {
        return (Path)File$.MODULE$.relative_path(math_pdf$1, File$.MODULE$.path(file)).get();
    }

    private final String relative_name$1(Path math_pdf$3, File file) {
        return this.relative$1(math_pdf$3, file).implode();
    }

    private static final String $anonfun$6() {
        return "pdflatex";
    }
}

