/*
 * Decompiled with CFR 0.152.
 */
package isabelle.setup;

import isabelle.setup.Library;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Environment {
    private static volatile Map<String, String> _settings = null;

    public static Boolean is_windows() {
        return System.getProperty("os.name", "").startsWith("Windows");
    }

    public static Boolean is_linux() {
        return System.getProperty("os.name", "").equals("Linux");
    }

    public static Boolean is_macos() {
        return System.getProperty("os.name", "").equals("Mac OS X");
    }

    public static String slashes(String string) {
        return string.replace('\\', '/');
    }

    public static String standard_path(String string, String string2) {
        if (Environment.is_windows().booleanValue()) {
            String string3 = string2.replace('/', '\\');
            Pattern pattern = Pattern.compile("(?i)" + Pattern.quote(string) + "(?:\\\\+|\\z)(.*)");
            Matcher matcher = pattern.matcher(string3);
            Pattern pattern2 = Pattern.compile("([a-zA-Z]):\\\\*(.*)");
            Matcher matcher2 = pattern2.matcher(string3);
            if (matcher.matches()) {
                String string4 = matcher.group(1);
                return "/" + Environment.slashes(string4);
            }
            if (matcher2.matches()) {
                String string5 = matcher2.group(1).toLowerCase(Locale.ROOT);
                String string6 = matcher2.group(2);
                return "/cygdrive/" + string5 + (String)(string6.isEmpty() ? "" : "/" + Environment.slashes(string6));
            }
            return Environment.slashes(string3);
        }
        return string2;
    }

    public static String expand_platform_path(Map<String, String> map, String string, String string2) throws IOException, InterruptedException {
        Expand_Platform_Path expand_Platform_Path = new Expand_Platform_Path(string);
        expand_Platform_Path.check(map, string2);
        return expand_Platform_Path.result();
    }

    public static String join_platform_paths(List<Path> list) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Path path : list) {
            linkedList.add(path.toString());
        }
        return String.join((CharSequence)File.pathSeparator, linkedList);
    }

    public static String join_standard_paths(List<Path> list) throws IOException, InterruptedException {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Path path : list) {
            linkedList.add(Environment.standard_path(path.toString()));
        }
        return String.join((CharSequence)":", linkedList);
    }

    private static String read_file(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }

    public static ProcessBuilder process_builder(List<String> list, File file, Map<String, String> map, boolean bl) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(list);
        if (file != null) {
            processBuilder.directory(file);
        }
        if (map != null) {
            processBuilder.environment().clear();
            processBuilder.environment().putAll(map);
        }
        processBuilder.redirectErrorStream(bl);
        return processBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exec_Result exec_process(List<String> list, File file, Map<String, String> map, boolean bl) throws IOException, InterruptedException {
        Exec_Result exec_Result;
        Path path = Files.createTempFile(null, null, new FileAttribute[0]);
        Path path2 = Files.createTempFile(null, null, new FileAttribute[0]);
        try {
            ProcessBuilder processBuilder = Environment.process_builder(list, file, map, bl);
            processBuilder.redirectOutput(path.toFile());
            processBuilder.redirectError(path2.toFile());
            Process process = processBuilder.start();
            process.getOutputStream().close();
            try {
                process.waitFor();
            }
            finally {
                process.getInputStream().close();
                process.getErrorStream().close();
                process.destroy();
                Thread.interrupted();
            }
            int n = process.exitValue();
            String string = Environment.read_file(path);
            String string2 = Environment.read_file(path2);
            exec_Result = new Exec_Result(n, string, string2);
        }
        finally {
            Files.deleteIfExists(path);
            Files.deleteIfExists(path2);
        }
        return exec_Result;
    }

    private static String bootstrap_directory(String string, String string2, String string3, String string4) {
        String string5;
        String string6 = string;
        String string7 = System.getenv(string2);
        String string8 = System.getProperty(string3);
        if (string6 != null && !string6.isEmpty()) {
            string5 = string6;
        } else if (string7 != null && !string7.isEmpty()) {
            string5 = string7;
        } else if (string8 != null && !string8.isEmpty()) {
            string5 = string8;
        } else {
            throw new RuntimeException("Unknown " + string4 + " directory");
        }
        if (new File(string5).isDirectory()) {
            return string5;
        }
        throw new RuntimeException("Bad " + string4 + " directory " + Library.quote(string5));
    }

    private static void cygwin_exec(String string, List<String> list) throws IOException, InterruptedException {
        File file = new File(string);
        HashMap<String, String> hashMap = new HashMap<String, String>(System.getenv());
        hashMap.put("CYGWIN", "nodosfilewarning");
        Exec_Result exec_Result = Environment.exec_process(list, file, hashMap, true);
        if (!exec_Result.ok()) {
            throw new RuntimeException(exec_Result.out());
        }
    }

    public static void cygwin_link(String string, File file) throws IOException {
        Path path = file.toPath();
        Files.writeString(path, (CharSequence)("!<symlink>" + string + "\u0000"), new OpenOption[0]);
        Files.setAttribute(path, "dos:system", true, new LinkOption[0]);
    }

    public static void cygwin_init(String string, String string2) throws IOException, InterruptedException {
        if (Environment.is_windows().booleanValue()) {
            boolean bl;
            File file = new File(string2, "isabelle\\uninitialized");
            boolean bl2 = bl = file.isFile() && file.delete();
            if (bl) {
                int n;
                Path path = new File(string2 + "\\isabelle\\symlinks").toPath();
                String[] stringArray = Files.readAllLines(path).toArray(new String[0]);
                int n2 = stringArray.length;
                int n3 = n = n2 > 0 && stringArray[n2 - 1].isEmpty() ? n2 - 1 : n2;
                for (int i = 0; i < n; i += 2) {
                    if (i + 1 < n) {
                        String string3 = stringArray[i];
                        String string4 = stringArray[i + 1];
                        Environment.cygwin_link(string4, new File(string, string3));
                        continue;
                    }
                    throw new RuntimeException("Unbalanced symlinks list");
                }
                Environment.cygwin_exec(string, List.of(string2 + "\\bin\\dash.exe", "/isabelle/rebaseall"));
                Environment.cygwin_exec(string, List.of(string2 + "\\bin\\bash.exe", "/isabelle/postinstall"));
            }
        }
    }

    public static Map<String, String> settings() throws IOException, InterruptedException {
        if (_settings == null) {
            Environment.init("", "");
        }
        return _settings;
    }

    public static String getenv(String string) throws IOException, InterruptedException {
        return Environment.settings().getOrDefault(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init(String string3, String string4) throws IOException, InterruptedException {
        if (_settings == null) {
            String string5 = Environment.bootstrap_directory(string3, "ISABELLE_ROOT", "isabelle.root", "Isabelle root");
            String string6 = "";
            if (Environment.is_windows().booleanValue()) {
                string6 = Environment.bootstrap_directory(string4, "CYGWIN_ROOT", "cygwin.root", "Cygwin root");
                Environment.cygwin_init(string5, string6);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(System.getenv());
            BiFunction<String, String, Void> biFunction = (string, string2) -> {
                if (!string2.isEmpty()) {
                    hashMap.putIfAbsent((String)string, (String)string2);
                }
                return null;
            };
            biFunction.apply("CYGWIN_ROOT", string6);
            biFunction.apply("ISABELLE_JDK_HOME", Environment.standard_path(string6, System.getProperty("java.home", "")));
            biFunction.apply("HOME", System.getProperty("user.home", ""));
            biFunction.apply("ISABELLE_APP", System.getProperty("isabelle.app", ""));
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            Path path = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                LinkedList<String> linkedList = new LinkedList<String>();
                if (Environment.is_windows().booleanValue()) {
                    linkedList.add(string6 + "\\bin\\bash");
                    linkedList.add("-l");
                    linkedList.add(Environment.standard_path(string6, string5 + "\\bin\\isabelle"));
                } else {
                    linkedList.add(string5 + "/bin/isabelle");
                }
                linkedList.add("getenv");
                linkedList.add("-d");
                linkedList.add(path.toString());
                Exec_Result exec_Result = Environment.exec_process(linkedList, null, hashMap, true);
                if (!exec_Result.ok()) {
                    throw new RuntimeException(exec_Result.out());
                }
                for (String string7 : Environment.read_file(path).split("\u0000", -1)) {
                    int n = string7.indexOf(61);
                    if (n > 0) {
                        hashMap2.put(string7.substring(0, n), string7.substring(n + 1));
                        continue;
                    }
                    if (n >= 0 || string7.isEmpty()) continue;
                    hashMap2.put(string7, "");
                }
            }
            finally {
                Files.delete(path);
            }
            if (Environment.is_windows().booleanValue()) {
                hashMap2.put("CYGWIN_ROOT", string6);
            }
            hashMap2.put("PATH", (String)hashMap2.get("PATH_JVM"));
            hashMap2.remove("PATH_JVM");
            _settings = Map.copyOf(hashMap2);
        }
    }

    public static String cygwin_root() throws IOException, InterruptedException {
        return Environment.getenv("CYGWIN_ROOT");
    }

    public static String standard_path(String string) throws IOException, InterruptedException {
        return Environment.standard_path(Environment.cygwin_root(), string);
    }

    public static String expand_platform_path(String string) throws IOException, InterruptedException {
        return Environment.expand_platform_path(Environment.settings(), Environment.cygwin_root(), string);
    }

    public static String platform_path(String string) throws IOException, InterruptedException {
        return Environment.expand_platform_path(null, Environment.cygwin_root(), string);
    }

    public static boolean kill_process(String string, String string2) throws IOException, InterruptedException {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (Environment.is_windows().booleanValue()) {
            linkedList.add(Environment.cygwin_root() + "\\bin\\bash.exe");
        } else {
            linkedList.add("/usr/bin/env");
            linkedList.add("bash");
        }
        linkedList.add("-c");
        linkedList.add("kill -" + string2 + " -" + string);
        return Environment.exec_process(linkedList, null, null, false).ok();
    }

    private static class Expand_Platform_Path {
        private String _cygwin_root;
        private StringBuilder _result = new StringBuilder();

        public Expand_Platform_Path(String string) {
            this._cygwin_root = string;
        }

        public String result() {
            return this._result.toString();
        }

        void clear() {
            this._result.setLength(0);
        }

        void add(char c) {
            this._result.append(c);
        }

        void add(String string) {
            this._result.append(string);
        }

        void separator() {
            int n = this._result.length();
            if (n > 0 && this._result.charAt(n - 1) != File.separatorChar) {
                this.add(File.separatorChar);
            }
        }

        public String check_root(String string) {
            String string2 = string;
            boolean bl = string.startsWith("/");
            if (Environment.is_windows().booleanValue()) {
                Pattern pattern = Pattern.compile("/cygdrive/([a-zA-Z])($|/.*)");
                Matcher matcher = pattern.matcher(string);
                Pattern pattern2 = Pattern.compile("//+([^/]*)(.*)");
                Matcher matcher2 = pattern2.matcher(string);
                if (matcher.matches()) {
                    String string3 = matcher.group(1).toUpperCase(Locale.ROOT);
                    string2 = matcher.group(2);
                    this.clear();
                    this.add(string3);
                    this.add(':');
                    this.add(File.separatorChar);
                } else if (matcher2.matches()) {
                    String string4 = matcher2.group(1);
                    string2 = matcher2.group(2);
                    this.clear();
                    this.add(File.separatorChar);
                    this.add(File.separatorChar);
                    this.add(string4);
                } else if (bl) {
                    this.clear();
                    this.add(this._cygwin_root);
                }
            } else if (bl) {
                this.clear();
                this.add(File.separatorChar);
            }
            return string2;
        }

        public void check_rest(Map<String, String> map, String string) throws IOException, InterruptedException {
            for (String string2 : string.split("/", -1)) {
                if (map != null && string2.startsWith("$")) {
                    String string3 = string2.substring(1);
                    String string4 = map.getOrDefault(string3, "");
                    if (string4.isEmpty()) {
                        throw new RuntimeException("Bad Isabelle environment variable: " + Library.quote(string3));
                    }
                    this.check(null, string4);
                    continue;
                }
                if (string2.isEmpty()) continue;
                this.separator();
                this.add(string2);
            }
        }

        public void check(Map<String, String> map, String string) throws IOException, InterruptedException {
            this.check_rest(map, this.check_root(string));
        }
    }

    public static class Exec_Result {
        private final int _rc;
        private final String _out;
        private final String _err;

        Exec_Result(int n, String string, String string2) {
            this._rc = n;
            this._out = Library.trim_line(string);
            this._err = Library.trim_line(string2);
        }

        public int rc() {
            return this._rc;
        }

        public boolean ok() {
            return this._rc == 0;
        }

        public String out() {
            return this._out;
        }

        public String err() {
            return this._err;
        }
    }
}

