/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManagerTableModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import javax.swing.JPanel;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SegmentBuffer;

public class HighlightOverview
extends JPanel
implements HighlightChangeListener {
    private final IntegerArray items;
    private final JEditTextArea textArea;
    private static final int ITEM_HEIGHT = 4;
    private static final int OVERVIEW_WIDTH = 12;
    private static final int ITEM_BORDER = 2;
    private static final int ITEM_WIDTH = 8;
    private static final int Y_OFFSET = 16;
    private static final Dimension preferredSize = new Dimension(12, 0);
    private Color color;

    HighlightOverview(final JEditTextArea textArea) {
        Font currentFont = this.getFont();
        Font newFont = new Font(currentFont.getName(), 1, 8);
        this.setFont(newFont);
        this.textArea = textArea;
        this.items = new IntegerArray(32);
        this.setRequestFocusEnabled(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int lineCount = textArea.getLineCount();
                int line = HighlightOverview.this.yToLine(e.getY(), lineCount);
                textArea.setFirstLine(Math.max(line - textArea.getVisibleLines() / 2, 0));
            }
        });
    }

    @Override
    public void highlightUpdated(boolean highlightEnabled) {
        long start = System.currentTimeMillis();
        this.items.clear();
        JEditBuffer buffer = this.textArea.getBuffer();
        int lineCount = buffer.getLineCount();
        if (!highlightEnabled || !HighlightManagerTableModel.currentWordHighlight.isEnabled() && !HighlightManagerTableModel.selectionHighlight.isEnabled() || lineCount > jEdit.getIntegerProperty((String)"gatchan.highlight.overview.maxLines", (int)200000)) {
            this.repaint();
            return;
        }
        SearchMatcher matcher = HighlightManagerTableModel.selectionHighlight.isEnabled() ? HighlightManagerTableModel.selectionHighlight.getSearchMatcher() : HighlightManagerTableModel.currentWordHighlight.getSearchMatcher();
        LongAccumulator accumulator = new LongAccumulator(Long::sum, 0L);
        IntStream lineStream = IntStream.range(0, lineCount);
        lineStream.map(line -> HighlightOverview.match(buffer, matcher, line)).filter(line -> line >= 0).forEach(line -> this.pushLine(accumulator, line));
        View view = this.textArea.getView();
        if (view.isActive() && view.getTextArea() == this.textArea) {
            view.getStatus().setMessage(accumulator.longValue() + " lines contains the current word");
        }
        long endTime = System.currentTimeMillis();
        Log.log((int)3, (Object)this, (Object)("Highlight overview processed in " + (endTime - start) + "ms"));
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushLine(LongAccumulator accumulator, int line) {
        IntegerArray integerArray = this.items;
        synchronized (integerArray) {
            this.items.add(line);
            accumulator.accumulate(1L);
        }
    }

    private static int match(JEditBuffer buffer, SearchMatcher matcher, int line) {
        try {
            SegmentBuffer segmentBuffer = new SegmentBuffer(0);
            buffer.getLineText(line, (Segment)segmentBuffer);
            SearchMatcher.Match match = matcher.nextMatch((CharSequence)segmentBuffer, true, true, true, false);
            if (match != null) {
                return line;
            }
        }
        catch (InterruptedException | PatternSyntaxException exception) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public void paintComponent(Graphics gfx) {
        super.paintComponent(gfx);
        if (this.items.isEmpty()) {
            return;
        }
        int lineCount = this.textArea.getLineCount();
        if (this.color != null) {
            gfx.setColor(this.color);
        } else if (HighlightManagerTableModel.selectionHighlight.isEnabled()) {
            gfx.setColor(HighlightManagerTableModel.selectionHighlight.getColor());
        } else {
            gfx.setColor(HighlightManagerTableModel.currentWordHighlight.getColor());
        }
        for (int i = 0; i < this.items.getSize(); ++i) {
            int y = this.lineToY(this.items.get(i), lineCount);
            gfx.fillRect(2, y, 8, 4);
        }
    }

    private int lineToY(int line, int lineCount) {
        return 16 + (this.getHeight() - 32) * line / lineCount - 2;
    }

    int yToLine(int y, int lineCount) {
        return (y + 2 - 16) * lineCount / (this.getHeight() - 32);
    }

    @Override
    public Dimension getPreferredSize() {
        return preferredSize;
    }

    public void setOverviewColor(Color color) {
        this.color = color;
    }
}

