/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.solr.common.util.TimeSource;

public class TimeOut {
    private final long timeoutAt;
    private final long startTime;
    private final TimeSource timeSource;

    public TimeOut(long timeout, TimeUnit unit, TimeSource timeSource) {
        this.timeSource = timeSource;
        this.startTime = timeSource.getTimeNs();
        timeout = Math.max(timeout, 0L);
        long timeoutAt = this.startTime + TimeUnit.NANOSECONDS.convert(timeout, unit);
        this.timeoutAt = timeoutAt < this.startTime ? Long.MAX_VALUE : timeoutAt;
    }

    public boolean hasTimedOut() {
        return this.timeSource.getTimeNs() > this.timeoutAt;
    }

    public void sleep(long ms) throws InterruptedException {
        this.timeSource.sleep(ms);
    }

    public long timeLeft(TimeUnit unit) {
        return unit.convert(this.timeoutAt - this.timeSource.getTimeNs(), TimeUnit.NANOSECONDS);
    }

    public long timeElapsed(TimeUnit unit) {
        return unit.convert(this.timeSource.getTimeNs() - this.startTime, TimeUnit.NANOSECONDS);
    }

    public void waitFor(String messageOnTimeOut, Supplier<Boolean> supplier) throws InterruptedException, TimeoutException {
        while (!supplier.get().booleanValue() && !this.hasTimedOut()) {
            this.timeSource.sleep(250L);
        }
        if (this.hasTimedOut()) {
            throw new TimeoutException(messageOnTimeOut);
        }
    }

    public String toString() {
        return "TimeOut [timeoutAt=" + this.timeoutAt + ", startTime=" + this.startTime + ", timeSource=" + this.timeSource + "]";
    }
}

