/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractSparseSequence;
import kodkod.util.ints.EntryView;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.SparseSequence;

public final class ArraySequence<V>
extends AbstractSparseSequence<V>
implements Cloneable {
    private final EntryView<V>[] entries;
    private int size;

    public ArraySequence(IntSet intSet) {
        this.entries = new EntryView[intSet.size()];
        this.size = intSet.size();
        IntIterator intIterator = intSet.iterator();
        int n = 0;
        while (intIterator.hasNext()) {
            this.entries[n] = new EntryView<Object>(intIterator.next(), null);
            ++n;
        }
    }

    public ArraySequence(SparseSequence<? extends V> sparseSequence) {
        this.entries = new EntryView[sparseSequence.size()];
        this.size = sparseSequence.size();
        int n = 0;
        for (IndexedEntry<V> indexedEntry : sparseSequence) {
            if (indexedEntry.value() == null) {
                throw new NullPointerException();
            }
            this.entries[n++] = new EntryView<V>(indexedEntry.index(), indexedEntry.value());
        }
    }

    private ArraySequence(ArraySequence<V> arraySequence) {
        this.size = arraySequence.size;
        this.entries = new EntryView[arraySequence.entries.length];
        int n = 0;
        for (EntryView<V> entryView : arraySequence.entries) {
            this.entries[n++] = new EntryView<V>(entryView.index(), entryView.value());
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        for (EntryView<Object> entryView : this.entries) {
            entryView.setValue(null);
        }
    }

    private final int search(int n) {
        int n2 = 0;
        int n3 = this.entries.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.entries[n4].index();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    @Override
    public V put(int n, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n2 = this.search(n);
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("" + n);
        }
        if (this.entries[n2] == null) {
            ++this.size;
        }
        return this.entries[n2].setValue(v);
    }

    @Override
    public V get(int n) {
        int n2 = this.search(n);
        return n2 < 0 ? null : (V)this.entries[n2].value();
    }

    @Override
    public V remove(int n) {
        int n2 = this.search(n);
        if (n2 < 0) {
            return null;
        }
        if (this.entries[n2].value() != null) {
            --this.size;
        }
        return this.entries[n2].setValue(null);
    }

    @Override
    public boolean containsIndex(int n) {
        int n2 = this.search(n);
        return n2 >= 0 && this.entries[n2].value() != null;
    }

    @Override
    public Iterator<IndexedEntry<V>> iterator(int n, int n2) {
        return n <= n2 ? new AscendingIterator(n, n2) : new DescendingIterator(n, n2);
    }

    @Override
    public IndexedEntry<V> first() {
        if (this.size == 0) {
            return null;
        }
        for (EntryView<V> entryView : this.entries) {
            if (entryView.value() == null) continue;
            return entryView;
        }
        throw new InternalError();
    }

    @Override
    public IndexedEntry<V> last() {
        if (this.size == 0) {
            return null;
        }
        for (int i = this.entries.length - 1; i >= 0; --i) {
            if (this.entries[i].value() == null) continue;
            return this.entries[i];
        }
        throw new InternalError();
    }

    @Override
    public IndexedEntry<V> ceil(int n) {
        int n2;
        int n3 = this.search(n);
        int n4 = n2 = n3 < 0 ? -n3 - 1 : n3;
        while (n2 < this.entries.length) {
            if (this.entries[n2].value() != null) {
                return this.entries[n2];
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IndexedEntry<V> floor(int n) {
        int n2;
        int n3 = this.search(n);
        int n4 = n2 = n3 < -1 ? -n3 - 2 : n3;
        while (n2 >= 0) {
            if (this.entries[n2].value() != null) {
                return this.entries[n2];
            }
            --n2;
        }
        return null;
    }

    @Override
    public ArraySequence<V> clone() {
        return new ArraySequence<V>(this);
    }

    private final class DescendingIterator
    implements Iterator<IndexedEntry<V>> {
        final int endIndex;
        IndexedEntry<V> lastReturned = null;
        int cursor;

        DescendingIterator(int n, int n2) {
            int n3 = ArraySequence.this.search(n);
            int n4 = ArraySequence.this.search(n2);
            this.cursor = n3 < -1 ? -n3 - 2 : n3;
            this.endIndex = n4 < 0 ? -n4 - 1 : n4;
        }

        @Override
        public boolean hasNext() {
            while (this.cursor >= 0 && ArraySequence.this.entries[this.cursor].value() == null) {
                --this.cursor;
            }
            return this.cursor >= this.endIndex;
        }

        @Override
        public IndexedEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = ArraySequence.this.entries[this.cursor--];
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ArraySequence.this.entries[this.lastReturned.index()].setValue(null);
            this.lastReturned = null;
        }
    }

    private final class AscendingIterator
    implements Iterator<IndexedEntry<V>> {
        final int endIndex;
        IndexedEntry<V> lastReturned = null;
        int cursor;

        AscendingIterator(int n, int n2) {
            int n3 = ArraySequence.this.search(n);
            int n4 = ArraySequence.this.search(n2);
            this.cursor = n3 < 0 ? -n3 - 1 : n3;
            this.endIndex = n4 < -1 ? -n4 - 2 : n4;
        }

        @Override
        public boolean hasNext() {
            while (this.cursor < ArraySequence.this.entries.length && ArraySequence.this.entries[this.cursor].value() == null) {
                ++this.cursor;
            }
            return this.cursor <= this.endIndex;
        }

        @Override
        public IndexedEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = ArraySequence.this.entries[this.cursor++];
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ArraySequence.this.entries[this.lastReturned.index()].setValue(null);
            this.lastReturned = null;
        }
    }
}

