/*
 * Decompiled with CFR 0.152.
 */
package kodkod.instance;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kodkod.instance.TupleFactory;
import kodkod.util.collections.Containers;

public final class Universe
implements Iterable<Object> {
    private final Object[] atoms;
    private final Map<Object, Integer> indices;
    private final TupleFactory factory;

    public Universe(Collection<?> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Cannot create an empty universe.");
        }
        this.atoms = new Object[collection.size()];
        this.indices = new HashMap<Object, Integer>();
        int n = 0;
        for (Object obj : collection) {
            if (this.indices.containsKey(obj)) {
                throw new IllegalArgumentException(obj + " appears multiple times.");
            }
            this.indices.put(obj, n);
            this.atoms[n] = obj;
            ++n;
        }
        this.factory = new TupleFactory(this);
    }

    public Universe(Object ... objectArray) {
        if (objectArray.length == 0) {
            throw new IllegalArgumentException("Cannot create an empty universe.");
        }
        this.atoms = Containers.copy(objectArray, new Object[objectArray.length]);
        this.indices = new HashMap<Object, Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.indices.containsKey(objectArray[i])) {
                throw new IllegalArgumentException(objectArray[i] + " appears multiple times.");
            }
            this.indices.put(objectArray[i], i);
        }
        this.factory = new TupleFactory(this);
    }

    public TupleFactory factory() {
        return this.factory;
    }

    public int size() {
        return this.atoms.length;
    }

    public boolean contains(Object object) {
        return this.indices.containsKey(object);
    }

    public Object atom(int n) {
        if (n < 0 || n >= this.atoms.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.atoms[n];
    }

    public int index(Object object) {
        if (this.indices.containsKey(object)) {
            return this.indices.get(object);
        }
        throw new IllegalArgumentException("no this.atoms." + object);
    }

    @Override
    public Iterator<Object> iterator() {
        return Containers.iterate(this.atoms);
    }

    public String toString() {
        return Arrays.toString(this.atoms);
    }
}

