/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanFactory;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.Int;
import kodkod.engine.bool.Operator;
import kodkod.util.collections.Containers;

final class TwosComplementInt
extends Int {
    private final BooleanValue[] bits;

    private TwosComplementInt(BooleanFactory booleanFactory, BooleanValue[] booleanValueArray) {
        super(booleanFactory);
        this.bits = booleanValueArray;
    }

    TwosComplementInt(BooleanFactory booleanFactory, int n, BooleanValue booleanValue) {
        super(booleanFactory);
        int n2 = this.bitwidth(n);
        this.bits = new BooleanValue[n2];
        for (int i = 0; i < n2; ++i) {
            this.bits[i] = (n & 1 << i) == 0 ? BooleanConstant.FALSE : booleanValue;
        }
    }

    private int bitwidth(int n) {
        if (n > 0) {
            return StrictMath.min(33 - Integer.numberOfLeadingZeros(n), this.factory.bitwidth);
        }
        if (n < 0) {
            return StrictMath.min(33 - Integer.numberOfLeadingZeros(~n), this.factory.bitwidth);
        }
        return 1;
    }

    @Override
    public final boolean isConstant() {
        for (int i = this.width() - 1; i >= 0; --i) {
            BooleanValue booleanValue = this.bit(i);
            if (booleanValue == BooleanConstant.TRUE || booleanValue == BooleanConstant.FALSE) continue;
            return false;
        }
        return true;
    }

    @Override
    public final List<BooleanValue> twosComplementBits() {
        return new AbstractList<BooleanValue>(){

            @Override
            public BooleanValue get(int n) {
                if (n < 0 || n >= TwosComplementInt.this.factory.bitwidth) {
                    throw new IndexOutOfBoundsException();
                }
                return TwosComplementInt.this.bit(n);
            }

            @Override
            public int size() {
                return TwosComplementInt.this.factory.bitwidth;
            }
        };
    }

    @Override
    public int width() {
        return this.bits.length;
    }

    @Override
    public final int value() {
        int n = 0;
        int n2 = this.bits.length - 1;
        for (int i = 0; i < n2; ++i) {
            if (this.bits[i] == BooleanConstant.TRUE) {
                n += 1 << i;
                continue;
            }
            if (this.bits[i] == BooleanConstant.FALSE) continue;
            throw new IllegalStateException(this + " is not constant.");
        }
        if (this.bits[n2] == BooleanConstant.TRUE) {
            n -= 1 << n2;
        } else if (this.bits[n2] != BooleanConstant.FALSE) {
            throw new IllegalStateException(this + " is not constant.");
        }
        return n;
    }

    @Override
    public final BooleanValue bit(int n) {
        return this.bits[StrictMath.min(n, this.bits.length - 1)];
    }

    @Override
    public final BooleanValue eq(Int intVal) {
        this.validate(intVal);
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
        int n = StrictMath.max(this.width(), intVal.width());
        for (int i = 0; i < n; ++i) {
            if (booleanAccumulator.add(this.factory.iff(this.bit(i), intVal.bit(i))) != BooleanConstant.FALSE) continue;
            return BooleanConstant.FALSE;
        }
        return this.factory.accumulate(booleanAccumulator);
    }

    @Override
    public final BooleanValue lt(Int intVal) {
        BooleanValue booleanValue = this.lte(intVal);
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.OR);
        int n = StrictMath.max(this.width(), intVal.width());
        for (int i = 0; i < n; ++i) {
            booleanAccumulator.add(this.factory.xor(this.bit(i), intVal.bit(i)));
        }
        return this.factory.and(booleanValue, this.factory.accumulate(booleanAccumulator));
    }

    @Override
    public BooleanValue lte(Int intVal) {
        this.validate(intVal);
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
        int n = StrictMath.max(this.width(), intVal.width()) - 1;
        booleanAccumulator.add(this.factory.implies(intVal.bit(n), this.bit(n)));
        BooleanValue booleanValue = this.factory.iff(this.bit(n), intVal.bit(n));
        for (int i = n - 1; i >= 0; --i) {
            BooleanValue booleanValue2 = this.bit(i);
            BooleanValue booleanValue3 = intVal.bit(i);
            booleanAccumulator.add(this.factory.implies(booleanValue, this.factory.implies(booleanValue2, booleanValue3)));
            booleanValue = this.factory.and(booleanValue, this.factory.iff(booleanValue2, booleanValue3));
        }
        return this.factory.accumulate(booleanAccumulator);
    }

    @Override
    public Int plus(Int intVal) {
        this.validate(intVal);
        int n = StrictMath.min(StrictMath.max(this.width(), intVal.width()) + 1, this.factory.bitwidth);
        BooleanValue[] booleanValueArray = new BooleanValue[n];
        BooleanValue booleanValue = BooleanConstant.FALSE;
        for (int i = 0; i < n; ++i) {
            BooleanValue booleanValue2 = this.bit(i);
            BooleanValue booleanValue3 = intVal.bit(i);
            booleanValueArray[i] = this.factory.sum(booleanValue2, booleanValue3, booleanValue);
            booleanValue = this.factory.carry(booleanValue2, booleanValue3, booleanValue);
        }
        return new TwosComplementInt(this.factory, booleanValueArray);
    }

    @Override
    public Int minus(Int intVal) {
        this.validate(intVal);
        int n = StrictMath.min(StrictMath.max(this.width(), intVal.width()) + 1, this.factory.bitwidth);
        BooleanValue[] booleanValueArray = new BooleanValue[n];
        BooleanValue booleanValue = BooleanConstant.TRUE;
        for (int i = 0; i < n; ++i) {
            BooleanValue booleanValue2 = this.bit(i);
            BooleanValue booleanValue3 = intVal.bit(i).negation();
            booleanValueArray[i] = this.factory.sum(booleanValue2, booleanValue3, booleanValue);
            booleanValue = this.factory.carry(booleanValue2, booleanValue3, booleanValue);
        }
        return new TwosComplementInt(this.factory, booleanValueArray);
    }

    private BooleanValue addAndCarry(int n, BooleanValue booleanValue, BooleanValue booleanValue2) {
        BooleanValue booleanValue3 = this.bits[n];
        this.bits[n] = this.factory.sum(booleanValue3, booleanValue, booleanValue2);
        return this.factory.carry(booleanValue3, booleanValue, booleanValue2);
    }

    @Override
    public Int multiply(Int intVal) {
        int n;
        this.validate(intVal);
        int n2 = StrictMath.min(this.width() + intVal.width(), this.factory.bitwidth);
        BooleanValue[] booleanValueArray = new BooleanValue[n2];
        TwosComplementInt twosComplementInt = new TwosComplementInt(this.factory, booleanValueArray);
        BooleanValue booleanValue = this.bit(0);
        for (n = 0; n < n2; ++n) {
            booleanValueArray[n] = this.factory.and(booleanValue, intVal.bit(n));
        }
        n = n2 - 1;
        for (int i = 1; i < n; ++i) {
            BooleanValue booleanValue2 = BooleanConstant.FALSE;
            booleanValue = this.bit(i);
            int n3 = n2 - i;
            for (int j = 0; j < n3; ++j) {
                booleanValue2 = twosComplementInt.addAndCarry(j + i, this.factory.and(booleanValue, intVal.bit(j)), booleanValue2);
            }
        }
        twosComplementInt.addAndCarry(n, this.factory.and(this.bit(n), intVal.bit(0)).negation(), BooleanConstant.TRUE);
        return twosComplementInt;
    }

    private BooleanValue[] extend(int n) {
        BooleanValue[] booleanValueArray = new BooleanValue[n];
        int n2 = this.width();
        for (int i = 0; i < n2; ++i) {
            booleanValueArray[i] = this.bits[i];
        }
        BooleanValue booleanValue = this.bits[n2 - 1];
        for (int i = n2; i < n; ++i) {
            booleanValueArray[i] = booleanValue;
        }
        return booleanValueArray;
    }

    private BooleanValue[] nonRestoringDivision(Int intVal, boolean bl) {
        BooleanValue booleanValue;
        BooleanValue booleanValue2;
        int n;
        int n2;
        BooleanValue booleanValue3;
        BooleanValue booleanValue4;
        int n3 = this.factory.bitwidth;
        int n4 = n3 * 2 + 1;
        BooleanValue[] booleanValueArray = this.extend(n4);
        BooleanValue[] booleanValueArray2 = new BooleanValue[n3];
        BooleanValue[] booleanValueArray3 = new BooleanValue[n3];
        BooleanValue booleanValue5 = intVal.bit(n3);
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            booleanValueArray3[i] = this.factory.accumulate(BooleanAccumulator.treeGate(Operator.OR, booleanValueArray));
            int n6 = (n5 + n4 - 1) % n4;
            booleanValueArray2[n3 - i - 1] = booleanValue4 = this.factory.iff(booleanValueArray[n6], booleanValue5);
            booleanValueArray[n6] = BooleanConstant.FALSE;
            n5 = n6;
            booleanValue3 = booleanValue4;
            n2 = (n5 + n3) % n4;
            for (n = 0; n <= n3; ++n) {
                booleanValue2 = this.factory.xor(booleanValue4, intVal.bit(n));
                booleanValue = booleanValueArray[n2];
                booleanValueArray[n2] = this.factory.sum(booleanValue, booleanValue2, booleanValue3);
                booleanValue3 = this.factory.carry(booleanValue, booleanValue2, booleanValue3);
                n2 = (n2 + 1) % n4;
            }
        }
        assert ((n5 + n3) % n4 == 0);
        BooleanValue booleanValue6 = this.factory.or(this.factory.not(this.factory.accumulate(BooleanAccumulator.treeGate(Operator.AND, booleanValueArray3))), this.factory.and(this.factory.xor(booleanValueArray[n3], this.bit(n3)), this.factory.accumulate(BooleanAccumulator.treeGate(Operator.OR, booleanValueArray))));
        BooleanValue booleanValue7 = this.factory.iff(booleanValueArray[n3], intVal.bit(n3));
        if (bl) {
            System.arraycopy(booleanValueArray2, 0, booleanValueArray2, 1, n3 - 1);
            booleanValueArray2[0] = BooleanConstant.TRUE;
            BooleanValue booleanValue8 = this.factory.and(booleanValue6, this.factory.not(booleanValue7));
            booleanValue3 = this.factory.and(booleanValue6, booleanValue7);
            for (n2 = 0; n2 < n3; ++n2) {
                booleanValue4 = booleanValueArray2[n2];
                booleanValueArray2[n2] = this.factory.sum(booleanValue4, booleanValue8, booleanValue3);
                booleanValue3 = this.factory.carry(booleanValue4, booleanValue8, booleanValue3);
            }
            return booleanValueArray2;
        }
        booleanValue3 = this.factory.and(booleanValue6, booleanValue7);
        for (n = 0; n <= n3; ++n) {
            booleanValue2 = this.factory.and(booleanValue6, this.factory.xor(booleanValue7, intVal.bit(n)));
            booleanValue = booleanValueArray[n];
            booleanValueArray[n] = this.factory.sum(booleanValue, booleanValue2, booleanValue3);
            booleanValue3 = this.factory.carry(booleanValue, booleanValue2, booleanValue3);
        }
        BooleanValue[] booleanValueArray4 = new BooleanValue[n3];
        System.arraycopy(booleanValueArray, 0, booleanValueArray4, 0, n3);
        return booleanValueArray4;
    }

    @Override
    public Int divide(Int intVal) {
        this.validate(intVal);
        return new TwosComplementInt(this.factory, this.nonRestoringDivision(intVal, true));
    }

    @Override
    public Int modulo(Int intVal) {
        this.validate(intVal);
        return new TwosComplementInt(this.factory, this.nonRestoringDivision(intVal, false));
    }

    @Override
    public Int choice(BooleanValue booleanValue, Int intVal) {
        this.validate(intVal);
        int n = StrictMath.max(this.width(), intVal.width());
        BooleanValue[] booleanValueArray = new BooleanValue[n];
        for (int i = 0; i < n; ++i) {
            booleanValueArray[i] = this.factory.ite(booleanValue, this.bit(i), intVal.bit(i));
        }
        return new TwosComplementInt(this.factory, booleanValueArray);
    }

    @Override
    public Int and(Int intVal) {
        this.validate(intVal);
        int n = StrictMath.max(this.width(), intVal.width());
        BooleanValue[] booleanValueArray = new BooleanValue[n];
        for (int i = 0; i < n; ++i) {
            booleanValueArray[i] = this.factory.and(this.bit(i), intVal.bit(i));
        }
        return new TwosComplementInt(this.factory, booleanValueArray);
    }

    @Override
    public Int or(Int intVal) {
        this.validate(intVal);
        int n = StrictMath.max(this.width(), intVal.width());
        BooleanValue[] booleanValueArray = new BooleanValue[n];
        for (int i = 0; i < n; ++i) {
            booleanValueArray[i] = this.factory.or(this.bit(i), intVal.bit(i));
        }
        return new TwosComplementInt(this.factory, booleanValueArray);
    }

    @Override
    public Int xor(Int intVal) {
        this.validate(intVal);
        int n = StrictMath.max(this.width(), intVal.width());
        BooleanValue[] booleanValueArray = new BooleanValue[n];
        for (int i = 0; i < n; ++i) {
            booleanValueArray[i] = this.factory.xor(this.bit(i), intVal.bit(i));
        }
        return new TwosComplementInt(this.factory, booleanValueArray);
    }

    @Override
    public Int shl(Int intVal) {
        this.validate(intVal);
        int n = this.factory.bitwidth;
        TwosComplementInt twosComplementInt = new TwosComplementInt(this.factory, this.extend(n));
        int n2 = 32 - Integer.numberOfLeadingZeros(n - 1);
        for (int i = 0; i < n2; ++i) {
            int n3 = 1 << i;
            BooleanValue booleanValue = intVal.bit(i);
            for (int j = n - 1; j >= 0; --j) {
                twosComplementInt.bits[j] = this.factory.ite(booleanValue, j < n3 ? BooleanConstant.FALSE : twosComplementInt.bit(j - n3), twosComplementInt.bits[j]);
            }
        }
        return twosComplementInt;
    }

    private Int shr(Int intVal, BooleanValue booleanValue) {
        this.validate(intVal);
        int n = this.factory.bitwidth;
        TwosComplementInt twosComplementInt = new TwosComplementInt(this.factory, this.extend(n));
        int n2 = 32 - Integer.numberOfLeadingZeros(n - 1);
        for (int i = 0; i < n2; ++i) {
            int n3 = 1 << i;
            int n4 = n - n3;
            BooleanValue booleanValue2 = intVal.bit(i);
            for (int j = 0; j < n; ++j) {
                twosComplementInt.bits[j] = this.factory.ite(booleanValue2, j < n4 ? twosComplementInt.bit(j + n3) : booleanValue, twosComplementInt.bits[j]);
            }
        }
        return twosComplementInt;
    }

    @Override
    public Int shr(Int intVal) {
        return this.shr(intVal, BooleanConstant.FALSE);
    }

    @Override
    public Int sha(Int intVal) {
        return this.shr(intVal, this.bits[this.bits.length - 1]);
    }

    @Override
    public Int negate() {
        return new TwosComplementInt(this.factory, new BooleanValue[]{BooleanConstant.FALSE}).minus(this);
    }

    @Override
    public Int not() {
        int n = this.width();
        BooleanValue[] booleanValueArray = new BooleanValue[n];
        for (int i = 0; i < n; ++i) {
            booleanValueArray[i] = this.factory.not(this.bits[i]);
        }
        return new TwosComplementInt(this.factory, booleanValueArray);
    }

    @Override
    public Int abs() {
        return this.choice(this.factory.not(this.bits[this.bits.length - 1]), this.negate());
    }

    @Override
    public Int sgn() {
        BooleanValue[] booleanValueArray = new BooleanValue[]{this.factory.accumulate(BooleanAccumulator.treeGate(Operator.OR, this.bits)), this.bits[this.bits.length - 1]};
        return new TwosComplementInt(this.factory, booleanValueArray);
    }

    public String toString() {
        return "b" + Arrays.toString(this.bits);
    }

    private Int apply(boolean bl, Int ... intArray) {
        Int[] intArray2 = Containers.copy(intArray, 0, new Int[intArray.length + 1], 1, intArray.length);
        intArray2[0] = this;
        for (int i = intArray2.length; i > 1; i -= i / 2) {
            int n = i - 1;
            for (int j = 0; j < n; j += 2) {
                intArray2[j / 2] = bl ? intArray2[j].plus(intArray2[j + 1]) : intArray2[j].multiply(intArray2[j + 1]);
            }
            if (n % 2 != 0) continue;
            intArray2[n / 2] = intArray2[n];
        }
        return intArray2[0];
    }

    @Override
    public Int plus(Int ... intArray) {
        return this.apply(true, intArray);
    }

    @Override
    public Int multiply(Int ... intArray) {
        return this.apply(false, intArray);
    }

    private Int apply(Operator.Nary nary, Int ... intArray) {
        int n = this.width();
        for (Int object : intArray) {
            this.validate(object);
            n = Math.max(n, object.width());
        }
        Object[] objectArray = new BooleanValue[n];
        BooleanConstant booleanConstant = nary.shortCircuit();
        for (int i = 0; i < n; ++i) {
            BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(nary, this.bit(i));
            for (Int intVal : intArray) {
                if (booleanAccumulator.add(intVal.bit(i)) == booleanConstant) break;
            }
            objectArray[i] = this.factory.accumulate(booleanAccumulator);
        }
        return new TwosComplementInt(this.factory, (BooleanValue[])objectArray);
    }

    @Override
    public Int and(Int ... intArray) {
        return this.apply(Operator.AND, intArray);
    }

    @Override
    public Int or(Int ... intArray) {
        return this.apply(Operator.OR, intArray);
    }
}

