/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine;

import kodkod.engine.Proof;
import kodkod.engine.Statistics;
import kodkod.instance.Instance;

public final class Solution {
    private final Outcome outcome;
    private final Statistics stats;
    private final Instance instance;
    private final Proof proof;

    private Solution(Outcome outcome, Statistics statistics, Instance instance, Proof proof) {
        assert (outcome != null && statistics != null);
        this.outcome = outcome;
        this.stats = statistics;
        this.instance = instance;
        this.proof = proof;
    }

    static Solution satisfiable(Statistics statistics, Instance instance) {
        return new Solution(Outcome.SATISFIABLE, statistics, instance, null);
    }

    static Solution triviallySatisfiable(Statistics statistics, Instance instance) {
        return new Solution(Outcome.TRIVIALLY_SATISFIABLE, statistics, instance, null);
    }

    static Solution unsatisfiable(Statistics statistics, Proof proof) {
        return new Solution(Outcome.UNSATISFIABLE, statistics, null, proof);
    }

    static Solution triviallyUnsatisfiable(Statistics statistics, Proof proof) {
        return new Solution(Outcome.TRIVIALLY_UNSATISFIABLE, statistics, null, proof);
    }

    public Outcome outcome() {
        return this.outcome;
    }

    public Instance instance() {
        return this.instance;
    }

    public Proof proof() {
        return this.proof;
    }

    public Statistics stats() {
        return this.stats;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---OUTCOME---\n");
        stringBuilder.append((Object)this.outcome);
        stringBuilder.append("\n");
        if (this.instance != null) {
            stringBuilder.append("\n---INSTANCE---\n");
            stringBuilder.append(this.instance);
            stringBuilder.append("\n");
        }
        if (this.proof != null) {
            stringBuilder.append("\n---PROOF---\n");
            stringBuilder.append(this.proof);
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n---STATS---\n");
        stringBuilder.append(this.stats);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static enum Outcome {
        SATISFIABLE,
        UNSATISFIABLE,
        TRIVIALLY_SATISFIABLE,
        TRIVIALLY_UNSATISFIABLE;

    }
}

