/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Expression;
import kodkod.ast.operator.ExprOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class BinaryExpression
extends Expression {
    private final ExprOperator op;
    private final Expression left;
    private final Expression right;
    private final int arity;

    BinaryExpression(Expression expression, ExprOperator exprOperator, Expression expression2) {
        switch (exprOperator) {
            case UNION: 
            case INTERSECTION: 
            case DIFFERENCE: 
            case OVERRIDE: {
                this.arity = expression.arity();
                if (this.arity == expression2.arity()) break;
                throw new IllegalArgumentException("Incompatible arities: " + expression + " and " + expression2);
            }
            case JOIN: {
                this.arity = expression.arity() + expression2.arity() - 2;
                if (this.arity >= 1) break;
                throw new IllegalArgumentException("Incompatible arities: " + expression + " and " + expression2);
            }
            case PRODUCT: {
                this.arity = expression.arity() + expression2.arity();
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a binary operator: " + (Object)((Object)exprOperator));
            }
        }
        this.op = exprOperator;
        this.left = expression;
        this.right = expression2;
    }

    @Override
    public int arity() {
        return this.arity;
    }

    public ExprOperator op() {
        return this.op;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public <E, F, D, I> E accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "(" + this.left + " " + (Object)((Object)this.op) + " " + this.right + ")";
    }
}

