/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractSparseSequence;
import kodkod.util.ints.EntryView;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.IntTree;

public final class RangeSequence<V>
extends AbstractSparseSequence<V>
implements Cloneable {
    private final IntTree<Entry<V>> tree;
    private final EntryView<V> view;
    private int size;

    public RangeSequence() {
        this.view = new EntryView<Object>(Integer.MIN_VALUE, null);
        this.tree = new IntTree();
        this.size = 0;
    }

    private RangeSequence(RangeSequence<V> rangeSequence) {
        this.size = rangeSequence.size;
        try {
            this.tree = rangeSequence.tree.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        this.view = new EntryView<Object>(Integer.MIN_VALUE, null);
    }

    @Override
    public Iterator<IndexedEntry<V>> iterator(int n, int n2) {
        return n <= n2 ? new AscendingIterator(n, n2) : new DescendingIterator(n, n2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.tree.clear();
        this.size = 0;
    }

    private boolean isHeadOf(Entry<V> entry, int n, V v) {
        return entry != null && entry.key == n - 1 && RangeSequence.equal(entry.value, v);
    }

    private boolean isTailOf(Entry<V> entry, int n, V v) {
        return entry != null && entry.min() == n + 1 && RangeSequence.equal(entry.value, v);
    }

    private void merge(int n, V v, Entry<V> entry, Entry<V> entry2) {
        if (this.isHeadOf(entry, n, v)) {
            if (entry.isPoint()) {
                if (this.isTailOf(entry2, n, v)) {
                    if (entry2.isPoint()) {
                        this.tree.delete(entry2);
                        this.tree.replace(entry, new Range<V>(entry.key, entry2.key, v));
                    } else {
                        this.tree.delete(entry);
                        ((Range)entry2).min = entry.key;
                    }
                } else {
                    this.tree.replace(entry, new Range<V>(entry.key, n, v));
                }
            } else if (this.isTailOf(entry2, n, v)) {
                this.tree.delete(entry2);
                entry.key = entry2.key;
            } else {
                entry.key = n;
            }
        } else if (this.isTailOf(entry2, n, v)) {
            if (entry2.isPoint()) {
                this.tree.replace(entry2, new Range<V>(n, entry2.key, v));
            } else {
                ((Range)entry2).min = n;
            }
        } else {
            this.tree.insert(new Point<V>(n, v));
        }
    }

    @Override
    public V put(int n, V v) {
        Entry<V> entry = this.tree.searchGTE(n);
        if (entry == null || entry.min() > n) {
            ++this.size;
            this.merge(n, v, this.tree.searchLTE(n), entry);
            return null;
        }
        if (RangeSequence.equal(v, entry.value)) {
            return v;
        }
        if (entry.isPoint()) {
            if (this.isHeadOf(this.tree.predecessor(entry), n, v) || this.isTailOf(this.tree.successor(entry), n, v)) {
                V v2 = this.remove(n);
                this.put(n, v);
                return v2;
            }
            return entry.setValue(v);
        }
        V v3 = this.split(n, entry);
        this.tree.insert(new Point<V>(n, v));
        return v3;
    }

    @Override
    public V get(int n) {
        Entry<V> entry = this.tree.searchGTE(n);
        return entry == null || entry.min() > n ? null : (V)entry.value;
    }

    private V split(int n, Entry<V> entry) {
        Object v = entry.value;
        if (entry.isPoint()) {
            this.tree.delete(entry);
        } else {
            Range range = (Range)entry;
            int n2 = range.min++;
            int n3 = range.key--;
            if (n2 == n) {
                if (n2 + 1 >= n3) {
                    this.tree.replace(range, new Point(n3, v));
                }
            } else if (n3 == n) {
                if (n3 - 1 <= n2) {
                    this.tree.replace(range, new Point(n2, v));
                }
            } else if (n2 == n - 1) {
                this.tree.replace(range, new Point(n - 1, v));
                if (n3 == n + 1) {
                    this.tree.insert(new Point(n3, v));
                } else {
                    range.min = n + 1;
                    this.tree.insert(range);
                }
            } else {
                range.key = n - 1;
                if (n3 == n + 1) {
                    this.tree.insert(new Point(n3, v));
                } else {
                    this.tree.insert(new Range(n + 1, n3, v));
                }
            }
        }
        return v;
    }

    @Override
    public V remove(int n) {
        Entry<V> entry = this.tree.searchGTE(n);
        if (entry == null || n < entry.min()) {
            return null;
        }
        --this.size;
        return this.split(n, entry);
    }

    @Override
    public boolean containsIndex(int n) {
        Entry<V> entry = this.tree.searchGTE(n);
        return entry != null && entry.min() <= n;
    }

    @Override
    public IndexedEntry<V> first() {
        Entry<V> entry = this.tree.min();
        return entry == null ? null : this.view.setView(entry.min(), entry.value);
    }

    @Override
    public IndexedEntry<V> last() {
        Entry<V> entry = this.tree.max();
        return entry == null ? null : this.view.setView(entry.max(), entry.value);
    }

    @Override
    public IndexedEntry<V> ceil(int n) {
        Entry<V> entry = this.tree.searchGTE(n);
        return entry == null ? null : this.view.setView(StrictMath.max(n, entry.min()), entry.value);
    }

    @Override
    public IndexedEntry<V> floor(int n) {
        Entry<V> entry = this.tree.searchGTE(n);
        if (entry == null || entry.min() > n) {
            entry = this.tree.searchLTE(n);
            return entry == null ? null : this.view.setView(entry.max(), entry.value);
        }
        return this.view.setView(n, entry.value);
    }

    @Override
    public RangeSequence<V> clone() {
        return new RangeSequence<V>(this);
    }

    private final class DescendingIterator
    extends EntryIterator {
        DescendingIterator(int n, int n2) {
            super(n2);
            this.next = (Entry)RangeSequence.this.tree.searchGTE(n);
            this.index = Integer.MAX_VALUE;
            if (this.next == null || this.next.min() > n) {
                this.next = (Entry)RangeSequence.this.tree.searchLTE(n);
                if (this.next == null) {
                    this.cursor = -1;
                    this.endpoint = 0;
                    this.value = null;
                } else {
                    this.cursor = this.next.key;
                    this.endpoint = this.next.min();
                    this.value = this.next.value;
                }
            } else {
                this.cursor = StrictMath.min(this.next.key, n);
                this.endpoint = this.next.min();
                this.value = this.next.value;
                this.next = RangeSequence.this.tree.predecessor(this.next);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.cursor < this.endpoint) {
                if (this.next == null) {
                    return false;
                }
                this.cursor = this.next.key;
                this.endpoint = this.next.min();
                this.value = this.next.value;
                this.next = RangeSequence.this.tree.predecessor(this.next);
            }
            return this.index > Integer.MIN_VALUE && this.cursor >= this.endIndex;
        }

        @Override
        public IndexedEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.index = this.cursor--;
            this.canRemove = true;
            return this;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            RangeSequence.this.remove(this.index);
            this.next = (Entry)RangeSequence.this.tree.searchLTE(this.cursor);
            this.canRemove = false;
        }
    }

    private final class AscendingIterator
    extends EntryIterator {
        AscendingIterator(int n, int n2) {
            super(n2);
            this.next = (Entry)RangeSequence.this.tree.searchGTE(n);
            this.index = Integer.MIN_VALUE;
            if (this.next == null) {
                this.cursor = 0;
                this.endpoint = -1;
                this.value = null;
            } else {
                this.cursor = StrictMath.max(this.next.min(), n);
                this.endpoint = this.next.key;
                this.value = this.next.value;
                this.next = RangeSequence.this.tree.successor(this.next);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.cursor > this.endpoint) {
                if (this.next == null) {
                    return false;
                }
                this.cursor = this.next.min();
                this.endpoint = this.next.key;
                this.value = this.next.value;
                this.next = RangeSequence.this.tree.successor(this.next);
            }
            return this.index < Integer.MAX_VALUE && this.cursor <= this.endIndex;
        }

        @Override
        public IndexedEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.index = this.cursor++;
            this.canRemove = true;
            return this;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            RangeSequence.this.remove(this.index);
            this.next = (Entry)RangeSequence.this.tree.searchGTE(this.cursor);
            this.canRemove = false;
        }
    }

    private abstract class EntryIterator
    implements Iterator<IndexedEntry<V>>,
    IndexedEntry<V> {
        final int endIndex;
        int endpoint;
        int cursor;
        int index;
        boolean canRemove;
        Entry<V> next;
        V value;

        EntryIterator(int n) {
            this.endIndex = n;
            this.canRemove = false;
        }

        @Override
        public final int index() {
            return this.index;
        }

        @Override
        public final V value() {
            return this.value;
        }

        @Override
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof IndexedEntry)) {
                return false;
            }
            return AbstractSparseSequence.equal(this, (IndexedEntry)object);
        }

        @Override
        public final int hashCode() {
            return AbstractSparseSequence.hashCode(this);
        }

        public final String toString() {
            return this.index + "=" + this.value;
        }
    }

    private static final class Range<V>
    extends Entry<V> {
        int min;

        Range(int n, int n2, V v) {
            super(n2, v);
            this.min = n;
        }

        @Override
        int min() {
            return this.min;
        }

        @Override
        boolean isPoint() {
            return false;
        }

        @Override
        protected Range<V> clone() throws CloneNotSupportedException {
            return (Range)super.clone();
        }
    }

    private static final class Point<V>
    extends Entry<V> {
        Point(int n, V v) {
            super(n, v);
        }

        @Override
        int min() {
            return this.key;
        }

        @Override
        boolean isPoint() {
            return true;
        }

        @Override
        protected Point<V> clone() throws CloneNotSupportedException {
            return (Point)super.clone();
        }
    }

    private static abstract class Entry<V>
    extends IntTree.Node<Entry<V>>
    implements Cloneable {
        V value;

        Entry(int n, V v) {
            super(n);
            this.value = v;
        }

        V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        abstract int min();

        final int max() {
            return this.key;
        }

        abstract boolean isPoint();

        @Override
        protected Entry<V> clone() throws CloneNotSupportedException {
            return (Entry)super.clone();
        }
    }
}

