/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractIntSet;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;
import kodkod.util.ints.SparseSequence;

public abstract class AbstractSparseSequence<V>
implements SparseSequence<V> {
    protected AbstractSparseSequence() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<IndexedEntry<V>> iterator() {
        return this.iterator(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public IndexedEntry<V> first() {
        return this.isEmpty() ? null : this.iterator().next();
    }

    @Override
    public IndexedEntry<V> last() {
        return this.isEmpty() ? null : this.iterator(Integer.MAX_VALUE, Integer.MIN_VALUE).next();
    }

    @Override
    public IndexedEntry<V> ceil(int n) {
        Iterator iterator = this.iterator(n, Integer.MAX_VALUE);
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public IndexedEntry<V> floor(int n) {
        Iterator iterator = this.iterator(n, Integer.MIN_VALUE);
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public IntSet indices() {
        return new AbstractIntSet(){

            @Override
            public IntIterator iterator(final int n, final int n2) {
                return new IntIterator(){
                    Iterator<IndexedEntry<V>> iter;
                    {
                        this.iter = AbstractSparseSequence.this.iterator(n, n2);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public int next() {
                        return this.iter.next().index();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractSparseSequence.this.size();
            }

            @Override
            public boolean contains(int n) {
                return AbstractSparseSequence.this.containsIndex(n);
            }

            @Override
            public int min() {
                IndexedEntry indexedEntry = AbstractSparseSequence.this.first();
                if (indexedEntry == null) {
                    throw new NoSuchElementException();
                }
                return indexedEntry.index();
            }

            @Override
            public int max() {
                IndexedEntry indexedEntry = AbstractSparseSequence.this.last();
                if (indexedEntry == null) {
                    throw new NoSuchElementException();
                }
                return indexedEntry.index();
            }

            @Override
            public boolean remove(int n) {
                boolean bl = AbstractSparseSequence.this.containsIndex(n);
                AbstractSparseSequence.this.remove(n);
                return bl;
            }

            @Override
            public int floor(int n) {
                IndexedEntry indexedEntry = AbstractSparseSequence.this.floor(n);
                if (indexedEntry == null) {
                    throw new NoSuchElementException();
                }
                return indexedEntry.index();
            }

            @Override
            public int ceil(int n) {
                IndexedEntry indexedEntry = AbstractSparseSequence.this.ceil(n);
                if (indexedEntry == null) {
                    throw new NoSuchElementException();
                }
                return indexedEntry.index();
            }

            @Override
            public void clear() {
                AbstractSparseSequence.this.clear();
            }

            @Override
            public IntSet clone() throws CloneNotSupportedException {
                IntSet intSet = this.size() == 0 ? Ints.bestSet(Integer.MIN_VALUE, Integer.MAX_VALUE) : Ints.bestSet(this.min(), this.max());
                intSet.addAll(this);
                return intSet;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public int size() {
                return AbstractSparseSequence.this.size();
            }

            @Override
            public boolean isEmpty() {
                return AbstractSparseSequence.this.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return AbstractSparseSequence.this.contains(object);
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<IndexedEntry<V>> iter;
                    {
                        this.iter = AbstractSparseSequence.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public void clear() {
                AbstractSparseSequence.this.clear();
            }
        };
    }

    @Override
    public boolean containsIndex(int n) {
        return this.iterator(n, n).hasNext();
    }

    @Override
    public boolean contains(Object object) {
        for (IndexedEntry<V> indexedEntry : this) {
            if (!AbstractSparseSequence.equal(object, indexedEntry.value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public SparseSequence<V> clone() throws CloneNotSupportedException {
        return (SparseSequence)super.clone();
    }

    @Override
    public V remove(int n) {
        Iterator iterator = this.iterator(n, n);
        if (iterator.hasNext()) {
            Object v = iterator.next().value();
            iterator.remove();
            return v;
        }
        return null;
    }

    @Override
    public void clear() {
        Iterator<IndexedEntry<V>> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public V put(int n, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(SparseSequence<? extends V> sparseSequence) {
        for (IndexedEntry<V> indexedEntry : sparseSequence) {
            this.put(indexedEntry.index(), indexedEntry.value());
        }
    }

    static boolean equal(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static boolean equal(IndexedEntry<?> indexedEntry, IndexedEntry<?> indexedEntry2) {
        return indexedEntry.index() == indexedEntry2.index() && AbstractSparseSequence.equal(indexedEntry.value(), indexedEntry2.value());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SparseSequence)) {
            return false;
        }
        SparseSequence sparseSequence = (SparseSequence)object;
        if (sparseSequence.size() != this.size()) {
            return false;
        }
        try {
            Iterator<IndexedEntry<V>> iterator = this.iterator();
            Iterator iterator2 = sparseSequence.iterator();
            while (iterator.hasNext()) {
                if (AbstractSparseSequence.equal(iterator.next(), iterator2.next())) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    static int hashCode(IndexedEntry<?> indexedEntry) {
        return indexedEntry.index() ^ (indexedEntry.value() == null ? 0 : indexedEntry.value().hashCode());
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (IndexedEntry<V> indexedEntry : this) {
            n += AbstractSparseSequence.hashCode(indexedEntry);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<IndexedEntry<V>> iterator = this.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            IndexedEntry<V> indexedEntry = iterator.next();
            stringBuilder.append(indexedEntry.index());
            stringBuilder.append("=");
            if (indexedEntry.value() == this) {
                stringBuilder.append("(this sequence)");
            } else {
                stringBuilder.append(indexedEntry.value());
            }
            if (!(bl = iterator.hasNext())) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

