/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractIntCollection;
import kodkod.util.ints.IntCollection;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntVector;
import kodkod.util.ints.Ints;

public abstract class AbstractIntVector
extends AbstractIntCollection
implements IntVector {
    protected AbstractIntVector() {
    }

    @Override
    public boolean contains(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.get(i) != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public int set(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.get(i) != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i) != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean add(int n) {
        int n2 = this.size();
        this.add(n2, n);
        return n2 != this.size();
    }

    @Override
    public void add(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        return this.addAll(this.size(), intCollection);
    }

    @Override
    public boolean addAll(int n, IntCollection intCollection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int removeAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterator iterator() {
        return this.iterator(0, this.size());
    }

    @Override
    public IntIterator iterator(int n, int n2) {
        return n <= n2 ? new AscendingIntVectorIterator(n, n2) : new DescendingIntVectorIterator(n, n2);
    }

    @Override
    public int hashCode() {
        int n;
        int n2 = n = this.size();
        for (int i = 0; i < n; ++i) {
            n2 = Ints.superFastHashIncremental(this.get(i), n2);
        }
        return Ints.superFastHashAvalanche(n2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IntVector) {
            IntVector intVector = (IntVector)object;
            int n = this.size();
            if (intVector.size() == n) {
                for (int i = 0; i < n; ++i) {
                    if (this.get(i) == intVector.get(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        IntIterator intIterator = this.iterator();
        if (intIterator.hasNext()) {
            stringBuilder.append(intIterator.next());
        }
        while (intIterator.hasNext()) {
            stringBuilder.append(", ");
            stringBuilder.append(intIterator.next());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private final class DescendingIntVectorIterator
    extends IntVectorIterator {
        DescendingIntVectorIterator(int n, int n2) {
            super(n, n2);
        }

        @Override
        public boolean hasNext() {
            return this.next > this.end;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.next--;
            return AbstractIntVector.this.get(this.last);
        }
    }

    private final class AscendingIntVectorIterator
    extends IntVectorIterator {
        AscendingIntVectorIterator(int n, int n2) {
            super(n, n2);
        }

        @Override
        public boolean hasNext() {
            return this.last < Integer.MAX_VALUE && this.next < this.end;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.next++;
            return AbstractIntVector.this.get(this.last);
        }
    }

    private abstract class IntVectorIterator
    implements IntIterator {
        int next;
        int end;
        int last;

        IntVectorIterator(int n, int n2) {
            this.next = n;
            this.end = n2;
            this.last = -1;
        }

        @Override
        public final void remove() {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            AbstractIntVector.this.removeAt(this.last);
            this.next = this.last;
            this.last = -1;
        }
    }
}

