/*
 * Decompiled with CFR 0.152.
 */
package kodkod.instance;

import java.util.Collection;
import java.util.List;
import kodkod.engine.CapacityExceededException;
import kodkod.instance.Tuple;
import kodkod.instance.TupleSet;
import kodkod.instance.Universe;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

public final class TupleFactory {
    private final Universe universe;
    private final int base;

    TupleFactory(Universe universe) {
        this.universe = universe;
        this.base = universe.size();
    }

    public Universe universe() {
        return this.universe;
    }

    public Tuple tuple(Object ... objectArray) {
        if (objectArray.length < 1) {
            throw new IllegalArgumentException("atoms.length<1");
        }
        return new IntTuple(objectArray);
    }

    public Tuple tuple(List<?> list) {
        if (list.size() < 1) {
            throw new IllegalArgumentException("atoms.size()<1");
        }
        return new IntTuple(list.toArray());
    }

    public Tuple tuple(int n, int n2) {
        return new IntTuple(n, n2);
    }

    public TupleSet allOf(int n) {
        return new TupleSet(this.universe, n, 0, (int)Math.pow(this.base, n) - 1);
    }

    public TupleSet setOf(Object ... objectArray) {
        TupleSet tupleSet = new TupleSet(this.universe, 1);
        for (Object object : objectArray) {
            tupleSet.add(new IntTuple(object));
        }
        return tupleSet;
    }

    public TupleSet setOf(Tuple tuple, Tuple ... tupleArray) {
        if (!tuple.universe().equals(this.universe)) {
            throw new IllegalArgumentException("first.universe != this.universe");
        }
        TupleSet tupleSet = new TupleSet(this.universe, tuple.arity(), tuple.index(), tuple.index());
        for (Tuple tuple2 : tupleArray) {
            tupleSet.add(tuple2);
        }
        return tupleSet;
    }

    public TupleSet setOf(Collection<Tuple> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("tuples.isEmpty()");
        }
        TupleSet tupleSet = new TupleSet(this.universe, collection.iterator().next().arity());
        for (Tuple tuple : collection) {
            tupleSet.add(tuple);
        }
        return tupleSet;
    }

    public TupleSet setOf(int n, IntSet intSet) {
        try {
            return new TupleSet(this.universe, n, intSet.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException("uncloneable int set");
        }
    }

    public TupleSet noneOf(int n) {
        return new TupleSet(this.universe, n);
    }

    public TupleSet range(Tuple tuple, Tuple tuple2) {
        if (tuple.arity() != tuple2.arity()) {
            throw new IllegalArgumentException("from.arity!=to.arity");
        }
        if (!tuple.universe().equals(this.universe) || !tuple2.universe().equals(this.universe)) {
            throw new IllegalArgumentException("from.universe != this.universe || to.universe != this.universe");
        }
        return new TupleSet(this.universe, tuple.arity(), tuple.index(), tuple2.index());
    }

    public TupleSet area(Tuple tuple, Tuple tuple2) {
        if (!tuple.universe().equals(this.universe) || tuple.arity() != tuple2.arity()) {
            throw new IllegalArgumentException();
        }
        TupleSet tupleSet = new TupleSet(this.universe, 1, tuple.atomIndex(0), tuple2.atomIndex(0));
        for (int i = 1; i < tuple.arity(); ++i) {
            tupleSet = tupleSet.product(new TupleSet(this.universe, 1, tuple.atomIndex(i), tuple2.atomIndex(i)));
        }
        return tupleSet;
    }

    void checkCapacity(int n) {
        if (StrictMath.pow(this.base, n) > 2.147483647E9) {
            throw new CapacityExceededException("Arity too large (" + n + ") for a universe of size " + this.universe.size(), Ints.nCopies(n, this.base));
        }
    }

    int project(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= n2) {
            throw new IndexOutOfBoundsException(n3 + "");
        }
        return n / (int)Math.pow(this.base, n2 - 1 - n3) % this.base;
    }

    private final class IntTuple
    extends Tuple {
        private final int arity;
        private final int index;

        IntTuple(int n, int n2) {
            TupleFactory.this.checkCapacity(n);
            if (n < 1 || n2 < 0 || (double)n2 >= Math.pow(TupleFactory.this.base, n)) {
                throw new IllegalArgumentException("arity < 1 || index < 0 || index >= universe.size^arity");
            }
            this.arity = n;
            this.index = n2;
        }

        IntTuple(Object ... objectArray) {
            this.arity = objectArray.length;
            TupleFactory.this.checkCapacity(this.arity);
            int n = 0;
            int n2 = 1;
            for (int i = this.arity - 1; i >= 0; --i) {
                n += TupleFactory.this.universe.index(objectArray[i]) * n2;
                n2 *= TupleFactory.this.base;
            }
            this.index = n;
            assert (this.index >= 0);
        }

        IntTuple(int n, Object object) {
            TupleFactory.this.checkCapacity(n);
            if (n < 1) {
                throw new IllegalArgumentException("arity < 1");
            }
            this.arity = n;
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                n2 = n2 * TupleFactory.this.base + 1;
            }
            this.index = TupleFactory.this.universe.index(object) * n2;
            assert (this.index >= 0);
        }

        @Override
        public Universe universe() {
            return TupleFactory.this.universe;
        }

        @Override
        public int arity() {
            return this.arity;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public Object atom(int n) {
            return TupleFactory.this.universe.atom(this.atomIndex(n));
        }

        @Override
        public int atomIndex(int n) {
            return TupleFactory.this.project(this.index, this.arity, n);
        }

        @Override
        public boolean contains(Object object) {
            int n = TupleFactory.this.universe.index(object);
            for (int i = this.index; i > 0; i /= TupleFactory.this.base) {
                if (i % TupleFactory.this.base != n) continue;
                return true;
            }
            return false;
        }

        @Override
        public Tuple product(Tuple tuple) {
            if (!TupleFactory.this.universe.equals(tuple.universe())) {
                throw new IllegalArgumentException("tuple.universe != this.universe");
            }
            return new IntTuple(this.arity + tuple.arity(), this.index * (int)Math.pow(TupleFactory.this.base, tuple.arity()) + tuple.index());
        }
    }
}

