/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.ucore;

import java.util.Iterator;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.satlab.Clause;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.engine.satlab.ResolutionTrace;
import kodkod.engine.ucore.StrategyUtils;
import kodkod.util.ints.IntBitSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

public final class HybridStrategy
implements ReductionStrategy {
    private final IntSet topVars;

    public HybridStrategy(TranslationLog translationLog) {
        this.topVars = StrategyUtils.rootVars(translationLog);
    }

    @Override
    public IntSet next(ResolutionTrace resolutionTrace) {
        if (this.topVars.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        IntSet intSet = resolutionTrace.core();
        Iterator<Clause> iterator = resolutionTrace.iterator(intSet);
        while (iterator.hasNext()) {
            Clause clause = iterator.next();
            int n = clause.maxVariable();
            if (!this.topVars.remove(n)) continue;
            IntSet intSet2 = HybridStrategy.coreClausesWithMaxVar(resolutionTrace, n);
            assert (!intSet2.isEmpty());
            IntSet intSet3 = resolutionTrace.reachable(Ints.singleton(resolutionTrace.size() - 1));
            intSet3.removeAll(resolutionTrace.backwardReachable(intSet2));
            if (intSet3.isEmpty()) continue;
            return intSet3;
        }
        this.topVars.clear();
        return Ints.EMPTY_SET;
    }

    private static IntSet coreClausesWithMaxVar(ResolutionTrace resolutionTrace, int n) {
        IntSet intSet = resolutionTrace.core();
        IntBitSet intBitSet = new IntBitSet(intSet.max() + 1);
        Iterator<Clause> iterator = resolutionTrace.iterator(intSet);
        IntIterator intIterator = intSet.iterator();
        while (iterator.hasNext()) {
            Clause clause = iterator.next();
            int n2 = intIterator.next();
            if (clause.maxVariable() != n) continue;
            intBitSet.add(n2);
        }
        return intBitSet;
    }
}

