/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.ucore;

import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.engine.satlab.ResolutionTrace;
import kodkod.engine.ucore.StrategyUtils;
import kodkod.util.ints.IntCollection;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

public final class AdaptiveRCEStrategy
implements ReductionStrategy {
    private final IntCollection varsToTry;
    private final double noRecycleRatio;
    private final double recycleLimit;
    private final double hardnessCutOff;
    private static final boolean DBG = true;

    public AdaptiveRCEStrategy(TranslationLog translationLog) {
        this(translationLog, 0.03, 2.0, 1.2);
    }

    public AdaptiveRCEStrategy(TranslationLog translationLog, double d, double d2, double d3) {
        this.varsToTry = StrategyUtils.rootVars(translationLog);
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("noRecycleRatio must be in [0..1]: " + d);
        }
        if (d2 < 1.0) {
            throw new IllegalArgumentException("hardnessCutOff must be >=1: " + d2);
        }
        if (d3 < 1.0) {
            throw new IllegalArgumentException("recycleLimit must be >=1: " + d3);
        }
        this.noRecycleRatio = d;
        this.hardnessCutOff = d2;
        this.recycleLimit = d3;
    }

    @Override
    public IntSet next(ResolutionTrace resolutionTrace) {
        if (this.varsToTry.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        IntSet intSet = StrategyUtils.coreTailUnits(resolutionTrace);
        IntIterator intIterator = this.varsToTry.iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            intIterator.remove();
            if (!intSet.remove(n)) continue;
            if (intSet.isEmpty()) break;
            IntSet intSet2 = this.clausesFor(resolutionTrace, intSet);
            assert (!intSet2.isEmpty() && !intSet2.contains(resolutionTrace.size() - 1));
            System.out.println("relevant clauses: " + intSet2.size() + ", removed " + n);
            return intSet2;
        }
        this.varsToTry.clear();
        return Ints.EMPTY_SET;
    }

    private IntSet clausesFor(ResolutionTrace resolutionTrace, IntSet intSet) {
        IntSet intSet2;
        double d = (double)resolutionTrace.size() / (double)resolutionTrace.axioms().size();
        double d2 = (double)resolutionTrace.core().size() / (double)resolutionTrace.axioms().size();
        System.out.println("\ntrace size: " + resolutionTrace.size() + ", axioms: " + resolutionTrace.axioms().size() + ", core: " + resolutionTrace.core().size() + ", resolvents: " + resolutionTrace.resolvents().size());
        System.out.println("hardness: " + d + ", coreRatio: " + d2);
        IntSet intSet3 = StrategyUtils.clausesFor(resolutionTrace, intSet);
        System.out.println("relevant axioms:  " + intSet3.size());
        if (d2 < this.noRecycleRatio) {
            return intSet3;
        }
        if (d < this.hardnessCutOff) {
            return resolutionTrace.learnable(intSet3);
        }
        IntSet intSet4 = intSet3;
        int n = (int)Math.rint((double)intSet3.size() * this.recycleLimit);
        do {
            intSet2 = intSet4;
            intSet4 = resolutionTrace.directlyLearnable(intSet4);
        } while (intSet2.size() < intSet4.size() && intSet4.size() < n);
        System.out.println("last: " + intSet2.size() + ", current: " + intSet4.size() + ", maxRelevant: " + n);
        return intSet4.size() < n ? intSet4 : intSet2;
    }
}

