/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.satlab;

import java.util.NoSuchElementException;
import kodkod.engine.satlab.SATFactory;
import kodkod.engine.satlab.SATSolver;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;

final class SAT4J
implements SATSolver {
    private ISolver solver;
    private final ReadOnlyIVecInt wrapper;
    private Boolean sat;
    private int vars;
    private int clauses;

    SAT4J(ISolver iSolver) {
        if (iSolver == null) {
            throw new NullPointerException("solver");
        }
        this.solver = iSolver;
        this.wrapper = new ReadOnlyIVecInt();
        this.sat = null;
        this.clauses = 0;
        this.vars = 0;
    }

    @Override
    public int numberOfVariables() {
        return this.vars;
    }

    @Override
    public int numberOfClauses() {
        return this.clauses;
    }

    @Override
    public void addVariables(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("numVars < 0: " + n);
        }
        if (n > 0) {
            this.vars += n;
            this.solver.newVar(this.vars);
        }
    }

    @Override
    public boolean addClause(int[] nArray) {
        try {
            if (!Boolean.FALSE.equals(this.sat)) {
                ++this.clauses;
                this.solver.addClause(this.wrapper.wrap(nArray));
                return true;
            }
        }
        catch (ContradictionException contradictionException) {
            this.sat = Boolean.FALSE;
        }
        return false;
    }

    @Override
    public boolean solve() {
        try {
            if (!Boolean.FALSE.equals(this.sat)) {
                this.sat = this.solver.isSatisfiable();
            }
            return this.sat;
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException("timed out");
        }
    }

    @Override
    public final boolean valueOf(int n) {
        if (!Boolean.TRUE.equals(this.sat)) {
            throw new IllegalStateException();
        }
        if (n < 1 || n > this.vars) {
            throw new IllegalArgumentException(n + " !in [1.." + this.vars + "]");
        }
        return this.solver.model(n);
    }

    @Override
    public final synchronized void free() {
        this.solver = null;
    }

    public static void main(String[] stringArray) {
        SAT4J sAT4J = (SAT4J)SATFactory.DefaultSAT4J.instance();
        sAT4J.addVariables(1);
        int[] nArray = new int[]{1};
        sAT4J.addClause(nArray);
        nArray[0] = -1;
        sAT4J.addClause(nArray);
        System.out.println(sAT4J.solve());
    }

    private static final class ReadOnlyIVecInt
    implements IVecInt {
        private static final long serialVersionUID = -7689441271777278043L;
        private int[] vec;

        private ReadOnlyIVecInt() {
        }

        IVecInt wrap(int[] nArray) {
            this.vec = nArray;
            return this;
        }

        public int size() {
            return this.vec.length;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public int unsafeGet(int n) {
            return this.vec[n];
        }

        public int last() {
            return this.vec[this.vec.length - 1];
        }

        public int[] toArray() {
            return this.vec;
        }

        public int get(int n) {
            if (n < 0 || n >= this.vec.length) {
                throw new IndexOutOfBoundsException("arg0: " + n);
            }
            return this.vec[n];
        }

        public boolean contains(int n) {
            int[] nArray;
            for (int n2 : nArray = this.vec) {
                if (n2 != n) continue;
                return true;
            }
            return false;
        }

        public void copyTo(IVecInt iVecInt) {
            int n = iVecInt.size();
            int[] nArray = this.vec;
            iVecInt.ensure(n + nArray.length);
            for (int n2 : nArray) {
                iVecInt.set(n++, n2);
            }
        }

        public void copyTo(int[] nArray) {
            assert (nArray.length >= this.vec.length);
            System.arraycopy(this.vec, 0, nArray, 0, this.vec.length);
        }

        public IteratorInt iterator() {
            return new IteratorInt(){
                int cursor = 0;

                public boolean hasNext() {
                    return this.cursor < ReadOnlyIVecInt.this.vec.length;
                }

                public int next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return ReadOnlyIVecInt.this.vec[this.cursor++];
                }
            };
        }

        public int containsAt(int n) {
            int[] nArray = this.vec;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] != n) continue;
                return i;
            }
            return -1;
        }

        public int containsAt(int n, int n2) {
            int[] nArray = this.vec;
            if (n2 < nArray.length) {
                int n3 = nArray.length;
                for (int i = n2 + 1; i < n3; ++i) {
                    if (nArray[i] != n) continue;
                    return i;
                }
            }
            return -1;
        }

        public int indexOf(int n) {
            int[] nArray = this.vec;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] != n) continue;
                return i;
            }
            return -1;
        }

        public void shrink(int n) {
            throw new UnsupportedOperationException();
        }

        public void shrinkTo(int n) {
            throw new UnsupportedOperationException();
        }

        public IVecInt pop() {
            throw new UnsupportedOperationException();
        }

        public void growTo(int n, int n2) {
            throw new UnsupportedOperationException();
        }

        public void ensure(int n) {
            throw new UnsupportedOperationException();
        }

        public IVecInt push(int n) {
            throw new UnsupportedOperationException();
        }

        public void unsafePush(int n) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void moveTo(IVecInt iVecInt) {
            throw new UnsupportedOperationException();
        }

        public void moveTo2(IVecInt iVecInt) {
            throw new UnsupportedOperationException();
        }

        public void moveTo(int[] nArray) {
            throw new UnsupportedOperationException();
        }

        public void moveTo(int n, int n2) {
            throw new UnsupportedOperationException();
        }

        public void moveTo(int n, int[] nArray) {
            throw new UnsupportedOperationException();
        }

        public void insertFirst(int n) {
            throw new UnsupportedOperationException();
        }

        public void remove(int n) {
            throw new UnsupportedOperationException();
        }

        public int delete(int n) {
            throw new UnsupportedOperationException();
        }

        public void set(int n, int n2) {
            throw new UnsupportedOperationException();
        }

        public void sort() {
            throw new UnsupportedOperationException();
        }

        public void sortUnique() {
            throw new UnsupportedOperationException();
        }
    }
}

