/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanVariable;
import kodkod.engine.bool.BooleanVisitor;
import kodkod.engine.bool.ITEGate;
import kodkod.engine.bool.MultiGate;
import kodkod.engine.bool.NotGate;
import kodkod.engine.bool.Operator;
import kodkod.engine.satlab.SATFactory;
import kodkod.engine.satlab.SATSolver;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

final class Bool2CNFTranslator
implements BooleanVisitor<int[], Object> {
    private final SATSolver solver;
    private final IntSet visited;
    private final PolarityDetector pdetector;
    private final int[] unaryClause = new int[1];
    private final int[] binaryClause = new int[2];
    private final int[] ternaryClause = new int[3];

    static SATSolver translate(BooleanFormula booleanFormula, SATFactory sATFactory, int n) {
        SATSolver sATSolver = sATFactory.instance();
        Bool2CNFTranslator bool2CNFTranslator = new Bool2CNFTranslator(sATSolver, n, booleanFormula);
        if (booleanFormula.op() == Operator.AND) {
            for (BooleanFormula booleanFormula2 : booleanFormula) {
                booleanFormula2.accept(bool2CNFTranslator, null);
            }
            for (BooleanFormula booleanFormula2 : booleanFormula) {
                bool2CNFTranslator.unaryClause[0] = booleanFormula2.label();
                sATSolver.addClause(bool2CNFTranslator.unaryClause);
            }
        } else {
            sATSolver.addClause(booleanFormula.accept(bool2CNFTranslator, null));
        }
        return sATSolver;
    }

    private Bool2CNFTranslator(SATSolver sATSolver, int n, BooleanFormula booleanFormula) {
        int n2 = StrictMath.abs(booleanFormula.label());
        this.solver = sATSolver;
        this.solver.addVariables(StrictMath.max(n, n2));
        this.pdetector = new PolarityDetector(n, n2).apply(booleanFormula);
        this.visited = Ints.bestSet(this.pdetector.offset, StrictMath.max(this.pdetector.offset, n2));
    }

    final int[] clause(int n) {
        this.unaryClause[0] = n;
        return this.unaryClause;
    }

    final int[] clause(int n, int n2) {
        this.binaryClause[0] = n;
        this.binaryClause[1] = n2;
        return this.binaryClause;
    }

    final int[] clause(int n, int n2, int n3) {
        this.ternaryClause[0] = n;
        this.ternaryClause[1] = n2;
        this.ternaryClause[2] = n3;
        return this.ternaryClause;
    }

    @Override
    public int[] visit(MultiGate multiGate, Object object) {
        int n = multiGate.label();
        if (this.visited.add(n)) {
            boolean bl;
            boolean bl2;
            int n2;
            if (multiGate.op() == Operator.AND) {
                n2 = 1;
                bl2 = this.pdetector.positive(n);
                bl = this.pdetector.negative(n);
            } else {
                n2 = -1;
                bl = this.pdetector.positive(n);
                bl2 = this.pdetector.negative(n);
            }
            int[] nArray = bl ? new int[multiGate.size() + 1] : null;
            int n3 = n * -n2;
            int n4 = 0;
            for (BooleanFormula booleanFormula : multiGate) {
                int n5 = booleanFormula.accept(this, object)[0];
                if (bl2) {
                    this.solver.addClause(this.clause(n5 * n2, n3));
                }
                if (!bl) continue;
                nArray[n4++] = n5 * -n2;
            }
            if (bl) {
                nArray[n4] = n * n2;
                this.solver.addClause(nArray);
            }
        }
        return this.clause(n);
    }

    @Override
    public int[] visit(ITEGate iTEGate, Object object) {
        int n = iTEGate.label();
        if (this.visited.add(n)) {
            int n2 = iTEGate.input(0).accept(this, object)[0];
            int n3 = iTEGate.input(1).accept(this, object)[0];
            int n4 = iTEGate.input(2).accept(this, object)[0];
            boolean bl = this.pdetector.positive(n);
            boolean bl2 = this.pdetector.negative(n);
            if (bl) {
                this.solver.addClause(this.clause(-n2, n3, -n));
                this.solver.addClause(this.clause(n2, n4, -n));
                this.solver.addClause(this.clause(n3, n4, -n));
            }
            if (bl2) {
                this.solver.addClause(this.clause(-n2, -n3, n));
                this.solver.addClause(this.clause(n2, -n4, n));
                this.solver.addClause(this.clause(-n3, -n4, n));
            }
        }
        return this.clause(n);
    }

    @Override
    public int[] visit(NotGate notGate, Object object) {
        return this.clause(-notGate.input(0).accept(this, object)[0]);
    }

    @Override
    public int[] visit(BooleanVariable booleanVariable, Object object) {
        return this.clause(booleanVariable.label());
    }

    private static final class PolarityDetector
    implements BooleanVisitor<Object, Integer> {
        final int offset;
        private final int[] polarity;
        private final Integer[] ints = new Integer[]{3, 1, 2};

        PolarityDetector(int n, int n2) {
            this.offset = n + 1;
            this.polarity = new int[StrictMath.max(0, n2 - n)];
        }

        PolarityDetector apply(BooleanFormula booleanFormula) {
            booleanFormula.accept(this, this.ints[1]);
            return this;
        }

        boolean positive(int n) {
            return (this.polarity[n - this.offset] & 1) > 0;
        }

        boolean negative(int n) {
            return (this.polarity[n - this.offset] & 2) > 0;
        }

        private boolean visited(BooleanFormula booleanFormula, Integer n) {
            int n2;
            int n3 = this.polarity[n2];
            this.polarity[n2 = booleanFormula.label() - this.offset] = n3 | n;
            return this.polarity[n2 = booleanFormula.label() - this.offset] == n3;
        }

        @Override
        public Object visit(MultiGate multiGate, Integer n) {
            if (!this.visited(multiGate, n)) {
                for (BooleanFormula booleanFormula : multiGate) {
                    booleanFormula.accept(this, n);
                }
            }
            return null;
        }

        @Override
        public Object visit(ITEGate iTEGate, Integer n) {
            if (!this.visited(iTEGate, n)) {
                iTEGate.input(0).accept(this, this.ints[0]);
                iTEGate.input(1).accept(this, n);
                iTEGate.input(2).accept(this, n);
            }
            return null;
        }

        @Override
        public Object visit(NotGate notGate, Integer n) {
            return notGate.input(0).accept(this, this.ints[3 - n]);
        }

        @Override
        public Object visit(BooleanVariable booleanVariable, Integer n) {
            return null;
        }
    }
}

