/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanFormula;

public abstract class Operator
implements Comparable<Operator> {
    final int ordinal;
    public static final Nary AND = new Nary(0){

        public String toString() {
            return "&";
        }

        @Override
        public BooleanConstant identity() {
            return BooleanConstant.TRUE;
        }

        @Override
        public BooleanConstant shortCircuit() {
            return BooleanConstant.FALSE;
        }

        @Override
        public Nary complement() {
            return OR;
        }
    };
    public static final Nary OR = new Nary(1){

        public String toString() {
            return "|";
        }

        @Override
        public BooleanConstant identity() {
            return BooleanConstant.FALSE;
        }

        @Override
        public BooleanConstant shortCircuit() {
            return BooleanConstant.TRUE;
        }

        @Override
        public Nary complement() {
            return AND;
        }
    };
    public static final Ternary ITE = new Ternary(2){

        public String toString() {
            return "?";
        }
    };
    public static final Operator NOT = new Operator(3){

        public String toString() {
            return "!";
        }
    };
    public static final Operator VAR = new Operator(4){

        public String toString() {
            return "var";
        }
    };
    public static final Operator CONST = new Operator(5){

        public String toString() {
            return "const";
        }
    };

    private Operator(int n) {
        this.ordinal = n;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(Operator operator) {
        return this.ordinal() - operator.ordinal();
    }

    static abstract class Ternary
    extends Operator {
        private Ternary(int n) {
            super(n);
        }

        int hash(BooleanFormula booleanFormula, BooleanFormula booleanFormula2, BooleanFormula booleanFormula3) {
            return 3 * booleanFormula.hash(this) + 5 * booleanFormula2.hash(this) + 7 * booleanFormula3.hash(this);
        }
    }

    public static abstract class Nary
    extends Operator {
        private Nary(int n) {
            super(n);
        }

        int hash(BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            return booleanFormula.hash(this) + booleanFormula2.hash(this);
        }

        int hash(Iterator<BooleanFormula> iterator) {
            int n = 0;
            while (iterator.hasNext()) {
                n += iterator.next().hash(this);
            }
            return n;
        }

        public abstract BooleanConstant identity();

        public abstract BooleanConstant shortCircuit();

        public abstract Nary complement();
    }
}

