/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanVisitor;
import kodkod.engine.bool.Operator;
import kodkod.util.ints.Ints;

public final class NotGate
extends BooleanFormula {
    private final int hashcode;

    NotGate(BooleanFormula booleanFormula) {
        super(booleanFormula);
        this.hashcode = Ints.superFastHash(-booleanFormula.label());
    }

    @Override
    int hash(Operator operator) {
        return this.hashcode;
    }

    @Override
    public Iterator<BooleanFormula> iterator() {
        return new Iterator<BooleanFormula>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public BooleanFormula next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return NotGate.this.negation();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final int label() {
        return -this.negation().label();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public <T, A> T accept(BooleanVisitor<T, A> booleanVisitor, A a) {
        return booleanVisitor.visit(this, a);
    }

    public String toString() {
        return "!" + this.negation().toString();
    }

    @Override
    public Operator op() {
        return Operator.NOT;
    }

    @Override
    public BooleanFormula input(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.negation();
    }

    public int hashCode() {
        return this.hashcode;
    }
}

