/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import kodkod.ast.Formula;
import kodkod.ast.Relation;
import kodkod.engine.AbortedException;
import kodkod.engine.Cost;
import kodkod.engine.Proof;
import kodkod.engine.ResolutionBasedProof;
import kodkod.engine.Solution;
import kodkod.engine.Statistics;
import kodkod.engine.TrivialProof;
import kodkod.engine.config.Options;
import kodkod.engine.fol2sat.HigherOrderDeclException;
import kodkod.engine.fol2sat.Translation;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.fol2sat.Translator;
import kodkod.engine.fol2sat.TrivialFormulaException;
import kodkod.engine.fol2sat.UnboundLeafException;
import kodkod.engine.satlab.SATAbortedException;
import kodkod.engine.satlab.SATMinSolver;
import kodkod.engine.satlab.SATProver;
import kodkod.engine.satlab.SATSolver;
import kodkod.instance.Bounds;
import kodkod.instance.Instance;
import kodkod.instance.TupleSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;

public final class Solver {
    private final Options options;

    public Solver() {
        this.options = new Options();
    }

    public Solver(Options options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    public Options options() {
        return this.options;
    }

    public Solution solve(Formula formula, Bounds bounds, Cost cost) throws HigherOrderDeclException, UnboundLeafException, AbortedException {
        if (this.options.logTranslation() > 0 || !this.options.solver().minimizer()) {
            throw new IllegalStateException();
        }
        long l = System.currentTimeMillis();
        try {
            Translation translation = Translator.translate(formula, bounds, this.options);
            long l2 = System.currentTimeMillis();
            SATMinSolver sATMinSolver = (SATMinSolver)translation.cnf();
            for (Relation relation : bounds.relations()) {
                IntSet intSet = translation.primaryVariables(relation);
                if (intSet == null) continue;
                int n = cost.edgeCost(relation);
                IntIterator intIterator = intSet.iterator();
                while (intIterator.hasNext()) {
                    sATMinSolver.setCost(intIterator.next(), n);
                }
            }
            this.options.reporter().solvingCNF(0, sATMinSolver.numberOfVariables(), sATMinSolver.numberOfClauses());
            long l3 = System.currentTimeMillis();
            boolean bl = sATMinSolver.solve();
            long l4 = System.currentTimeMillis();
            Statistics statistics = new Statistics(translation, l2 - l, l4 - l3);
            return bl ? Solver.sat(bounds, translation, statistics) : Solver.unsat(translation, statistics);
        }
        catch (TrivialFormulaException trivialFormulaException) {
            long l5 = System.currentTimeMillis();
            return Solver.trivial(bounds, trivialFormulaException, l5 - l);
        }
        catch (SATAbortedException sATAbortedException) {
            throw new AbortedException(sATAbortedException);
        }
    }

    public Solution solve(Formula formula, Bounds bounds) throws HigherOrderDeclException, UnboundLeafException, AbortedException {
        long l = System.currentTimeMillis();
        try {
            Translation translation = Translator.translate(formula, bounds, this.options);
            long l2 = System.currentTimeMillis();
            SATSolver sATSolver = translation.cnf();
            this.options.reporter().solvingCNF(translation.numPrimaryVariables(), sATSolver.numberOfVariables(), sATSolver.numberOfClauses());
            long l3 = System.currentTimeMillis();
            boolean bl = sATSolver.solve();
            long l4 = System.currentTimeMillis();
            Statistics statistics = new Statistics(translation, l2 - l, l4 - l3);
            return bl ? Solver.sat(bounds, translation, statistics) : Solver.unsat(translation, statistics);
        }
        catch (TrivialFormulaException trivialFormulaException) {
            long l5 = System.currentTimeMillis();
            return Solver.trivial(bounds, trivialFormulaException, l5 - l);
        }
        catch (SATAbortedException sATAbortedException) {
            throw new AbortedException(sATAbortedException);
        }
    }

    public Iterator<Solution> solveAll(Formula formula, Bounds bounds) throws HigherOrderDeclException, UnboundLeafException, AbortedException {
        if (!this.options.solver().incremental()) {
            throw new IllegalArgumentException("cannot enumerate solutions without an incremental solver.");
        }
        return new SolutionIterator(formula, bounds, this.options);
    }

    public String toString() {
        return this.options.toString();
    }

    private static Solution sat(Bounds bounds, Translation translation, Statistics statistics) {
        Solution solution = Solution.satisfiable(statistics, Solver.padInstance(translation.interpret(), bounds));
        translation.cnf().free();
        return solution;
    }

    private static Solution unsat(Translation translation, Statistics statistics) {
        SATSolver sATSolver = translation.cnf();
        TranslationLog translationLog = translation.log();
        if (sATSolver instanceof SATProver && translationLog != null) {
            return Solution.unsatisfiable(statistics, new ResolutionBasedProof((SATProver)sATSolver, translationLog));
        }
        Solution solution = Solution.unsatisfiable(statistics, null);
        sATSolver.free();
        return solution;
    }

    private static int trivialPrimaries(Bounds bounds) {
        int n = 0;
        for (Relation relation : bounds.relations()) {
            n += bounds.upperBound(relation).size() - bounds.lowerBound(relation).size();
        }
        return n;
    }

    private static Solution trivial(Bounds bounds, TrivialFormulaException trivialFormulaException, long l) {
        Statistics statistics = new Statistics(Solver.trivialPrimaries(trivialFormulaException.bounds()), 0, 0, l, 0L);
        if (trivialFormulaException.value().booleanValue()) {
            return Solution.triviallySatisfiable(statistics, Solver.padInstance(Solver.toInstance(trivialFormulaException.bounds()), bounds));
        }
        return Solution.triviallyUnsatisfiable(statistics, Solver.trivialProof(trivialFormulaException.log()));
    }

    private static Proof trivialProof(TranslationLog translationLog) {
        return translationLog == null ? null : new TrivialProof(translationLog);
    }

    private static Instance padInstance(Instance instance, Bounds bounds) {
        for (Relation relation : bounds.relations()) {
            if (instance.contains(relation)) continue;
            instance.add(relation, bounds.lowerBound(relation));
        }
        IntIterator intIterator = bounds.ints().iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            instance.add(n, bounds.exactBound(n));
        }
        return instance;
    }

    private static Instance toInstance(Bounds bounds) {
        Instance instance = new Instance(bounds.universe());
        for (Relation relation : bounds.relations()) {
            instance.add(relation, bounds.lowerBound(relation));
        }
        IntIterator intIterator = bounds.ints().iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            instance.add(n, bounds.exactBound(n));
        }
        return instance;
    }

    private static final class SolutionIterator
    implements Iterator<Solution> {
        private final Options options;
        private Formula formula;
        private Bounds bounds;
        private Translation translation;
        private long translTime;
        private int trivial;

        SolutionIterator(Formula formula, Bounds bounds, Options options) {
            this.formula = formula;
            this.bounds = bounds;
            this.options = options;
            this.translation = null;
            this.trivial = 0;
        }

        @Override
        public boolean hasNext() {
            return this.formula != null;
        }

        private Solution nonTrivialSolution() {
            try {
                SATSolver sATSolver = this.translation.cnf();
                this.options.reporter().solvingCNF(this.translation.numPrimaryVariables(), sATSolver.numberOfVariables(), sATSolver.numberOfClauses());
                long l = System.currentTimeMillis();
                boolean bl = sATSolver.solve();
                long l2 = System.currentTimeMillis();
                Statistics statistics = new Statistics(this.translation, this.translTime, l2 - l);
                if (bl) {
                    Solution solution = Solution.satisfiable(statistics, Solver.padInstance(this.translation.interpret(), this.bounds));
                    int n = this.translation.numPrimaryVariables();
                    int[] nArray = new int[n];
                    for (int i = 1; i <= n; ++i) {
                        nArray[i - 1] = sATSolver.valueOf(i) ? -i : i;
                    }
                    sATSolver.addClause(nArray);
                    return solution;
                }
                this.formula = null;
                this.bounds = null;
                return Solver.unsat(this.translation, statistics);
            }
            catch (SATAbortedException sATAbortedException) {
                throw new AbortedException(sATAbortedException);
            }
        }

        private Solution trivialSolution(TrivialFormulaException trivialFormulaException) {
            Statistics statistics = new Statistics(0, 0, 0, this.translTime, 0L);
            if (trivialFormulaException.value().booleanValue()) {
                ++this.trivial;
                Bounds bounds = trivialFormulaException.bounds();
                Instance instance = Solver.padInstance(Solver.toInstance(bounds), this.bounds);
                Solution solution = Solution.triviallySatisfiable(statistics, instance);
                LinkedList<Formula> linkedList = new LinkedList<Formula>();
                for (Map.Entry<Relation, TupleSet> entry : instance.relationTuples().entrySet()) {
                    Relation relation = entry.getKey();
                    if (!bounds.relations().contains(relation)) {
                        bounds.bound(relation, this.bounds.lowerBound(relation), this.bounds.upperBound(relation));
                    }
                    if (bounds.lowerBound(relation) == bounds.upperBound(relation)) continue;
                    if (entry.getValue().isEmpty()) {
                        linkedList.add(relation.some());
                        continue;
                    }
                    Relation relation2 = Relation.nary(relation.name() + "_" + this.trivial, relation.arity());
                    bounds.boundExactly(relation2, entry.getValue());
                    linkedList.add(relation.eq(relation2).not());
                }
                this.bounds = bounds;
                this.formula = linkedList.isEmpty() ? Formula.FALSE : trivialFormulaException.formula().and(Formula.or(linkedList));
                return solution;
            }
            this.formula = null;
            this.bounds = null;
            return Solution.triviallyUnsatisfiable(statistics, Solver.trivialProof(trivialFormulaException.log()));
        }

        @Override
        public Solution next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.translation == null) {
                try {
                    this.translTime = System.currentTimeMillis();
                    this.translation = Translator.translate(this.formula, this.bounds, this.options);
                    this.translTime = System.currentTimeMillis() - this.translTime;
                    return this.nonTrivialSolution();
                }
                catch (TrivialFormulaException trivialFormulaException) {
                    this.translTime = System.currentTimeMillis() - this.translTime;
                    return this.trivialSolution(trivialFormulaException);
                }
            }
            return this.nonTrivialSolution();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

