/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast.visitor;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.BinaryExpression;
import kodkod.ast.BinaryFormula;
import kodkod.ast.BinaryIntExpression;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.Comprehension;
import kodkod.ast.ConstantExpression;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.ExprToIntCast;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IfExpression;
import kodkod.ast.IfIntExpression;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.IntConstant;
import kodkod.ast.IntExpression;
import kodkod.ast.IntToExprCast;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryExpression;
import kodkod.ast.NaryFormula;
import kodkod.ast.NaryIntExpression;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.ProjectExpression;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.ast.SumExpression;
import kodkod.ast.UnaryExpression;
import kodkod.ast.UnaryIntExpression;
import kodkod.ast.Variable;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.visitor.ReturnVisitor;

public abstract class AbstractReplacer
implements ReturnVisitor<Expression, Formula, Decls, IntExpression> {
    protected final Map<Node, Node> cache;
    protected final Set<Node> cached;

    protected AbstractReplacer(Set<Node> set) {
        this.cached = set;
        this.cache = new IdentityHashMap<Node, Node>(set.size());
    }

    protected AbstractReplacer(Set<Node> set, Map<Node, Node> map) {
        this.cached = set;
        this.cache = map;
    }

    protected <N extends Node> N lookup(N n) {
        return (N)this.cache.get(n);
    }

    protected <N extends Node> N cache(N n, N n2) {
        if (this.cached.contains(n)) {
            this.cache.put(n, n2);
        }
        return n2;
    }

    @Override
    public Decls visit(Decls decls) {
        Decls decls2 = this.lookup(decls);
        if (decls2 != null) {
            return decls2;
        }
        Decl decl = null;
        boolean bl = true;
        for (Decl decl2 : decls) {
            Decl decl3 = this.visit(decl2);
            if (decl3 != decl2) {
                bl = false;
            }
            decl = decl == null ? decl3 : decl.and(decl3);
        }
        decls2 = bl ? decls : decl;
        return this.cache(decls, decls2);
    }

    @Override
    public Decl visit(Decl decl) {
        Decl decl2 = this.lookup(decl);
        if (decl2 != null) {
            return decl2;
        }
        Variable variable = (Variable)decl.variable().accept(this);
        Expression expression = decl.expression().accept(this);
        decl2 = variable == decl.variable() && expression == decl.expression() ? decl : variable.declare(decl.multiplicity(), expression);
        return this.cache(decl, decl2);
    }

    @Override
    public Expression visit(Relation relation) {
        Expression expression = this.lookup(relation);
        return expression == null ? (Expression)this.cache(relation, relation) : expression;
    }

    @Override
    public Expression visit(Variable variable) {
        Expression expression = this.lookup(variable);
        return expression == null ? this.cache(variable, variable) : variable;
    }

    @Override
    public Expression visit(ConstantExpression constantExpression) {
        Expression expression = this.lookup(constantExpression);
        return expression == null ? this.cache(constantExpression, constantExpression) : constantExpression;
    }

    @Override
    public Expression visit(NaryExpression naryExpression) {
        Expression expression = this.lookup(naryExpression);
        if (expression != null) {
            return expression;
        }
        Expression[] expressionArray = new Expression[naryExpression.size()];
        boolean bl = true;
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression2 = naryExpression.child(i);
            expressionArray[i] = expression2.accept(this);
            bl = bl && expressionArray[i] == expression2;
        }
        expression = bl ? naryExpression : Expression.compose(naryExpression.op(), expressionArray);
        return this.cache(naryExpression, expression);
    }

    @Override
    public Expression visit(BinaryExpression binaryExpression) {
        Expression expression = this.lookup(binaryExpression);
        if (expression != null) {
            return expression;
        }
        Expression expression2 = binaryExpression.left().accept(this);
        Expression expression3 = binaryExpression.right().accept(this);
        expression = expression2 == binaryExpression.left() && expression3 == binaryExpression.right() ? binaryExpression : expression2.compose(binaryExpression.op(), expression3);
        return this.cache(binaryExpression, expression);
    }

    @Override
    public Expression visit(UnaryExpression unaryExpression) {
        Expression expression = this.lookup(unaryExpression);
        if (expression != null) {
            return expression;
        }
        Expression expression2 = unaryExpression.expression().accept(this);
        expression = expression2 == unaryExpression.expression() ? unaryExpression : expression2.apply(unaryExpression.op());
        return this.cache(unaryExpression, expression);
    }

    @Override
    public Expression visit(Comprehension comprehension) {
        Expression expression = this.lookup(comprehension);
        if (expression != null) {
            return expression;
        }
        Decls decls = comprehension.decls().accept(this);
        Formula formula = comprehension.formula().accept(this);
        expression = decls == comprehension.decls() && formula == comprehension.formula() ? comprehension : formula.comprehension(decls);
        return this.cache(comprehension, expression);
    }

    @Override
    public Expression visit(IfExpression ifExpression) {
        Expression expression = this.lookup(ifExpression);
        if (expression != null) {
            return expression;
        }
        Formula formula = ifExpression.condition().accept(this);
        Expression expression2 = ifExpression.thenExpr().accept(this);
        Expression expression3 = ifExpression.elseExpr().accept(this);
        expression = formula == ifExpression.condition() && expression2 == ifExpression.thenExpr() && expression3 == ifExpression.elseExpr() ? ifExpression : formula.thenElse(expression2, expression3);
        return this.cache(ifExpression, expression);
    }

    @Override
    public Expression visit(ProjectExpression projectExpression) {
        Expression expression = this.lookup(projectExpression);
        if (expression != null) {
            return expression;
        }
        Expression expression2 = projectExpression.expression().accept(this);
        IntExpression[] intExpressionArray = new IntExpression[projectExpression.arity()];
        boolean bl = expression2 == projectExpression.expression();
        int n = projectExpression.arity();
        for (int i = 0; i < n; ++i) {
            intExpressionArray[i] = projectExpression.column(i).accept(this);
            bl = bl && intExpressionArray[i] == projectExpression.column(i);
        }
        expression = bl ? projectExpression : expression2.project(intExpressionArray);
        return this.cache(projectExpression, expression);
    }

    @Override
    public Expression visit(IntToExprCast intToExprCast) {
        Expression expression = this.lookup(intToExprCast);
        if (expression != null) {
            return expression;
        }
        IntExpression intExpression = intToExprCast.intExpr().accept(this);
        expression = intExpression == intToExprCast.intExpr() ? intToExprCast : intExpression.cast(intToExprCast.op());
        return this.cache(intToExprCast, expression);
    }

    @Override
    public IntExpression visit(IntConstant intConstant) {
        IntExpression intExpression = this.lookup(intConstant);
        return intExpression == null ? this.cache(intConstant, intConstant) : intConstant;
    }

    @Override
    public IntExpression visit(IfIntExpression ifIntExpression) {
        IntExpression intExpression = this.lookup(ifIntExpression);
        if (intExpression != null) {
            return intExpression;
        }
        Formula formula = ifIntExpression.condition().accept(this);
        IntExpression intExpression2 = ifIntExpression.thenExpr().accept(this);
        IntExpression intExpression3 = ifIntExpression.elseExpr().accept(this);
        intExpression = formula == ifIntExpression.condition() && intExpression2 == ifIntExpression.thenExpr() && intExpression3 == ifIntExpression.elseExpr() ? ifIntExpression : formula.thenElse(intExpression2, intExpression3);
        return this.cache(ifIntExpression, intExpression);
    }

    @Override
    public IntExpression visit(ExprToIntCast exprToIntCast) {
        IntExpression intExpression = this.lookup(exprToIntCast);
        if (intExpression != null) {
            return intExpression;
        }
        Expression expression = exprToIntCast.expression().accept(this);
        intExpression = expression == exprToIntCast.expression() ? exprToIntCast : expression.apply(exprToIntCast.op());
        return this.cache(exprToIntCast, intExpression);
    }

    @Override
    public IntExpression visit(NaryIntExpression naryIntExpression) {
        IntExpression intExpression = this.lookup(naryIntExpression);
        if (intExpression != null) {
            return intExpression;
        }
        IntExpression[] intExpressionArray = new IntExpression[naryIntExpression.size()];
        boolean bl = true;
        for (int i = 0; i < intExpressionArray.length; ++i) {
            IntExpression intExpression2 = naryIntExpression.child(i);
            intExpressionArray[i] = intExpression2.accept(this);
            bl = bl && intExpressionArray[i] == intExpression2;
        }
        intExpression = bl ? naryIntExpression : IntExpression.compose(naryIntExpression.op(), intExpressionArray);
        return this.cache(naryIntExpression, intExpression);
    }

    @Override
    public IntExpression visit(BinaryIntExpression binaryIntExpression) {
        IntExpression intExpression = this.lookup(binaryIntExpression);
        if (intExpression != null) {
            return intExpression;
        }
        IntExpression intExpression2 = binaryIntExpression.left().accept(this);
        IntExpression intExpression3 = binaryIntExpression.right().accept(this);
        intExpression = intExpression2 == binaryIntExpression.left() && intExpression3 == binaryIntExpression.right() ? binaryIntExpression : intExpression2.compose(binaryIntExpression.op(), intExpression3);
        return this.cache(binaryIntExpression, intExpression);
    }

    @Override
    public IntExpression visit(UnaryIntExpression unaryIntExpression) {
        IntExpression intExpression = this.lookup(unaryIntExpression);
        if (intExpression != null) {
            return intExpression;
        }
        IntExpression intExpression2 = unaryIntExpression.intExpr().accept(this);
        intExpression = intExpression2 == unaryIntExpression.intExpr() ? unaryIntExpression : intExpression2.apply(unaryIntExpression.op());
        return this.cache(unaryIntExpression, intExpression);
    }

    @Override
    public IntExpression visit(SumExpression sumExpression) {
        IntExpression intExpression = this.lookup(sumExpression);
        if (intExpression != null) {
            return intExpression;
        }
        Decls decls = sumExpression.decls().accept(this);
        IntExpression intExpression2 = sumExpression.intExpr().accept(this);
        intExpression = decls == sumExpression.decls() && intExpression2 == sumExpression.intExpr() ? sumExpression : intExpression2.sum(decls);
        return this.cache(sumExpression, intExpression);
    }

    @Override
    public Formula visit(IntComparisonFormula intComparisonFormula) {
        Formula formula = this.lookup(intComparisonFormula);
        if (formula != null) {
            return formula;
        }
        IntExpression intExpression = intComparisonFormula.left().accept(this);
        IntExpression intExpression2 = intComparisonFormula.right().accept(this);
        formula = intExpression == intComparisonFormula.left() && intExpression2 == intComparisonFormula.right() ? intComparisonFormula : intExpression.compare(intComparisonFormula.op(), intExpression2);
        return this.cache(intComparisonFormula, formula);
    }

    @Override
    public Formula visit(ConstantFormula constantFormula) {
        Formula formula = this.lookup(constantFormula);
        return formula == null ? this.cache(constantFormula, constantFormula) : constantFormula;
    }

    @Override
    public Formula visit(QuantifiedFormula quantifiedFormula) {
        Formula formula = this.lookup(quantifiedFormula);
        if (formula != null) {
            return formula;
        }
        Decls decls = quantifiedFormula.decls().accept(this);
        Formula formula2 = quantifiedFormula.formula().accept(this);
        formula = decls == quantifiedFormula.decls() && formula2 == quantifiedFormula.formula() ? quantifiedFormula : formula2.quantify(quantifiedFormula.quantifier(), decls);
        return this.cache(quantifiedFormula, formula);
    }

    @Override
    public Formula visit(NaryFormula naryFormula) {
        Formula formula = this.lookup(naryFormula);
        if (formula != null) {
            return formula;
        }
        Formula[] formulaArray = new Formula[naryFormula.size()];
        boolean bl = true;
        for (int i = 0; i < formulaArray.length; ++i) {
            Formula formula2 = naryFormula.child(i);
            formulaArray[i] = formula2.accept(this);
            bl = bl && formulaArray[i] == formula2;
        }
        formula = bl ? naryFormula : Formula.compose(naryFormula.op(), formulaArray);
        return this.cache(naryFormula, formula);
    }

    @Override
    public Formula visit(BinaryFormula binaryFormula) {
        Formula formula = this.lookup(binaryFormula);
        if (formula != null) {
            return formula;
        }
        Formula formula2 = binaryFormula.left().accept(this);
        Formula formula3 = binaryFormula.right().accept(this);
        formula = formula2 == binaryFormula.left() && formula3 == binaryFormula.right() ? binaryFormula : formula2.compose(binaryFormula.op(), formula3);
        return this.cache(binaryFormula, formula);
    }

    @Override
    public Formula visit(NotFormula notFormula) {
        Formula formula = this.lookup(notFormula);
        if (formula != null) {
            return formula;
        }
        Formula formula2 = notFormula.formula().accept(this);
        formula = formula2 == notFormula.formula() ? notFormula : formula2.not();
        return this.cache(notFormula, formula);
    }

    @Override
    public Formula visit(ComparisonFormula comparisonFormula) {
        Formula formula = this.lookup(comparisonFormula);
        if (formula != null) {
            return formula;
        }
        Expression expression = comparisonFormula.left().accept(this);
        Expression expression2 = comparisonFormula.right().accept(this);
        formula = expression == comparisonFormula.left() && expression2 == comparisonFormula.right() ? comparisonFormula : expression.compare(comparisonFormula.op(), expression2);
        return this.cache(comparisonFormula, formula);
    }

    @Override
    public Formula visit(MultiplicityFormula multiplicityFormula) {
        Formula formula = this.lookup(multiplicityFormula);
        if (formula != null) {
            return formula;
        }
        Expression expression = multiplicityFormula.expression().accept(this);
        formula = expression == multiplicityFormula.expression() ? multiplicityFormula : expression.apply(multiplicityFormula.multiplicity());
        return this.cache(multiplicityFormula, formula);
    }

    @Override
    public Formula visit(RelationPredicate relationPredicate) {
        Formula formula = this.lookup(relationPredicate);
        if (formula != null) {
            return formula;
        }
        Relation relation = (Relation)relationPredicate.relation().accept(this);
        switch (relationPredicate.name()) {
            case ACYCLIC: {
                formula = relation == relationPredicate.relation() ? relationPredicate : relation.acyclic();
                break;
            }
            case FUNCTION: {
                RelationPredicate.Function function = (RelationPredicate.Function)relationPredicate;
                Expression expression = function.domain().accept(this);
                Expression expression2 = function.range().accept(this);
                formula = relation == function.relation() && expression == function.domain() && expression2 == function.range() ? function : (function.targetMult() == Multiplicity.ONE ? relation.function(expression, expression2) : relation.partialFunction(expression, expression2));
                break;
            }
            case TOTAL_ORDERING: {
                RelationPredicate.TotalOrdering totalOrdering = (RelationPredicate.TotalOrdering)relationPredicate;
                Relation relation2 = (Relation)totalOrdering.ordered().accept(this);
                Relation relation3 = (Relation)totalOrdering.first().accept(this);
                Relation relation4 = (Relation)totalOrdering.last().accept(this);
                formula = relation == totalOrdering.relation() && relation2 == totalOrdering.ordered() && relation3 == totalOrdering.first() && relation4 == totalOrdering.last() ? totalOrdering : relation.totalOrder(relation2, relation3, relation4);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown relation predicate: " + (Object)((Object)relationPredicate.name()));
            }
        }
        return this.cache(relationPredicate, formula);
    }
}

