/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.IntExpression;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class SumExpression
extends IntExpression {
    private final Decls decls;
    private final IntExpression intExpr;

    SumExpression(Decls decls, IntExpression intExpression) {
        for (Decl decl : decls) {
            if (decl.multiplicity() == Multiplicity.ONE) continue;
            throw new IllegalArgumentException(decl + " is not a scalar declaration.");
        }
        this.decls = decls;
        this.intExpr = intExpression;
    }

    public final Decls decls() {
        return this.decls;
    }

    public final IntExpression intExpr() {
        return this.intExpr;
    }

    @Override
    public <E, F, D, I> I accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "(sum " + this.decls + " | " + this.intExpr + ")";
    }
}

