/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kodkod.ast.BinaryIntExpression;
import kodkod.ast.Decls;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.IntToExprCast;
import kodkod.ast.NaryIntExpression;
import kodkod.ast.Node;
import kodkod.ast.SumExpression;
import kodkod.ast.UnaryIntExpression;
import kodkod.ast.operator.IntCastOperator;
import kodkod.ast.operator.IntCompOperator;
import kodkod.ast.operator.IntOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;
import kodkod.util.collections.Containers;

public abstract class IntExpression
extends Node {
    IntExpression() {
    }

    public final Formula eq(IntExpression intExpression) {
        return this.compare(IntCompOperator.EQ, intExpression);
    }

    public final Formula lt(IntExpression intExpression) {
        return this.compare(IntCompOperator.LT, intExpression);
    }

    public final Formula lte(IntExpression intExpression) {
        return this.compare(IntCompOperator.LTE, intExpression);
    }

    public final Formula gt(IntExpression intExpression) {
        return this.compare(IntCompOperator.GT, intExpression);
    }

    public final Formula gte(IntExpression intExpression) {
        return this.compare(IntCompOperator.GTE, intExpression);
    }

    public Formula compare(IntCompOperator intCompOperator, IntExpression intExpression) {
        if (intCompOperator == null || intExpression == null) {
            throw new NullPointerException();
        }
        return new IntComparisonFormula(this, intCompOperator, intExpression);
    }

    public final IntExpression sum(Decls decls) {
        return new SumExpression(decls, this);
    }

    public final IntExpression plus(IntExpression intExpression) {
        return this.compose(IntOperator.PLUS, intExpression);
    }

    public final IntExpression minus(IntExpression intExpression) {
        return this.compose(IntOperator.MINUS, intExpression);
    }

    public final IntExpression multiply(IntExpression intExpression) {
        return this.compose(IntOperator.MULTIPLY, intExpression);
    }

    public final IntExpression divide(IntExpression intExpression) {
        return this.compose(IntOperator.DIVIDE, intExpression);
    }

    public final IntExpression modulo(IntExpression intExpression) {
        return this.compose(IntOperator.MODULO, intExpression);
    }

    public final IntExpression and(IntExpression intExpression) {
        return this.compose(IntOperator.AND, intExpression);
    }

    public final IntExpression or(IntExpression intExpression) {
        return this.compose(IntOperator.OR, intExpression);
    }

    public final IntExpression xor(IntExpression intExpression) {
        return this.compose(IntOperator.XOR, intExpression);
    }

    public final IntExpression shl(IntExpression intExpression) {
        return this.compose(IntOperator.SHL, intExpression);
    }

    public final IntExpression shr(IntExpression intExpression) {
        return this.compose(IntOperator.SHR, intExpression);
    }

    public final IntExpression sha(IntExpression intExpression) {
        return this.compose(IntOperator.SHA, intExpression);
    }

    public final IntExpression compose(IntOperator intOperator, IntExpression intExpression) {
        if (intOperator == null || intExpression == null) {
            throw new NullPointerException();
        }
        return new BinaryIntExpression(this, intOperator, intExpression);
    }

    public static IntExpression plus(IntExpression ... intExpressionArray) {
        return IntExpression.compose(IntOperator.PLUS, intExpressionArray);
    }

    public static IntExpression plus(Collection<? extends IntExpression> collection) {
        return IntExpression.compose(IntOperator.PLUS, collection);
    }

    public static IntExpression multiply(IntExpression ... intExpressionArray) {
        return IntExpression.compose(IntOperator.MULTIPLY, intExpressionArray);
    }

    public static IntExpression multiply(Collection<? extends IntExpression> collection) {
        return IntExpression.compose(IntOperator.MULTIPLY, collection);
    }

    public static IntExpression and(IntExpression ... intExpressionArray) {
        return IntExpression.compose(IntOperator.AND, intExpressionArray);
    }

    public static IntExpression and(Collection<? extends IntExpression> collection) {
        return IntExpression.compose(IntOperator.AND, collection);
    }

    public static IntExpression or(IntExpression ... intExpressionArray) {
        return IntExpression.compose(IntOperator.OR, intExpressionArray);
    }

    public static IntExpression or(Collection<? extends IntExpression> collection) {
        return IntExpression.compose(IntOperator.OR, collection);
    }

    public static IntExpression compose(IntOperator intOperator, IntExpression ... intExpressionArray) {
        switch (intExpressionArray.length) {
            case 0: {
                throw new IllegalArgumentException("Expected at least one argument: " + Arrays.toString(intExpressionArray));
            }
            case 1: {
                return intExpressionArray[0];
            }
            case 2: {
                return new BinaryIntExpression(intExpressionArray[0], intOperator, intExpressionArray[1]);
            }
        }
        return new NaryIntExpression(intOperator, Containers.copy(intExpressionArray, new IntExpression[intExpressionArray.length]));
    }

    public static IntExpression compose(IntOperator intOperator, Collection<? extends IntExpression> collection) {
        switch (collection.size()) {
            case 0: {
                throw new IllegalArgumentException("Expected at least one argument: " + collection);
            }
            case 1: {
                return collection.iterator().next();
            }
            case 2: {
                Iterator<? extends IntExpression> iterator = collection.iterator();
                return new BinaryIntExpression(iterator.next(), intOperator, iterator.next());
            }
        }
        return new NaryIntExpression(intOperator, collection.toArray(new IntExpression[collection.size()]));
    }

    public final IntExpression negate() {
        return this.apply(IntOperator.NEG);
    }

    public final IntExpression not() {
        return this.apply(IntOperator.NOT);
    }

    public final IntExpression abs() {
        return this.apply(IntOperator.ABS);
    }

    public final IntExpression signum() {
        return this.apply(IntOperator.SGN);
    }

    public final IntExpression apply(IntOperator intOperator) {
        return new UnaryIntExpression(intOperator, this);
    }

    public final Expression toExpression() {
        return this.cast(IntCastOperator.INTCAST);
    }

    public final Expression toBitset() {
        return this.cast(IntCastOperator.BITSETCAST);
    }

    public final Expression cast(IntCastOperator intCastOperator) {
        if (intCastOperator == null) {
            throw new NullPointerException();
        }
        return new IntToExprCast(this, intCastOperator);
    }

    public abstract <E, F, D, I> I accept(ReturnVisitor<E, F, D, I> var1);

    @Override
    public abstract void accept(VoidVisitor var1);
}

