/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Expression;
import kodkod.ast.IntExpression;
import kodkod.ast.operator.ExprCastOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class ExprToIntCast
extends IntExpression {
    private final Expression expression;
    private final ExprCastOperator op;

    ExprToIntCast(Expression expression, ExprCastOperator exprCastOperator) {
        if (expression.arity() > 1 && exprCastOperator == ExprCastOperator.SUM) {
            throw new IllegalArgumentException("cannot apply " + (Object)((Object)exprCastOperator) + " to " + expression);
        }
        this.expression = expression;
        this.op = exprCastOperator;
    }

    public Expression expression() {
        return this.expression;
    }

    public ExprCastOperator op() {
        return this.op;
    }

    @Override
    public <E, F, D, I> I accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.op) + "(" + this.expression.toString() + ")";
    }
}

