/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class Comprehension
extends Expression {
    private final Decls decls;
    private final Formula formula;

    Comprehension(Decls decls, Formula formula) {
        if (formula == null) {
            throw new NullPointerException("null formula");
        }
        for (Decl decl : decls) {
            if (decl.variable().arity() <= 1 && decl.multiplicity() == Multiplicity.ONE) continue;
            throw new IllegalArgumentException("Cannot have a higher order declaration in a comprehension: " + decl);
        }
        this.decls = decls;
        this.formula = formula;
    }

    public Formula formula() {
        return this.formula;
    }

    public Decls decls() {
        return this.decls;
    }

    @Override
    public int arity() {
        return this.decls.size();
    }

    @Override
    public <E, F, D, I> E accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "{ " + this.decls().toString() + " | " + this.formula().toString() + " }";
    }
}

