/*
 * Decompiled with CFR 0.152.
 */
package isabelle.graphview;

import isabelle.Font_Metric$;
import isabelle.Graph;
import isabelle.Graph_Display;
import isabelle.Options;
import isabelle.Pretty$;
import isabelle.XML;
import isabelle.XML$;
import isabelle.graphview.Graphview$Colors$;
import isabelle.graphview.Graphview$Node_Color$;
import isabelle.graphview.Graphview$Selection$;
import isabelle.graphview.Layout;
import isabelle.graphview.Layout$;
import isabelle.graphview.Layout$Node$;
import isabelle.graphview.Metrics;
import isabelle.graphview.Metrics$;
import isabelle.graphview.Model;
import isabelle.graphview.Shapes$;
import isabelle.graphview.Shapes$Cardinal_Spline_Edge$;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.JComponent;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class Graphview {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Graphview.class.getDeclaredField("Selection$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Graphview.class.getDeclaredField("Colors$lzy1"));
    private final Model model;
    private Layout _layout;
    private boolean show_content;
    private boolean show_arrow_heads;
    private boolean show_dummies;
    private boolean editor_style;
    private volatile Object Colors$lzy1;
    private Option current_node;
    private volatile Object Selection$lzy1;
    public final Graphview$Node_Color$ Node_Color$lzy1 = new Graphview$Node_Color$(this);

    public Graphview(Graph<Graph_Display.Node, List<XML.Tree>> full_graph) {
        this.model = new Model(full_graph);
        this._layout = Layout$.MODULE$.empty();
        this.show_content = false;
        this.show_arrow_heads = false;
        this.show_dummies = false;
        this.editor_style = false;
        this.current_node = None$.MODULE$;
    }

    public abstract Options options();

    public Model model() {
        return this.model;
    }

    public Layout layout() {
        return this._layout;
    }

    public Metrics metrics() {
        return this.layout().metrics();
    }

    public Graph<Graph_Display.Node, List<XML.Tree>> visible_graph() {
        return this.layout().input_graph();
    }

    public void translate_vertex(Layout.Vertex v, double dx, double dy) {
        this._layout = this._layout.translate_vertex(v, dx, dy);
    }

    public Option<Graph_Display.Node> find_node(Point2D at) {
        return this.layout().output_graph().iterator().collectFirst((PartialFunction)new Serializable(at){
            private final Point2D at$1;
            {
                this.at$1 = at$3;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Layout.Vertex vertex = (Layout.Vertex)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (vertex instanceof Layout.Node) {
                        Layout.Info info;
                        Graph_Display.Node node;
                        Layout.Node node2 = Layout$Node$.MODULE$.unapply((Layout.Node)vertex);
                        Graph_Display.Node node3 = node = node2._1();
                        if (tuple22 != null && Shapes$.MODULE$.shape(info = (Layout.Info)tuple22._1()).contains(this.at$1)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Layout.Vertex vertex = (Layout.Vertex)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (vertex instanceof Layout.Node) {
                        Layout.Info info;
                        Graph_Display.Node node;
                        Layout.Node node2 = Layout$Node$.MODULE$.unapply((Layout.Node)vertex);
                        Graph_Display.Node node3 = node = node2._1();
                        if (tuple22 != null && Shapes$.MODULE$.shape(info = (Layout.Info)tuple22._1()).contains(this.at$1)) {
                            return node3;
                        }
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Option<Layout.Dummy> find_dummy(Point2D at) {
        return this.layout().output_graph().iterator().collectFirst((PartialFunction)new Serializable(at){
            private final Point2D at$2;
            {
                this.at$2 = at$4;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Layout.Vertex vertex = (Layout.Vertex)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (vertex instanceof Layout.Dummy) {
                        Layout.Info info;
                        Layout.Dummy dummy = (Layout.Dummy)vertex;
                        if (tuple22 != null && Shapes$.MODULE$.shape(info = (Layout.Info)tuple22._1()).contains(this.at$2)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Layout.Vertex vertex = (Layout.Vertex)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (vertex instanceof Layout.Dummy) {
                        Layout.Info info;
                        Layout.Dummy dummy = (Layout.Dummy)vertex;
                        if (tuple22 != null && Shapes$.MODULE$.shape(info = (Layout.Info)tuple22._1()).contains(this.at$2)) {
                            return dummy;
                        }
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Rectangle2D.Double bounding_box() {
        DoubleRef x0 = DoubleRef.create((double)0.0);
        DoubleRef y0 = DoubleRef.create((double)0.0);
        DoubleRef x1 = DoubleRef.create((double)0.0);
        DoubleRef y1 = DoubleRef.create((double)0.0);
        this.layout().output_graph().iterator().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Layout.Info info = (Layout.Info)tuple2._1();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Layout.Info info = (Layout.Info)tuple2._1();
                Rectangle2D.Double rect = Shapes$.MODULE$.shape(info);
                x0$1.elem = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(x0$1.elem), rect.getMinX());
                y0$1.elem = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(y0$1.elem), rect.getMinY());
                x1$1.elem = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(x1$1.elem), rect.getMaxX());
                y1$1.elem = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(y1$1.elem), rect.getMaxY());
                return;
            }
            throw new MatchError((Object)tuple22);
        });
        x0.elem = RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(x0.elem - this.metrics().gap()));
        y0.elem = RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(y0.elem - this.metrics().gap()));
        x1.elem = RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(x1.elem + this.metrics().gap()));
        y1.elem = RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(y1.elem + this.metrics().gap()));
        return new Rectangle2D.Double(x0.elem, y0.elem, x1.elem - x0.elem, y1.elem - y0.elem);
    }

    public void update_layout() {
        Metrics metrics = Metrics$.MODULE$.apply(this.make_font());
        Graph<Graph_Display.Node, List<XML.Tree>> visible_graph = this.model().make_visible_graph();
        this._layout = Layout$.MODULE$.make(this.options(), metrics, (Function2<Graph_Display.Node, List<XML.Tree>, String>)(Function2 & Serializable)(node, content) -> this.node_text$1(metrics, (Graph_Display.Node)node, (List)content), visible_graph);
    }

    public String make_tooltip(JComponent parent, int x, int y, XML.Elem tip) {
        return null;
    }

    public Color foreground_color() {
        return Color.BLACK;
    }

    public Color background_color() {
        return Color.WHITE;
    }

    public Color selection_color() {
        return new Color(204, 204, 255);
    }

    public Color highlight_color() {
        return new Color(255, 255, 224);
    }

    public Color error_color() {
        return Color.RED;
    }

    public Color dummy_color() {
        return Color.GRAY;
    }

    public Font make_font() {
        String family = this.options().string().apply("graphview_font_family");
        int size = BoxesRunTime.unboxToInt((Object)this.options().int().apply("graphview_font_size"));
        return new Font(family, 0, size);
    }

    public boolean show_content() {
        return this.show_content;
    }

    public void show_content_$eq(boolean x$1) {
        this.show_content = x$1;
    }

    public boolean show_arrow_heads() {
        return this.show_arrow_heads;
    }

    public void show_arrow_heads_$eq(boolean x$1) {
        this.show_arrow_heads = x$1;
    }

    public boolean show_dummies() {
        return this.show_dummies;
    }

    public void show_dummies_$eq(boolean x$1) {
        this.show_dummies = x$1;
    }

    public boolean editor_style() {
        return this.editor_style;
    }

    public void editor_style_$eq(boolean x$1) {
        this.editor_style = x$1;
    }

    public final Graphview$Colors$ Colors() {
        Object object = this.Colors$lzy1;
        if (object instanceof Graphview$Colors$) {
            return (Graphview$Colors$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Graphview$Colors$)this.Colors$lzyINIT1();
    }

    private Object Colors$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Colors$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Graphview$Colors$ graphview$Colors$ = null;
                    try {
                        graphview$Colors$ = new Graphview$Colors$();
                        object2 = graphview$Colors$ == null ? LazyVals.NullValue$.MODULE$ : graphview$Colors$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Colors$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return graphview$Colors$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void paint(Graphics2D gfx) {
        gfx.setRenderingHints(Font_Metric$.MODULE$.default_hints());
        this.current_node().foreach((Function1)(JProcedure1 & Serializable)node -> Shapes$.MODULE$.highlight_node(gfx, this, (Graph_Display.Node)node));
        this.visible_graph().edges_iterator().foreach((Function1)(JProcedure1 & Serializable)edge -> Shapes$Cardinal_Spline_Edge$.MODULE$.paint(gfx, this, (Tuple2<Graph_Display.Node, Graph_Display.Node>)edge));
        this.visible_graph().keys_iterator().foreach((Function1)(JProcedure1 & Serializable)node -> Shapes$.MODULE$.paint_node(gfx, this, (Graph_Display.Node)node));
    }

    public Option<Graph_Display.Node> current_node() {
        return this.current_node;
    }

    public void current_node_$eq(Option<Graph_Display.Node> x$1) {
        this.current_node = x$1;
    }

    public final Graphview$Selection$ Selection() {
        Object object = this.Selection$lzy1;
        if (object instanceof Graphview$Selection$) {
            return (Graphview$Selection$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Graphview$Selection$)this.Selection$lzyINIT1();
    }

    private Object Selection$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Selection$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Graphview$Selection$ graphview$Selection$ = null;
                    try {
                        graphview$Selection$ = new Graphview$Selection$();
                        object2 = graphview$Selection$ == null ? LazyVals.NullValue$.MODULE$ : graphview$Selection$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Selection$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return graphview$Selection$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final Graphview$Node_Color$ Node_Color() {
        return this.Node_Color$lzy1;
    }

    public Node_Color node_color(Graph_Display.Node node) {
        if (this.Selection().contains(node)) {
            return this.Node_Color().apply(this.foreground_color(), this.selection_color(), this.foreground_color());
        }
        Option<Graph_Display.Node> option = this.current_node();
        Some some = Some$.MODULE$.apply((Object)node);
        if (!(option != null ? !option.equals((Object)some) : some != null)) {
            return this.Node_Color().apply(this.foreground_color(), this.highlight_color(), this.foreground_color());
        }
        return this.Node_Color().apply(this.foreground_color(), (Color)this.model().colors().getOrElse((Object)node, this::node_color$$anonfun$1), this.foreground_color());
    }

    public Color edge_color(Tuple2<Graph_Display.Node, Graph_Display.Node> edge, boolean downwards) {
        if (downwards || this.show_arrow_heads()) {
            return this.foreground_color();
        }
        return this.error_color();
    }

    private final String node_text$1(Metrics metrics$1, Graph_Display.Node node, List content) {
        if (this.show_content()) {
            double d;
            double d2 = BoxesRunTime.unboxToInt((Object)this.options().int().apply("graphview_content_margin"));
            Function1<String, String> function1 = Pretty$.MODULE$.formatted$default$2();
            String s = XML$.MODULE$.content(Pretty$.MODULE$.formatted((List<XML.Tree>)content, function1, d2, d = Pretty$.MODULE$.formatted$default$4(), metrics$1));
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
                return s;
            }
            return node.toString();
        }
        return node.toString();
    }

    public static final /* synthetic */ List isabelle$graphview$Graphview$Selection$$$_$add$$anonfun$1(Graph_Display.Node node$1, List _$1) {
        return _$1.$colon$colon((Object)node$1);
    }

    public static final /* synthetic */ List isabelle$graphview$Graphview$Selection$$$_$clear$$anonfun$1(List _$2) {
        return package$.MODULE$.Nil();
    }

    private final Color node_color$$anonfun$1() {
        return this.background_color();
    }

    public class Node_Color
    implements Product,
    Serializable {
        private final Color border;
        private final Color background;
        private final Color foreground;
        private final /* synthetic */ Graphview $outer;

        public Node_Color(Graphview $outer, Color border, Color background, Color foreground) {
            this.border = border;
            this.background = background;
            this.foreground = foreground;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Node_Color)) return false;
            if (((Node_Color)object).isabelle$graphview$Graphview$Node_Color$$$outer() != this.$outer) return false;
            Node_Color node_Color = (Node_Color)object;
            Color color = this.border();
            Color color2 = node_Color.border();
            if (color == null) {
                if (color2 != null) {
                    return false;
                }
            } else if (!((Object)color).equals(color2)) return false;
            Color color3 = this.background();
            Color color4 = node_Color.background();
            if (color3 == null) {
                if (color4 != null) {
                    return false;
                }
            } else if (!((Object)color3).equals(color4)) return false;
            Color color5 = this.foreground();
            Color color6 = node_Color.foreground();
            if (color5 == null) {
                if (color6 != null) {
                    return false;
                }
            } else if (!((Object)color5).equals(color6)) return false;
            if (!node_Color.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Node_Color;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Node_Color";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "border";
                }
                case 1: {
                    return "background";
                }
                case 2: {
                    return "foreground";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Color border() {
            return this.border;
        }

        public Color background() {
            return this.background;
        }

        public Color foreground() {
            return this.foreground;
        }

        public Node_Color copy(Color border, Color background, Color foreground) {
            return new Node_Color(this.$outer, border, background, foreground);
        }

        public Color copy$default$1() {
            return this.border();
        }

        public Color copy$default$2() {
            return this.background();
        }

        public Color copy$default$3() {
            return this.foreground();
        }

        public Color _1() {
            return this.border();
        }

        public Color _2() {
            return this.background();
        }

        public Color _3() {
            return this.foreground();
        }

        public final /* synthetic */ Graphview isabelle$graphview$Graphview$Node_Color$$$outer() {
            return this.$outer;
        }
    }
}

