/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.File$;
import isabelle.Library$;
import isabelle.UTF8$;
import isabelle.Url;
import isabelle.package$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class Url$
implements Serializable {
    private static final String separators1;
    private static final String separators2;
    public static final Url$ MODULE$;

    private Url$() {
    }

    static {
        MODULE$ = new Url$();
        separators1 = "/\\";
        separators2 = ":/\\";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Url$.class);
    }

    public String escape_special(char c) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString("!#$&'()*+,/:;=?@[]"), c)) {
            return String.format(Locale.ROOT, "%%%02X", (int)c);
        }
        return BoxesRunTime.boxToCharacter((char)c).toString();
    }

    public String escape_special(String s) {
        return StringOps$.MODULE$.iterator$extension(Predef$.MODULE$.augmentString(s)).map((Function1 & Serializable)c -> Url$.MODULE$.escape_special(BoxesRunTime.unboxToChar((Object)c))).mkString();
    }

    public String escape_name(String name) {
        return StringOps$.MODULE$.iterator$extension(Predef$.MODULE$.augmentString(name)).map((Function1 & Serializable)x$1 -> Url$.escape_name$$anonfun$1(BoxesRunTime.unboxToChar((Object)x$1))).mkString();
    }

    public boolean is_malformed(Throwable exn) {
        return exn instanceof MalformedURLException || exn instanceof URISyntaxException || exn instanceof IllegalArgumentException;
    }

    public Url apply(URI uri) {
        return new Url(uri);
    }

    public Url apply(String name) {
        Url url;
        try {
            url = new Url(new URI(name));
        }
        catch (Throwable throwable) {
            Throwable exn;
            Throwable throwable2 = throwable;
            if (throwable2 == null || !this.is_malformed(exn = throwable2)) {
                throw throwable;
            }
            throw (Nothing$)package$.MODULE$.error().apply((Object)("Malformed URL " + package$.MODULE$.quote().apply((Object)name)));
        }
        return url;
    }

    public boolean is_wellformed(String name) {
        boolean bl;
        try {
            this.apply(name);
            bl = true;
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public boolean is_readable(String name) {
        boolean bl;
        try {
            this.apply(name).open_stream().close();
            bl = true;
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public String file_name(Url url) {
        return ((IterableOnceOps)Library$.MODULE$.take_suffix((Function1 & Serializable)c -> Url$.file_name$$anonfun$1(BoxesRunTime.unboxToChar((Object)c)), Predef$.MODULE$.wrapString(url.java_url().getFile()).toList())._2()).mkString();
    }

    public Url trim_index(Url url) {
        Option<String> option = Library$.MODULE$.try_unprefix("/index.html", url.toString());
        if (option instanceof Some) {
            String u = (String)((Some)option).value();
            return this.apply(u);
        }
        if (None$.MODULE$.equals(option)) {
            Option<String> option2 = Library$.MODULE$.try_unprefix("/index.php", url.toString());
            if (option2 instanceof Some) {
                String u = (String)((Some)option2).value();
                return this.apply(u);
            }
            if (None$.MODULE$.equals(option2)) {
                return url;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public String decode(String s) {
        return URLDecoder.decode(s, UTF8$.MODULE$.charset());
    }

    public String encode(String s) {
        return URLEncoder.encode(s, UTF8$.MODULE$.charset());
    }

    private String read(Url url, boolean gzip) {
        return (String)package$.MODULE$.using(url.open_stream(), (Function1 & Serializable)stream -> File$.MODULE$.read_stream(gzip ? new GZIPInputStream((InputStream)stream) : stream));
    }

    public String read(Url url) {
        return this.read(url, false);
    }

    public String read_gzip(Url url) {
        return this.read(url, true);
    }

    public String read(String name) {
        return this.read(this.apply(name), false);
    }

    public String read_gzip(String name) {
        return this.read(this.apply(name), true);
    }

    public String print_file(File file) {
        return File$.MODULE$.absolute(file).toPath().toUri().toString();
    }

    public String print_file_name(String name) {
        return this.print_file(new File(name));
    }

    public File parse_file(String uri) {
        return Paths.get(new URI(uri)).toFile();
    }

    public boolean is_wellformed_file(String uri) {
        boolean bl;
        try {
            this.parse_file(uri);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof URISyntaxException || throwable2 instanceof IllegalArgumentException || throwable2 instanceof FileSystemNotFoundException) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public File absolute_file(String uri) {
        return File$.MODULE$.absolute(this.parse_file(uri));
    }

    public String absolute_file_name(String uri) {
        return this.absolute_file(uri).getPath();
    }

    public File canonical_file(String uri) {
        return File$.MODULE$.canonical(this.parse_file(uri));
    }

    public String canonical_file_name(String uri) {
        return this.canonical_file(uri).getPath();
    }

    public boolean is_base_name(String s, String suffix) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)) && !StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$0 -> StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(Url$.separators2), BoxesRunTime.unboxToChar((Object)x$0))) && s.endsWith(suffix);
    }

    public String is_base_name$default$2() {
        return "";
    }

    public Option<String> get_base_name(String s, String suffix) {
        String string = Predef$.MODULE$.augmentString(s);
        int i = StringOps$.MODULE$.lastIndexWhere$extension(string, (Function1 & Serializable)x$0 -> StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(Url$.separators2), BoxesRunTime.unboxToChar((Object)x$0)), StringOps$.MODULE$.lastIndexWhere$default$2$extension(string));
        if (i + 1 >= s.length()) {
            return None$.MODULE$;
        }
        return Library$.MODULE$.try_unsuffix(suffix, s.substring(i + 1));
    }

    public String get_base_name$default$2() {
        return "";
    }

    public Option<String> strip_base_name(String s, String suffix) {
        String string = Predef$.MODULE$.augmentString(s);
        int i = StringOps$.MODULE$.lastIndexWhere$extension(string, (Function1 & Serializable)x$0 -> StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(Url$.separators2), BoxesRunTime.unboxToChar((Object)x$0)), StringOps$.MODULE$.lastIndexWhere$default$2$extension(string));
        int j = StringOps$.MODULE$.lastIndexWhere$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)c -> Url$.$anonfun$3(BoxesRunTime.unboxToChar((Object)c)), i);
        if (i + 1 >= s.length() || !s.endsWith(suffix)) {
            return None$.MODULE$;
        }
        if (j < 0) {
            return Some$.MODULE$.apply((Object)s.substring(0, i + 1));
        }
        return Some$.MODULE$.apply((Object)s.substring(0, j + 1));
    }

    public String strip_base_name$default$2() {
        return "";
    }

    public String get_ext(String str) {
        String s = (String)this.get_base_name(str, this.get_base_name$default$2()).getOrElse(Url$::$anonfun$4);
        int i = s.lastIndexOf(46);
        if (i < 0 || i + 1 >= s.length()) {
            return "";
        }
        return s.substring(i + 1);
    }

    public String append_path(String prefix, String suffix) {
        block6: {
            block5: {
                if (prefix.endsWith(":") || prefix.endsWith("/") || prefix.endsWith("\\") || prefix.isEmpty()) {
                    return prefix + suffix;
                }
                if (prefix.endsWith(":.") || prefix.endsWith("/.") || prefix.endsWith("\\.")) break block5;
                String string = prefix;
                String string2 = ".";
                if (string != null ? !string.equals(string2) : string2 != null) break block6;
            }
            return prefix.substring(0, prefix.length() - 1) + suffix;
        }
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(prefix), '\\') || StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(suffix), '\\')) {
            return prefix + "\\" + suffix;
        }
        return prefix + "/" + suffix;
    }

    public String direct_path(String prefix) {
        return this.append_path(prefix, ".");
    }

    public String dir_path(String prefix, boolean direct) {
        if (direct) {
            return this.direct_path(prefix);
        }
        return prefix;
    }

    public boolean dir_path$default$2() {
        return false;
    }

    public String index_path(String prefix, String index) {
        return this.append_path(prefix, index.isEmpty() ? "index.html" : index);
    }

    public String index_path$default$1() {
        return "";
    }

    public String index_path$default$2() {
        return "";
    }

    private static final /* synthetic */ String escape_name$$anonfun$1(char x$1) {
        char c = x$1;
        if ('\'' == c) {
            return "%27";
        }
        char c2 = c;
        return BoxesRunTime.boxToCharacter((char)c2).toString();
    }

    private static final /* synthetic */ boolean file_name$$anonfun$1(char c) {
        return c != '/' && c != '\\';
    }

    private static final /* synthetic */ boolean $anonfun$3(char c) {
        return !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(separators1), c);
    }

    private static final String $anonfun$4() {
        return "";
    }
}

