/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Library$;
import isabelle.Path;
import isabelle.SHA1;
import isabelle.Symbol$;
import isabelle.package$;
import isabelle.setup.Build;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class SHA1$
implements Serializable {
    private static final SHA1.Digest digest_empty;
    private static final SHA1.Shasum no_shasum;
    public static final SHA1$ MODULE$;

    private SHA1$() {
    }

    static {
        MODULE$ = new SHA1$();
        digest_empty = MODULE$.make_digest((Function1<MessageDigest, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> {});
        no_shasum = new SHA1.Shasum((List<String>)scala.package$.MODULE$.Nil());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SHA1$.class);
    }

    public SHA1.Digest fake_digest(String rep) {
        return new SHA1.Digest(rep);
    }

    public SHA1.Digest make_digest(Function1<MessageDigest, BoxedUnit> body) {
        Build.Digest_Body digest_body = new Build.Digest_Body(body){
            private final Function1 body$1;
            {
                this.body$1 = body$2;
            }

            public void apply(MessageDigest sha) {
                this.body$1.apply((Object)sha);
            }
        };
        return new SHA1.Digest(Build.make_digest((Build.Digest_Body)digest_body));
    }

    public SHA1.Digest digest_empty() {
        return digest_empty;
    }

    public int digest_length() {
        return this.digest_empty().toString().length();
    }

    public SHA1.Digest digest(File file) {
        return this.make_digest((Function1<MessageDigest, BoxedUnit>)(JProcedure1 & Serializable)sha -> package$.MODULE$.using(new FileInputStream(file), (JProcedure1 & Serializable)stream -> {
            byte[] buf = new byte[65536];
            int m = 0;
            do {
                if ((m = stream.read(buf, 0, buf.length)) == -1) continue;
                sha.update(buf, 0, m);
            } while (m != -1);
        }));
    }

    public SHA1.Digest digest(Path path) {
        return this.digest(path.file());
    }

    public SHA1.Digest digest(byte[] bytes) {
        return this.make_digest((Function1<MessageDigest, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> _$2.update(bytes));
    }

    public SHA1.Digest digest(byte[] bytes, int offset, int length) {
        return this.make_digest((Function1<MessageDigest, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> _$3.update(bytes, offset, length));
    }

    public SHA1.Digest digest(Bytes bytes) {
        return bytes.sha1_digest();
    }

    public SHA1.Digest digest(String string) {
        return this.digest(Bytes$.MODULE$.apply(string));
    }

    public SHA1.Shasum no_shasum() {
        return no_shasum;
    }

    public SHA1.Shasum flat_shasum(List<SHA1.Shasum> list) {
        return new SHA1.Shasum((List<String>)list.flatMap((Function1 & Serializable)_$4 -> _$4.rep()));
    }

    public SHA1.Shasum fake_shasum(String text) {
        return new SHA1.Shasum(Library$.MODULE$.trim_split_lines(text));
    }

    public SHA1.Shasum shasum(SHA1.Digest digest, String name) {
        return new SHA1.Shasum((List<String>)((List)new .colon.colon((Object)(digest.toString() + " " + name), (List)Nil$.MODULE$)));
    }

    public SHA1.Shasum shasum_meta_info(SHA1.Digest digest) {
        return this.shasum(digest, Build.META_INFO);
    }

    public SHA1.Shasum shasum_sorted(List<Tuple2<SHA1.Digest, String>> args) {
        return this.flat_shasum((List<SHA1.Shasum>)((List)args.sortBy((Function1 & Serializable)_$5 -> (String)_$5._2(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$1 -> {
            SHA1.Digest digest = (SHA1.Digest)x$1._1();
            String string = (String)x$1._2();
            return MODULE$.shasum(digest, string);
        }));
    }

    public static final /* synthetic */ boolean isabelle$SHA1$Shasum$$_$$minus$$anonfun$1(Set $1$$1, String elem) {
        return $1$$1.contains((Object)elem);
    }

    public static /* bridge */ /* synthetic */ boolean isabelle$SHA1$Shasum$$_$digest$$anonfun$adapted$1(Object c) {
        return Symbol$.MODULE$.is_ascii_hex(BoxesRunTime.unboxToChar((Object)c));
    }
}

