/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bytes$;
import isabelle.File;
import isabelle.File$;
import isabelle.Graph;
import isabelle.Graph$;
import isabelle.HTTP;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Mercurial$;
import isabelle.Mercurial$Archive_Info$;
import isabelle.Mercurial$Hg_Sync$;
import isabelle.Mercurial$Repository$;
import isabelle.Mercurial$Server$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.Rsync;
import isabelle.Rsync$;
import isabelle.SSH;
import isabelle.Synchronized;
import isabelle.Synchronized$;
import isabelle.Url$;
import isabelle.package$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class Mercurial {
    public static Option<String> archive_id(Path path) {
        return Mercurial$.MODULE$.archive_id(path);
    }

    public static Option<Archive_Info> archive_info(Path path) {
        return Mercurial$.MODULE$.archive_info(path);
    }

    public static Option<String> archive_tags(Path path) {
        return Mercurial$.MODULE$.archive_tags(path);
    }

    public static Tuple2<List<Path>, List<Path>> check_files(List<Path> list, SSH.System system) {
        return Mercurial$.MODULE$.check_files(list, system);
    }

    public static Repository clone_repository(String string, Path path, String string2, String string3, SSH.System system) {
        return Mercurial$.MODULE$.clone_repository(string, path, string2, string3, system);
    }

    public static String default_path_name() {
        return Mercurial$.MODULE$.default_path_name();
    }

    public static Option<Repository> detect_repository(Path path, SSH.System system) {
        return Mercurial$.MODULE$.detect_repository(path, system);
    }

    public static Option<Repository> find_repository(Path path, SSH.System system) {
        return Mercurial$.MODULE$.find_repository(path, system);
    }

    public static void hg_setup(String string, Path path, String string2, String string3, boolean bl, Progress progress) {
        Mercurial$.MODULE$.hg_setup(string, path, string2, string3, bl, progress);
    }

    public static Option<String> id_repository(Path path, SSH.System system, String string) {
        return Mercurial$.MODULE$.id_repository(path, system, string);
    }

    public static Repository init_repository(Path path, SSH.System system) {
        return Mercurial$.MODULE$.init_repository(path, system);
    }

    public static boolean is_repository(Path path, SSH.System system) {
        return Mercurial$.MODULE$.is_repository(path, system);
    }

    public static Isabelle_Tool isabelle_tool1() {
        return Mercurial$.MODULE$.isabelle_tool1();
    }

    public static Isabelle_Tool isabelle_tool2() {
        return Mercurial$.MODULE$.isabelle_tool2();
    }

    public static String opt_flag(String string, boolean bl) {
        return Mercurial$.MODULE$.opt_flag(string, bl);
    }

    public static String opt_rev(String string) {
        return Mercurial$.MODULE$.opt_rev(string);
    }

    public static String opt_template(String string) {
        return Mercurial$.MODULE$.opt_template(string);
    }

    public static String optional(String string, String string2) {
        return Mercurial$.MODULE$.optional(string, string2);
    }

    public static Repository repository(Path path, SSH.System system) {
        return Mercurial$.MODULE$.repository(path, system);
    }

    public static Repository self_repository() {
        return Mercurial$.MODULE$.self_repository();
    }

    public static Repository setup_repository(String string, Path path, SSH.System system) {
        return Mercurial$.MODULE$.setup_repository(string, path, system);
    }

    public static Option<String> sync_id(Path path, SSH.System system) {
        return Mercurial$.MODULE$.sync_id(path, system);
    }

    public static Repository the_repository(Path path, SSH.System system) {
        return Mercurial$.MODULE$.the_repository(path, system);
    }

    public static SSH.System check_files$default$2() {
        return Mercurial$.MODULE$.check_files$default$2();
    }

    public static SSH.System detect_repository$default$2() {
        return Mercurial$.MODULE$.detect_repository$default$2();
    }

    public static SSH.System find_repository$default$2() {
        return Mercurial$.MODULE$.find_repository$default$2();
    }

    public static SSH.System id_repository$default$2() {
        return Mercurial$.MODULE$.id_repository$default$2();
    }

    public static SSH.System init_repository$default$2() {
        return Mercurial$.MODULE$.init_repository$default$2();
    }

    public static SSH.System is_repository$default$2() {
        return Mercurial$.MODULE$.is_repository$default$2();
    }

    public static String optional$default$2() {
        return Mercurial$.MODULE$.optional$default$2();
    }

    public static SSH.System repository$default$2() {
        return Mercurial$.MODULE$.repository$default$2();
    }

    public static SSH.System sync_id$default$2() {
        return Mercurial$.MODULE$.sync_id$default$2();
    }

    public static SSH.System the_repository$default$2() {
        return Mercurial$.MODULE$.the_repository$default$2();
    }

    public static String clone_repository$default$3() {
        return Mercurial$.MODULE$.clone_repository$default$3();
    }

    public static String hg_setup$default$3() {
        return Mercurial$.MODULE$.hg_setup$default$3();
    }

    public static String id_repository$default$3() {
        return Mercurial$.MODULE$.id_repository$default$3();
    }

    public static SSH.System setup_repository$default$3() {
        return Mercurial$.MODULE$.setup_repository$default$3();
    }

    public static String clone_repository$default$4() {
        return Mercurial$.MODULE$.clone_repository$default$4();
    }

    public static String hg_setup$default$4() {
        return Mercurial$.MODULE$.hg_setup$default$4();
    }

    public static SSH.System clone_repository$default$5() {
        return Mercurial$.MODULE$.clone_repository$default$5();
    }

    public static boolean hg_setup$default$5() {
        return Mercurial$.MODULE$.hg_setup$default$5();
    }

    public static Progress hg_setup$default$6() {
        return Mercurial$.MODULE$.hg_setup$default$6();
    }

    public static class Archive_Info
    implements Product,
    Serializable {
        private final List lines;

        public static Archive_Info apply(List<String> list) {
            return Mercurial$Archive_Info$.MODULE$.apply(list);
        }

        public static Archive_Info fromProduct(Product product) {
            return Mercurial$Archive_Info$.MODULE$.fromProduct(product);
        }

        public static Archive_Info unapply(Archive_Info archive_Info) {
            return Mercurial$Archive_Info$.MODULE$.unapply(archive_Info);
        }

        public Archive_Info(List<String> lines) {
            this.lines = lines;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Archive_Info)) return false;
            Archive_Info archive_Info = (Archive_Info)object;
            List<String> list = this.lines();
            List<String> list2 = archive_Info.lines();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!archive_Info.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Archive_Info;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Archive_Info";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "lines";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<String> lines() {
            return this.lines;
        }

        public Option<String> id() {
            return this.lines().collectFirst((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(String x) {
                    List list;
                    Option option;
                    String string = x;
                    if (string != null && !(option = Mercurial$.isabelle$Mercurial$$$Archive_Node.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                        String string2;
                        String a = string2 = (String)list.apply(0);
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(String x, Function1 function1) {
                    List list;
                    Option option;
                    String string = x;
                    if (string != null && !(option = Mercurial$.isabelle$Mercurial$$$Archive_Node.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                        String string2;
                        String a = string2 = (String)list.apply(0);
                        return a;
                    }
                    return function1.apply((Object)x);
                }
            });
        }

        public List<String> tags() {
            return (List)this.lines().withFilter(Mercurial$::isabelle$Mercurial$Archive_Info$$_$tags$$anonfun$1).withFilter(Mercurial$::isabelle$Mercurial$Archive_Info$$_$tags$$anonfun$2).map(Mercurial$::isabelle$Mercurial$Archive_Info$$_$tags$$anonfun$3);
        }

        public Archive_Info copy(List<String> lines) {
            return new Archive_Info(lines);
        }

        public List<String> copy$default$1() {
            return this.lines();
        }

        public List<String> _1() {
            return this.lines();
        }
    }

    public static class Repository {
        private final SSH.System ssh;
        private final Path root;
        private final Synchronized<Tuple2<List<String>, Graph<String, BoxedUnit>>> cache_graph;

        public static SSH.System $lessinit$greater$default$2() {
            return Mercurial$Repository$.MODULE$.$lessinit$greater$default$2();
        }

        public Repository(Path root_path, SSH.System ssh) {
            this.ssh = ssh;
            this.root = ssh.expand_path(root_path);
            this.cache_graph = Synchronized$.MODULE$.apply(Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.Nil(), Graph$.MODULE$.string()));
        }

        public Path root() {
            return this.root;
        }

        public String root_url() {
            return this.ssh.hg_url() + this.root().implode();
        }

        public String toString() {
            return this.ssh.hg_url() + this.root().implode();
        }

        public String command_line(String name, String args, String options, boolean repository) {
            return Bash$.MODULE$.exports((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"LANG=C", "HGPLAIN="})) + "\"${HG:-hg}\" --config " + Bash$.MODULE$.string("defaults." + name + "=") + (String)(repository ? " --repository " + this.ssh.bash_path(this.root()) : "") + " --noninteractive " + name + " " + options + " " + args;
        }

        public String command_line$default$2() {
            return "";
        }

        public String command_line$default$3() {
            return "";
        }

        public boolean command_line$default$4() {
            return true;
        }

        public Process_Result command(String name, String args, String options, boolean repository) {
            return this.ssh.execute(this.command_line(name, args, options, repository), this.ssh.execute$default$2(), this.ssh.execute$default$3(), this.ssh.execute$default$4(), this.ssh.execute$default$5(), this.ssh.execute$default$6());
        }

        public String command$default$2() {
            return "";
        }

        public String command$default$3() {
            return "";
        }

        public boolean command$default$4() {
            return true;
        }

        public void add(List<Path> files) {
            this.command("add", files.map((Function1 & Serializable)path -> this.ssh.bash_path((Path)path)).mkString(" "), this.command$default$3(), this.command$default$4());
        }

        public void archive(String target, String rev, String options) {
            this.command("archive", Mercurial$.MODULE$.opt_rev(rev) + " " + Bash$.MODULE$.string(target), options, this.command$default$4()).check();
        }

        public String archive$default$2() {
            return "";
        }

        public String archive$default$3() {
            return "";
        }

        public List<String> heads(String template, String options) {
            return this.command("heads", Mercurial$.MODULE$.opt_template(template), options, this.command$default$4()).check().out_lines();
        }

        public String heads$default$1() {
            return "{node|short}\n";
        }

        public String heads$default$2() {
            return "";
        }

        public String identify(String rev, String options) {
            return (String)this.command("id", Mercurial$.MODULE$.opt_rev(rev), options, this.command$default$4()).check().out_lines().headOption().getOrElse(Mercurial$::isabelle$Mercurial$Repository$$_$identify$$anonfun$1);
        }

        public String identify$default$1() {
            return "tip";
        }

        public String identify$default$2() {
            return "";
        }

        public String id(String rev) {
            return this.identify(rev, "-i");
        }

        public String id$default$1() {
            return "tip";
        }

        public String tags(String rev) {
            String result = this.identify(rev, "-t");
            return ((List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)' '), (Object)result)).filterNot(Mercurial$::isabelle$Mercurial$Repository$$_$tags$$anonfun$4).mkString(" ");
        }

        public String tags$default$1() {
            return "tip";
        }

        public List<String> paths(String args, String options) {
            return this.command("paths", args, options, this.command$default$4()).check().out_lines();
        }

        public String paths$default$1() {
            return "";
        }

        public String paths$default$2() {
            return "";
        }

        public List<String> manifest(String rev, String options) {
            return this.command("manifest", Mercurial$.MODULE$.opt_rev(rev), options, this.command$default$4()).check().out_lines();
        }

        public String manifest$default$1() {
            return "";
        }

        public String manifest$default$2() {
            return "";
        }

        public String log(String rev, String template, String options) {
            return this.command("log", Mercurial$.MODULE$.opt_rev(rev) + Mercurial$.MODULE$.opt_template(template), options, this.command$default$4()).check().out();
        }

        public String log$default$1() {
            return "";
        }

        public String log$default$2() {
            return "";
        }

        public String log$default$3() {
            return "";
        }

        public String diff(String rev, String options) {
            return this.command("diff", Mercurial$.MODULE$.opt_rev(rev), options, this.command$default$4()).check().out();
        }

        public String diff$default$1() {
            return "";
        }

        public String diff$default$2() {
            return "";
        }

        public String parent() {
            return this.log("p1()", "{node|short}", this.log$default$3());
        }

        public void push(String remote, String rev, boolean force, String options) {
            this.command("push", Mercurial$.MODULE$.opt_rev(rev) + Mercurial$.MODULE$.opt_flag("--force", force) + Mercurial$.MODULE$.optional(remote, Mercurial$.MODULE$.optional$default$2()), options, this.command$default$4()).check_rc((Function1<Object, Object>)((JFunction1.mcZI.sp & Serializable)Mercurial$::isabelle$Mercurial$Repository$$_$push$$anonfun$1));
        }

        public String push$default$1() {
            return "";
        }

        public String push$default$2() {
            return "";
        }

        public boolean push$default$3() {
            return false;
        }

        public String push$default$4() {
            return "";
        }

        public void pull(String remote, String rev, String options) {
            this.command("pull", Mercurial$.MODULE$.opt_rev(rev) + Mercurial$.MODULE$.optional(remote, Mercurial$.MODULE$.optional$default$2()), options, this.command$default$4()).check();
        }

        public String pull$default$1() {
            return "";
        }

        public String pull$default$2() {
            return "";
        }

        public String pull$default$3() {
            return "";
        }

        public void update(String rev, boolean clean, boolean check, String options) {
            this.command("update", Mercurial$.MODULE$.opt_rev(rev) + Mercurial$.MODULE$.opt_flag("--clean", clean) + Mercurial$.MODULE$.opt_flag("--check", check), options, this.command$default$4()).check();
        }

        public String update$default$1() {
            return "";
        }

        public boolean update$default$2() {
            return false;
        }

        public boolean update$default$3() {
            return false;
        }

        public String update$default$4() {
            return "";
        }

        public List<String> status(String options) {
            return this.command("status", this.command$default$2(), options, this.command$default$4()).check().out_lines();
        }

        public String status$default$1() {
            return "";
        }

        public List<String> known_files() {
            return this.status("--modified --added --clean --no-status");
        }

        public void sync(Rsync.Context context, Path target, boolean thorough, boolean dry_run, List<String> filter, List<File.Content> contents, String rev) {
            Predef$.MODULE$.require(this.ssh.is_local(), Mercurial$::isabelle$Mercurial$Repository$$_$sync$$anonfun$1);
            Isabelle_System$.MODULE$.with_tmp_dir("sync", Isabelle_System$.MODULE$.with_tmp_dir$default$2(), (Function1 & Serializable)tmp_dir -> {
                Tuple2 tuple2;
                Mercurial$Hg_Sync$.MODULE$.check_directory(target, context.ssh());
                String id_content = this.id(rev);
                boolean is_changed = id_content.endsWith("+");
                String log_content = is_changed ? "" : this.log(rev, this.log$default$2(), "-l1");
                String diff_content = is_changed ? this.diff(rev, "--git") : "";
                String stat_content = is_changed ? this.diff(rev, "--stat") : "";
                File.Content content = File$.MODULE$.content(Mercurial$Hg_Sync$.MODULE$.PATH_ID(), id_content);
                File.Content content2 = File$.MODULE$.content(Mercurial$Hg_Sync$.MODULE$.PATH_LOG(), log_content);
                File.Content content3 = File$.MODULE$.content(Mercurial$Hg_Sync$.MODULE$.PATH_DIFF(), diff_content);
                File.Content content4 = File$.MODULE$.content(Mercurial$Hg_Sync$.MODULE$.PATH_STAT(), stat_content);
                List all_contents = contents.$colon$colon((Object)content4).$colon$colon((Object)content3).$colon$colon((Object)content2).$colon$colon((Object)content);
                all_contents.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> Mercurial$.isabelle$Mercurial$Repository$$_$sync$$anonfun$2$$anonfun$1(target, context, arg_0)));
                if (rev.isEmpty()) {
                    List exclude = this.status("--unknown --ignored --no-status").$colon$colon((Object)".hg");
                    String source = File$.MODULE$.standard_path(this.root());
                    tuple2 = Tuple2$.MODULE$.apply((Object)exclude, (Object)source);
                } else {
                    List exclude = (List)new .colon.colon((Object)".hg_archival.txt", (List)Nil$.MODULE$);
                    String source = File$.MODULE$.standard_path(tmp_dir.$plus(Path$.MODULE$.explode("archive")));
                    this.archive(source, rev, this.archive$default$3());
                    tuple2 = Tuple2$.MODULE$.apply((Object)exclude, (Object)source);
                }
                Tuple2 tuple22 = tuple2;
                List exclude = (List)tuple22._1();
                String source = (String)tuple22._2();
                Path exclude_path = tmp_dir.$plus(Path$.MODULE$.explode("exclude"));
                File$.MODULE$.write(exclude_path, (String)package$.MODULE$.cat_lines().apply((Object)exclude.map(Mercurial$::isabelle$Mercurial$Repository$$_$sync$$anonfun$2$$anonfun$2)));
                Path path = Mercurial$Hg_Sync$.MODULE$.PATH();
                List protect = contents.map(Mercurial$::isabelle$Mercurial$Repository$$_$_$$anonfun$17).$colon$colon((Object)path).map(Mercurial$::isabelle$Mercurial$Repository$$_$_$$anonfun$18);
                List list = filter.$colon$colon$colon(protect);
                List list2 = (List)new .colon.colon((Object)("--exclude-from=" + exclude_path.implode()), (List)new .colon.colon((Object)"--", (List)new .colon.colon((Object)Url$.MODULE$.direct_path(source), (List)new .colon.colon((Object)context.target(target, context.target$default$2()), (List)Nil$.MODULE$))));
                return Rsync$.MODULE$.exec(context, thorough, true, dry_run, true, (List<String>)list, (List<String>)list2).check();
            });
        }

        public boolean sync$default$3() {
            return false;
        }

        public boolean sync$default$4() {
            return false;
        }

        public List<String> sync$default$5() {
            return scala.package$.MODULE$.Nil();
        }

        public List<File.Content> sync$default$6() {
            return scala.package$.MODULE$.Nil();
        }

        public String sync$default$7() {
            return "";
        }

        public Graph<String, BoxedUnit> graph() {
            return (Graph)this.cache_graph.change_result((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Graph graph;
                    List<String> topo;
                    List old_topo = (List)tuple2._1();
                    Graph old_graph = (Graph)tuple2._2();
                    List<String> list = topo = this.heads(this.heads$default$1(), "--topo");
                    List list2 = old_topo;
                    if (!(list != null ? !list.equals((Object)list2) : list2 != null)) {
                        graph = old_graph;
                    } else {
                        Regex Node2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^node: (\\w{12}) (\\w{12}) (\\w{12})"));
                        String log_result = this.log(this.log$default$1(), "node: {node|short} {p1node|short} {p2node|short}\\n", this.log$default$3());
                        graph = (Graph)((LinearSeqOps)package$.MODULE$.split_lines().apply((Object)log_result)).foldLeft(Graph$.MODULE$.string(), (arg_0, arg_1) -> Mercurial$.isabelle$Mercurial$Repository$$_$_$$anonfun$19(Node2, arg_0, arg_1));
                    }
                    Graph graph2 = graph;
                    return Tuple2$.MODULE$.apply((Object)graph2, (Object)Tuple2$.MODULE$.apply(topo, (Object)graph2));
                }
                throw new MatchError((Object)tuple2);
            });
        }
    }

    public static class Server
    implements AutoCloseable {
        private final String root;

        public static Server apply(String string) {
            return Mercurial$Server$.MODULE$.apply(string);
        }

        public static Server start(Path path) {
            return Mercurial$Server$.MODULE$.start(path);
        }

        public Server(String root) {
            this.root = root;
        }

        public String root() {
            return this.root;
        }

        public String toString() {
            return this.root();
        }

        @Override
        public void close() {
        }

        public String changeset(String rev, boolean raw) {
            return this.root() + (raw ? "/raw-rev/" : "/rev/") + rev;
        }

        public String changeset$default$1() {
            return "tip";
        }

        public boolean changeset$default$2() {
            return false;
        }

        public String file(Path path, String rev, boolean raw) {
            return this.root() + (raw ? "/raw-file/" : "/file/") + rev + "/" + File$.MODULE$.standard_path(path);
        }

        public String file$default$2() {
            return "tip";
        }

        public boolean file$default$3() {
            return false;
        }

        public String archive(String rev) {
            return this.root() + "/archive/" + rev + ".tar.gz";
        }

        public String archive$default$1() {
            return "tip";
        }

        public String read_changeset(String rev) {
            return Url$.MODULE$.read(this.changeset(rev, true));
        }

        public String read_changeset$default$1() {
            return "tip";
        }

        public String read_file(Path path, String rev) {
            return Url$.MODULE$.read(this.file(path, rev, true));
        }

        public String read_file$default$2() {
            return "tip";
        }

        public HTTP.Content download_archive(String rev, Progress progress) {
            return Isabelle_System$.MODULE$.download(this.archive(rev), progress);
        }

        public String download_archive$default$1() {
            return "tip";
        }

        public Progress download_archive$default$2() {
            return new Progress();
        }

        public void download_dir(Path dir, String rev, Progress progress) {
            Isabelle_System$.MODULE$.new_directory(dir);
            Isabelle_System$.MODULE$.with_tmp_file("rev", ".tar.gz", Isabelle_System$.MODULE$.with_tmp_file$default$3(), (Function1 & Serializable)archive_path -> {
                HTTP.Content content = this.download_archive(rev, progress);
                Bytes$.MODULE$.write((Path)archive_path, content.bytes());
                progress.echo("Unpacking " + rev + ".tar.gz", progress.echo$default$2());
                return Isabelle_System$.MODULE$.gnutar("-xzf " + File$.MODULE$.bash_path((Path)archive_path), dir, true, true, Isabelle_System$.MODULE$.gnutar$default$5()).check();
            });
        }

        public String download_dir$default$2() {
            return "tip";
        }

        public Progress download_dir$default$3() {
            return new Progress();
        }
    }
}

