/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.File$;
import isabelle.Isabelle_System$;
import isabelle.Linux$Release$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.SSH;
import isabelle.package$;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Pattern;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Linux$
implements Serializable {
    public static final Linux$Release$ Release;
    public static final Linux$ MODULE$;

    private Linux$() {
    }

    static {
        MODULE$ = new Linux$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Linux$.class);
    }

    public void check_system() {
        if (!Platform$.MODULE$.is_linux()) {
            package$.MODULE$.error().apply((Object)"Not a Linux system");
            return;
        }
    }

    public void check_system_root() {
        this.check_system();
        String string = Isabelle_System$.MODULE$.bash("id -u", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check().out();
        String string2 = "0";
        if (string == null ? string2 != null : !string.equals(string2)) {
            package$.MODULE$.error().apply((Object)"Not running as superuser (root)");
            return;
        }
    }

    public boolean reboot_required() {
        return Path$.MODULE$.explode("/var/run/reboot-required").is_file();
    }

    public void check_reboot_required() {
        if (this.reboot_required()) {
            package$.MODULE$.error().apply((Object)"Reboot required");
            return;
        }
    }

    public void package_update(Progress progress) {
        progress.bash("apt-get update -y && apt-get upgrade -y && apt autoremove -y", progress.bash$default$2(), progress.bash$default$3(), progress.bash$default$4(), progress.bash$default$5(), true, progress.bash$default$7(), progress.bash$default$8()).check();
    }

    public Progress package_update$default$1() {
        return new Progress();
    }

    public void package_install(List<String> packages, Progress progress) {
        String string = "apt-get install -y -- " + Bash$.MODULE$.strings((Iterable<String>)packages);
        SSH.System system = progress.bash$default$2();
        Path path = progress.bash$default$3();
        Map<String, String> map = progress.bash$default$4();
        boolean bl = progress.bash$default$5();
        long l = progress.bash$default$7();
        boolean bl2 = progress.bash$default$8();
        progress.bash(string, system, path, map, bl, true, l, bl2).check();
    }

    public Progress package_install$default$2() {
        return new Progress();
    }

    public boolean package_installed(String name) {
        Process_Result result = Isabelle_System$.MODULE$.bash("dpkg-query -s " + Bash$.MODULE$.string(name), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12());
        Pattern pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^Status:.*installed.*$")).pattern();
        return result.ok() && result.out_lines().exists((Function1 & Serializable)line -> pattern.matcher((CharSequence)line).matches());
    }

    public boolean user_exists(String name) {
        return Isabelle_System$.MODULE$.bash("id " + Bash$.MODULE$.string(name), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).ok();
    }

    public String user_entry(String name, int field) {
        Process_Result result = Isabelle_System$.MODULE$.bash("getent passwd " + Bash$.MODULE$.string(name), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
        List fields = (List)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)':'), (Object)result.out());
        if (1 <= field && field <= fields.length()) {
            return (String)fields.apply(field - 1);
        }
        return (String)package$.MODULE$.error().apply((Object)("No passwd field " + field + " for user " + package$.MODULE$.quote().apply((Object)name)));
    }

    public String user_description(String name) {
        return StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(this.user_entry(name, 5)), (Function1 & Serializable)_$1 -> Linux$.user_description$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)));
    }

    public String user_home(String name) {
        return this.user_entry(name, 6);
    }

    public void user_add(String name, String description, boolean system, boolean ssh_setup) {
        Predef$.MODULE$.require(!StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(description), ','), Linux$::user_add$$anonfun$1);
        if (this.user_exists(name)) {
            package$.MODULE$.error().apply((Object)("User already exists: " + package$.MODULE$.quote().apply((Object)name)));
        }
        Isabelle_System$.MODULE$.bash("adduser --quiet --disabled-password --gecos " + Bash$.MODULE$.string(description) + " --home /home/" + Bash$.MODULE$.string(name) + (system ? " --system --group --shell /bin/bash " : "") + " " + Bash$.MODULE$.string(name), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
        Isabelle_System$.MODULE$.bash("usermod -p '*' " + Bash$.MODULE$.string(name), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
        if (ssh_setup) {
            String id_rsa = this.user_home(name) + "/.ssh/id_rsa";
            Isabelle_System$.MODULE$.bash("\nif [ ! -f " + Bash$.MODULE$.string(id_rsa) + " ]\nthen\n  yes '\\n' | sudo -i -u " + Bash$.MODULE$.string(name) + " ssh-keygen -q -f " + Bash$.MODULE$.string(id_rsa) + "\nfi\n      ", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
            return;
        }
    }

    public String user_add$default$2() {
        return "";
    }

    public boolean user_add$default$3() {
        return false;
    }

    public boolean user_add$default$4() {
        return false;
    }

    public void service_operation(String op, String name) {
        Isabelle_System$.MODULE$.bash("systemctl " + Bash$.MODULE$.string(op) + " " + Bash$.MODULE$.string(name), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check();
    }

    public void service_enable(String name) {
        this.service_operation("enable", name);
    }

    public void service_disable(String name) {
        this.service_operation("disable", name);
    }

    public void service_start(String name) {
        this.service_operation("start", name);
    }

    public void service_stop(String name) {
        this.service_operation("stop", name);
    }

    public void service_restart(String name) {
        this.service_operation("restart", name);
    }

    public void service_shutdown(String name) {
        try {
            this.service_stop(name);
        }
        catch (Throwable throwable) {
            Option<String> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = package$.MODULE$.ERROR().unapply(throwable2)).isEmpty()) {
                String string = (String)option.get();
            }
            throw throwable;
        }
    }

    public void service_install(String name, String spec) {
        this.service_shutdown(name);
        Path service_file = Path$.MODULE$.explode("/lib/systemd/system").$plus(Path$.MODULE$.basic(name).ext("service"));
        File$.MODULE$.write(service_file, spec);
        Isabelle_System$.MODULE$.chmod("644", service_file);
        this.service_enable(name);
        this.service_restart(name);
    }

    public String generate_password(int length) {
        Predef$.MODULE$.require(length >= 6, Linux$::generate_password$$anonfun$1);
        return Isabelle_System$.MODULE$.bash("pwgen " + length + " 1", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check().out();
    }

    public int generate_password$default$1() {
        return 10;
    }

    public String php_version() {
        return Isabelle_System$.MODULE$.bash("php --run 'echo PHP_MAJOR_VERSION . \".\" . PHP_MINOR_VERSION;'", Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9(), Isabelle_System$.MODULE$.bash$default$10(), Isabelle_System$.MODULE$.bash$default$11(), Isabelle_System$.MODULE$.bash$default$12()).check().out();
    }

    public Path php_conf_dir(String name) {
        return Path$.MODULE$.explode("/etc/php").$plus(Path$.MODULE$.basic(this.php_version())).$plus(Path$.MODULE$.basic(name)).$plus(Path$.MODULE$.explode("conf.d"));
    }

    public static final String isabelle$Linux$Release$$$_$find$1$$anonfun$1() {
        return "Unknown";
    }

    private static final /* synthetic */ boolean user_description$$anonfun$1(char _$1) {
        return _$1 != ',';
    }

    private static final Object user_add$$anonfun$1() {
        return "malformed description";
    }

    private static final Object generate_password$$anonfun$1() {
        return "password too short";
    }
}

