/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Event;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

class rfbProto {
    final String versionMsg = "RFB 003.003\n";
    final int ConnFailed = 0;
    final int NoAuth = 1;
    final int VncAuth = 2;
    final int VncAuthOK = 0;
    final int VncAuthFailed = 1;
    final int VncAuthTooMany = 2;
    final int FramebufferUpdate = 0;
    final int SetColourMapEntries = 1;
    final int Bell = 2;
    final int ServerCutText = 3;
    final int SetPixelFormat = 0;
    final int FixColourMapEntries = 1;
    final int SetEncodings = 2;
    final int FramebufferUpdateRequest = 3;
    final int KeyEvent = 4;
    final int PointerEvent = 5;
    final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    final int HextileRaw = 1;
    final int HextileBackgroundSpecified = 2;
    final int HextileForegroundSpecified = 4;
    final int HextileAnySubrects = 8;
    final int HextileSubrectsColoured = 16;
    String host;
    int port;
    Socket sock;
    DataInputStream is;
    OutputStream os;
    boolean inNormalProtocol = false;
    vncviewer v;
    int serverMajor;
    int serverMinor;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    int pointerMask;
    int oldModifiers;

    rfbProto(String string, int n, vncviewer vncviewer2) throws IOException {
        this.v = vncviewer2;
        this.host = string;
        this.port = n;
        this.sock = new Socket(this.host, this.port);
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
    }

    void close() {
        try {
            this.sock.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void readVersionMsg() throws IOException {
        byte[] byArray = new byte[12];
        this.is.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new IOException("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.serverMinor = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
    }

    void writeVersionMsg() throws IOException {
        byte[] byArray = new byte[12];
        "RFB 003.003\n".getBytes(0, 12, byArray, 0);
        this.os.write(byArray);
    }

    int readAuthScheme() throws IOException {
        int n = this.is.readInt();
        switch (n) {
            case 0: {
                int n2 = this.is.readInt();
                byte[] byArray = new byte[n2];
                this.is.readFully(byArray);
                throw new IOException(new String(byArray, 0));
            }
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new IOException("Unknown authentication scheme from RFB server " + n);
    }

    void writeClientInit() throws IOException {
        if (this.v.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.v.options.disableShareDesktop();
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] byArray = new byte[3];
        this.is.read(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        this.desktopName = new String(byArray2, 0);
        this.inNormalProtocol = true;
    }

    int readServerMessageType() throws IOException {
        return this.is.read();
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
    }

    void readFramebufferUpdateRectHdr() throws IOException {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new IOException("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
    }

    String readServerCutText() throws IOException {
        byte[] byArray = new byte[3];
        this.is.read(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        return new String(byArray2, 0);
    }

    void writeFramebufferUpdateRequest(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        byte[] byArray = new byte[]{3, (byte)(bl ? 1 : 0), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)};
        this.os.write(byArray);
    }

    void writeSetPixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        byte[] byArray = new byte[20];
        byArray[0] = 0;
        byArray[4] = (byte)n;
        byArray[5] = (byte)n2;
        byArray[6] = (byte)(bl ? 1 : 0);
        byArray[7] = (byte)(bl2 ? 1 : 0);
        byArray[8] = (byte)(n3 >> 8 & 0xFF);
        byArray[9] = (byte)(n3 & 0xFF);
        byArray[10] = (byte)(n4 >> 8 & 0xFF);
        byArray[11] = (byte)(n4 & 0xFF);
        byArray[12] = (byte)(n5 >> 8 & 0xFF);
        byArray[13] = (byte)(n5 & 0xFF);
        byArray[14] = (byte)n6;
        byArray[15] = (byte)n7;
        byArray[16] = (byte)n8;
        this.os.write(byArray);
    }

    void writeFixColourMapEntries(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        byte[] byArray = new byte[6 + n2 * 6];
        byArray[0] = 1;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = (byte)(n2 >> 8 & 0xFF);
        byArray[5] = (byte)(n2 & 0xFF);
        int n3 = 0;
        while (n3 < n2) {
            byArray[6 + n3 * 6] = (byte)(nArray[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 1] = (byte)(nArray[n3] & 0xFF);
            byArray[6 + n3 * 6 + 2] = (byte)(nArray2[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 3] = (byte)(nArray2[n3] & 0xFF);
            byArray[6 + n3 * 6 + 4] = (byte)(nArray3[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 5] = (byte)(nArray3[n3] & 0xFF);
            ++n3;
        }
        this.os.write(byArray);
    }

    void writeSetEncodings(int[] nArray, int n) throws IOException {
        byte[] byArray = new byte[4 + 4 * n];
        byArray[0] = 2;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        int n2 = 0;
        while (n2 < n) {
            byArray[4 + 4 * n2] = (byte)(nArray[n2] >> 24 & 0xFF);
            byArray[5 + 4 * n2] = (byte)(nArray[n2] >> 16 & 0xFF);
            byArray[6 + 4 * n2] = (byte)(nArray[n2] >> 9 & 0xFF);
            byArray[7 + 4 * n2] = (byte)(nArray[n2] & 0xFF);
            ++n2;
        }
        this.os.write(byArray);
    }

    void writeClientCutText(String string) throws IOException {
        byte[] byArray = new byte[8 + string.length()];
        byArray[0] = 6;
        byArray[4] = (byte)(string.length() >> 24 & 0xFF);
        byArray[5] = (byte)(string.length() >> 16 & 0xFF);
        byArray[6] = (byte)(string.length() >> 8 & 0xFF);
        byArray[7] = (byte)(string.length() & 0xFF);
        string.getBytes(0, string.length(), byArray, 8);
        this.os.write(byArray);
    }

    void writePointerEvent(Event event) throws IOException {
        if (event.id == 501) {
            this.pointerMask = 1;
            if ((event.modifiers & 8) != 0) {
                this.pointerMask = this.v.options.reverseMouseButtons2And3 ? 4 : 2;
            }
            if ((event.modifiers & 4) != 0) {
                this.pointerMask = this.v.options.reverseMouseButtons2And3 ? 2 : 4;
            }
        } else if (event.id == 502) {
            this.pointerMask = 0;
        }
        event.modifiers &= 0xFFFFFFF3;
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(event.modifiers);
        if (event.x < 0) {
            event.x = 0;
        }
        if (event.y < 0) {
            event.y = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(event.x >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(event.x & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(event.y >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(event.y & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    void writeKeyEvent(Event var1_1) throws IOException {
        block32: {
            block33: {
                block31: {
                    var2_2 = var1_1.key;
                    var3_3 = false;
                    if (var1_1.id == 401 || var1_1.id == 403) {
                        var3_3 = true;
                    }
                    if (var1_1.id != 403 && var1_1.id != 404) break block31;
                    switch (var2_2) {
                        case 1000: {
                            var2_2 = 65360;
                            break block32;
                        }
                        case 1006: {
                            var2_2 = 65361;
                            break block32;
                        }
                        case 1004: {
                            var2_2 = 65362;
                            break block32;
                        }
                        case 1007: {
                            var2_2 = 65363;
                            break block32;
                        }
                        case 1005: {
                            var2_2 = 65364;
                            break block32;
                        }
                        case 1002: {
                            var2_2 = 65365;
                            break block32;
                        }
                        case 1003: {
                            var2_2 = 65366;
                            break block32;
                        }
                        case 1001: {
                            var2_2 = 65367;
                            break block32;
                        }
                        case 1008: {
                            var2_2 = 65470;
                            break block32;
                        }
                        case 1009: {
                            var2_2 = 65471;
                            break block32;
                        }
                        case 1010: {
                            var2_2 = 65472;
                            break block32;
                        }
                        case 1011: {
                            var2_2 = 65473;
                            break block32;
                        }
                        case 1012: {
                            var2_2 = 65474;
                            break block32;
                        }
                        case 1013: {
                            var2_2 = 65475;
                            break block32;
                        }
                        case 1014: {
                            var2_2 = 65476;
                            break block32;
                        }
                        case 1015: {
                            var2_2 = 65477;
                            break block32;
                        }
                        case 1016: {
                            var2_2 = 65478;
                            break block32;
                        }
                        case 1017: {
                            var2_2 = 65479;
                            break block32;
                        }
                        case 1018: {
                            var2_2 = 65480;
                            break block32;
                        }
                        case 1019: {
                            var2_2 = 65481;
                            break block32;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (var2_2 >= 32) ** GOTO lbl88
                if ((var1_1.modifiers & 2) == 0) break block33;
                var2_2 += 96;
                break block32;
            }
            switch (var2_2) {
                case 8: {
                    var2_2 = 65288;
                    break;
                }
                case 9: {
                    var2_2 = 65289;
                    break;
                }
                case 10: {
                    var2_2 = 65293;
                    break;
                }
                case 27: {
                    var2_2 = 65307;
                    break;
                }
lbl88:
                // 1 sources

                if (var2_2 < 127) break;
                if (var2_2 == 127) {
                    var2_2 = 65535;
                    break;
                }
                if (var2_2 >= 65280 && var2_2 <= 65535) break;
                return;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(var1_1.modifiers);
        this.writeKeyEvent(var2_2, var3_3);
        if (!var3_3) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(int n, boolean bl) throws IOException {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(bl ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n & 0xFF);
    }

    void writeModifierKeyEvents(int n) throws IOException {
        if ((n & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (n & 2) != 0);
        }
        if ((n & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (n & 1) != 0);
        }
        if ((n & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (n & 4) != 0);
        }
        if ((n & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (n & 8) != 0);
        }
        this.oldModifiers = n;
    }
}

