/*
 * translate.c - translate between different pixel formats
 */

/*
 *  Copyright (C) 1997, 1998 Olivetti & Oracle Research Laboratory
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "stdhdrs.h"

#include "translate.h"
#include <stdio.h>
#include "rfb.h"

#define CONCAT2(a,b) a##b
#define CONCAT2E(a,b) CONCAT2(a,b)
#define CONCAT4(a,b,c,d) a##b##c##d
#define CONCAT4E(a,b,c,d) CONCAT4(a,b,c,d)

#define OUT 8
#include "tableinittctemplate.cpp"
#include "tableinitcmtemplate.cpp"
#define IN 8
#include "tabletranstemplate.cpp"
#undef IN
#define IN 16
#include "tabletranstemplate.cpp"
#undef IN
#define IN 32
#include "tabletranstemplate.cpp"
#undef IN
#undef OUT

#define OUT 16
#include "tableinittctemplate.cpp"
#include "tableinitcmtemplate.cpp"
#define IN 8
#include "tabletranstemplate.cpp"
#undef IN
#define IN 16
#include "tabletranstemplate.cpp"
#undef IN
#define IN 32
#include "tabletranstemplate.cpp"
#undef IN
#undef OUT

#define OUT 32
#include "tableinittctemplate.cpp"
#include "tableinitcmtemplate.cpp"
#define IN 8
#include "tabletranstemplate.cpp"
#undef IN
#define IN 16
#include "tabletranstemplate.cpp"
#undef IN
#define IN 32
#include "tabletranstemplate.cpp"
#undef IN
#undef OUT

rfbInitTableFnType rfbInitTrueColourSingleTableFns[3] = {
    rfbInitTrueColourSingleTable8,
    rfbInitTrueColourSingleTable16,
    rfbInitTrueColourSingleTable32
};

rfbInitTableFnType rfbInitColourMapSingleTableFns[3] = {
    rfbInitColourMapSingleTable8,
    rfbInitColourMapSingleTable16,
    rfbInitColourMapSingleTable32
};

rfbInitTableFnType rfbInitTrueColourRGBTablesFns[3] = {
    rfbInitTrueColourRGBTables8,
    rfbInitTrueColourRGBTables16,
    rfbInitTrueColourRGBTables32
};

rfbTranslateFnType rfbTranslateWithSingleTableFns[3][3] = {
    { rfbTranslateWithSingleTable8to8,
      rfbTranslateWithSingleTable8to16,
      rfbTranslateWithSingleTable8to32 },
    { rfbTranslateWithSingleTable16to8,
      rfbTranslateWithSingleTable16to16,
      rfbTranslateWithSingleTable16to32 },
    { rfbTranslateWithSingleTable32to8,
      rfbTranslateWithSingleTable32to16,
      rfbTranslateWithSingleTable32to32 }
};

rfbTranslateFnType rfbTranslateWithRGBTablesFns[3][3] = {
    { rfbTranslateWithRGBTables8to8,
      rfbTranslateWithRGBTables8to16,
      rfbTranslateWithRGBTables8to32 },
    { rfbTranslateWithRGBTables16to8,
      rfbTranslateWithRGBTables16to16,
      rfbTranslateWithRGBTables16to32 },
    { rfbTranslateWithRGBTables32to8,
      rfbTranslateWithRGBTables32to16,
      rfbTranslateWithRGBTables32to32 }
};



// rfbTranslateNone is used when no translation is required.

void
rfbTranslateNone(char *table, rfbPixelFormat *in, rfbPixelFormat *out,
		 char *iptr, char *optr, int bytesBetweenInputLines,
		 int width, int height)
{
    int bytesPerOutputLine = width * (out->bitsPerPixel / 8);

    while (height > 0) {
	memcpy(optr, iptr, bytesPerOutputLine);
	iptr += bytesBetweenInputLines;
	optr += bytesPerOutputLine;
	height--;
    }
}

// **** OBSOLETE CODE ****

/*
 * rfbSetTranslateFunction sets the translation function.
 */

#if 0
BOOL
rfbSetTranslateFunction(cl)
    rfbClientPtr cl;
{
    rfbLog("Pixel format for client %s:\n",cl->host);
    PrintPixelFormat(&cl->format);

    /*
     * Check that bits per pixel values are valid
     */

    if ((rfbServerFormat.bitsPerPixel != 8) &&
	(rfbServerFormat.bitsPerPixel != 16) &&
	(rfbServerFormat.bitsPerPixel != 32))
    {
	rfbLog("%s: server bits per pixel not 8, 16 or 32\n",
		"rfbSetTranslateFunction");
	rfbCloseSock(cl->sock);
	return FALSE;
    }

    if ((cl->format.bitsPerPixel != 8) &&
	(cl->format.bitsPerPixel != 16) &&
	(cl->format.bitsPerPixel != 32))
    {
	rfbLog("%s: client bits per pixel not 8, 16 or 32\n",
		"rfbSetTranslateFunction");
	rfbCloseSock(cl->sock);
	return FALSE;
    }

    if (!rfbServerFormat.trueColour && (rfbServerFormat.bitsPerPixel != 8)) {
	rfbLog("rfbSetTranslateFunction: server has colour map "
		"but %d-bit - can only cope with 8-bit colour maps\n",
		rfbServerFormat.bitsPerPixel);
	rfbCloseSock(cl->sock);
	return FALSE;
    }

    if (!cl->format.trueColour && (cl->format.bitsPerPixel != 8)) {
	rfbLog("rfbSetTranslateFunction: client has colour map "
		"but %d-bit - can only cope with 8-bit colour maps\n",
		cl->format.bitsPerPixel);
	rfbCloseSock(cl->sock);
	return FALSE;
    }

    /*
     * bpp is valid, now work out how to translate
     */

    if (!cl->format.trueColour) {

	/* ? -> colour map */

	if (!rfbServerFormat.trueColour) {

	    /* colour map -> colour map */

	    rfbLog("rfbSetTranslateFunction: both 8-bit colour map: "
		    "no translation needed\n");
	    cl->translateFn = rfbTranslateNone;
	    return rfbSetClientColourMap(cl, 0, 0);
	}

	/*
	 * truecolour -> colour map
	 *
	 * Set client's colour map to BGR233, then effectively it's
	 * truecolour as well
	 */

	if (!rfbSetClientColourMapBGR233(cl))
	    return FALSE;

	cl->format = BGR233Format;
    }

    /* ? -> truecolour */

    if (!rfbServerFormat.trueColour) {

	/* colour map -> truecolour */

	rfbLog("rfbSetTranslateFunction: client is %d-bit trueColour,"
		" server has colour map\n",cl->format.bitsPerPixel);

	cl->translateFn = rfbTranslateWithSingleTableFns
			      [rfbServerFormat.bitsPerPixel / 16]
				  [cl->format.bitsPerPixel / 16];

	return rfbSetClientColourMap(cl, 0, 0);
    }

    /* truecolour -> truecolour */

    if (PF_EQ(cl->format,rfbServerFormat)) {

	/* client & server the same */

	rfbLog("no translation needed\n");
	cl->translateFn = rfbTranslateNone;
	return TRUE;
    }

    if (rfbServerFormat.bitsPerPixel <= 16) {

	/* we can use a single lookup table for <= 16 bpp */

	cl->translateFn = rfbTranslateWithSingleTableFns
			      [rfbServerFormat.bitsPerPixel / 16]
				  [cl->format.bitsPerPixel / 16];

	(*rfbInitTrueColourSingleTableFns
	    [cl->format.bitsPerPixel / 16]) (&cl->translateLookupTable,
					     &rfbServerFormat, &cl->format);

    } else {

	/* otherwise we use three separate tables for red, green and blue */

	cl->translateFn = rfbTranslateWithRGBTablesFns
			      [rfbServerFormat.bitsPerPixel / 16]
				  [cl->format.bitsPerPixel / 16];

	(*rfbInitTrueColourRGBTablesFns
	    [cl->format.bitsPerPixel / 16]) (&cl->translateLookupTable,
					     &rfbServerFormat, &cl->format);
    }

    return TRUE;
}
#endif // ***
