//  Copyright (C) 1997, 1998 Olivetti & Oracle Research Laboratory
//
//  This file is part of the VNC system.
//
//  The VNC system is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//  USA.
//
// If the source code for the VNC system is not available from the place 
// whence you received this file, check http://www.orl.co.uk/vnc or contact
// the authors on vnc@orl.co.uk for information on obtaining it.


// vncService

// SERVICE-MODE CODE

// This class provides access to service-oriented routines, under both
// Windows NT and Windows 95.  Some routines only operate under one
// OS, others operate under any OS.

class vncService;

#if (!defined(_WINVNC_VNCSERVICE))
#define _WINVNC_VNCSERVICE

#include "stdhdrs.h"

// The NT-specific code wrapper class
class vncService
{
public:
	vncService();

	// SERVICE INSTALL & START FUNCTIONS

	// Routine called by WinMain to cause WinVNC to be installed
	// as a service.
	static int WinVNCServiceMain();

	// Routine to install the WinVNC service on the local machine
	static int InstallService();

	// Routine to remove the WinVNC service from the local machine
	static int RemoveService();

	// SERVICE SUPPORT FUNCTIONS

	// Routines to establish which OS we're running on
	static BOOL IsWin95();
	static BOOL IsWinNT();

	// Routine to establish whether the current instance is running
	// as a service or not
	static BOOL RunningAsService();

	// Routine to kill any other running copy of WinVNC
	static BOOL KillRunningCopy();

	// Routine to set the current thread into the name desktop,
	// or the input desktop if no name is given
	static BOOL SelectDesktop(char *name);

	// Routine to establish whether the current thread desktop is the
	// current user input one
	static BOOL InputDesktopSelected();

	// Routine to fake a CtrlAltDel to winlogon when required.
	// *** This is a nasty little hack...
	static BOOL SimulateCtrlAltDel();

	// Routine to make any currently running version of WinVNC show its
	// Properties dialog, to allow the user to make changes
	static BOOL ShowProperties();

	// Routine to make the an already running copy of WinVNC bring up its
	// About box so you can check the version!
	static BOOL ShowAboutBox();
};

#endif