//  Copyright (C) 1997, 1998 Olivetti & Oracle Research Laboratory
//
//  This file is part of the VNC system.
//
//  The VNC system is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//  USA.
//
// If the source code for the VNC system is not available from the place 
// whence you received this file, check http://www.orl.co.uk/vnc or contact
// the authors on vnc@orl.co.uk for information on obtaining it.


#pragma once

#include "stdhdrs.h"
#include "omnithread.h"
#include "VNCOptions.h"
#include "KeyMap.h"

class ClientConnection  : public omni_thread
{
public:
	ClientConnection();
	ClientConnection(SOCKET sock);
	ClientConnection(char *host, int port);
	virtual ~ClientConnection();
	void Run();
	void Kill(bool closeWindow = true);
	static LRESULT CALLBACK WndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam);
	// void DoBlit(int x, int y, int w, int h) ;
	void DoBlit();
	int m_port;
	char m_host[256];
	SOCKET m_sock;
	HWND m_hwnd;
protected:
	void Init();
	void Connect();
	void SetSocketOptions();
	void Authenticate();
	void NegotiateProtocolVersion();
	void ReadServerInit();
	void SendClientInit();
	void CreateLocalFramebuffer();
	void SetupPixelFormat();
	void SetFormatAndEncodings();
	void SendIncrementalFramebufferUpdateRequest();
	void SendFullFramebufferUpdateRequest();
	void SendFramebufferUpdateRequest(int x, int y, int w, int h, bool incremental);
	void SendSetPixelFormat(rfbPixelFormat newFormat);
	void SendPointerEvent(int x, int y, int buttonMask);
    void ProcessKeyEvent(int virtkey, DWORD keyData);
	void SendKeyEvent(CARD32 key, bool down);
    void SendCtlAltDel();
	void SendClientCutText(char *str, int len);
	void ScreenUpdate();
	void Update(RECT *pRect);
	void UpdateScrollbars();
    void RawRect(rfbFramebufferUpdateRectHeader *pfburh);
	void CopyRect(rfbFramebufferUpdateRectHeader *pfburh);
    void RRERect(rfbFramebufferUpdateRectHeader *pfburh);
	void CoRRERect(rfbFramebufferUpdateRectHeader *pfburh);
	void HextileRect(rfbFramebufferUpdateRectHeader *pfburh);
	void HandleHextileEncoding8(int x, int y, int w, int h);
	void HandleHextileEncoding16(int x, int y, int w, int h);
	void HandleHextileEncoding32(int x, int y, int w, int h);
	void RBSRect(rfbFramebufferUpdateRectHeader *pfburh);
	BOOL DrawRBSRect8(int x, int y, int w, int h, CARD8 **pptr);
	BOOL DrawRBSRect16(int x, int y, int w, int h, CARD8 **pptr);
	BOOL DrawRBSRect32(int x, int y, int w, int h, CARD8 **pptr);
	void ServerCutText();
	void Bell();
	void SendRFBMsg(CARD8 msgType, void* data, int length);
	void ReadExact(char *buf, int bytes);
	void ReadString(char *buf, int length);
	void WriteExact(char *buf, int bytes);

	// This is what controls the thread
	void * run_undetached(void* arg);
	bool bKillThread;

	// Utilities
	void FillSolidRect(RECT *pRect, COLORREF color);
	void FillSolidRect(int x, int y, int w, int h, COLORREF color);
    // how many other windows are owned by this process?
    unsigned int CountProcessOtherWindows();

    // Buffer for network operations
	void CheckBufferSize(int bufsize);
	char *netbuf;
	int netbufsize;
	omni_mutex bufferMutex, bitmapdcMutex, sockMutex, 
        readMutex, writeMutex, clipMutex;

	// Bitmap for local copy of screen, and DC for writing to it.
	HBITMAP hBitmap;
	HDC hBitmapDC;

	// Keyboard mapper
	KeyMap keymap;

	// RFB settings
	VNCOptions opts;
	char *desktopName;
	rfbServerInitMsg si;
	rfbPixelFormat myFormat, pendingFormat;
	// protocol version in use.
	int major, minor;
	bool threadStarted, running;
	// mid-connection format change requested
	bool pendingFormatChange;
	// Display connection info;
	void ShowConnInfo();

	// Window may be scrollable - these control the scroll position
	int hScrollPos, hScrollMax, vScrollPos, vScrollMax;
	// The current window size
	int winwidth, winheight;
	// The size of the current client area
	int cliwidth, cliheight;
	// The size of a window needed to hold entire screen without scrollbars
	int fullwinwidth, fullwinheight;

	// *** > JNW
	ULONG m_cmdShow;
	// *** <

	// Shortcuts for speed's sake
	// Quick references to the color info
	CARD16 rs,gs,bs,rm,gm,bm; 	
    // The number of bytes required to hold at least one pixel.
	unsigned int minPixelBytes;
	// Next window in clipboard chain
	HWND hwndNextViewer; 
		
};

