/*

Copyright (C) 1993-1996 Olivetti Research Limited, Cambridge, England.

THERE IS NO WARRANTY FOR THIS SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE
LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR
OTHER PARTIES PROVIDE THIS SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  NO
GUARANTEE IS MADE THAT THIS SOFTWARE IS FREE OF SOFTWARE VIRUSES.  THE ENTIRE
RISK AS TO THE QUALITY AND PERFORMANCE OF THIS SOFTWARE IS WITH YOU.  SHOULD
THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY
COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THIS
SOFTWARE AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
INABILITY TO USE THIS SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR
DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THIS SOFTWARE TO OPERATE WITH ANY OTHER SYSTEMS), EVEN IF SUCH
HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*/

/*
 * wish-tp.c
 */

#include <stdio.h>
#include <string.h>
#include <X11/Xatom.h>
#include <tk.h>

#if (TCL_MAJOR_VERSION == 7) && (TCL_MINOR_VERSION < 4)
extern int main();
int *tclDummyMainPtr = (int *) main;
#else
int main(argc, argv)
    int argc;
    char **argv;
{
    Tk_Main(argc, argv, Tcl_AppInit);
    return 0;
}
#endif

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;
{
    char str[20];

    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tp_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    return TCL_OK;
}


static int EventHandler();
static int GetPhysicalDisplay();
static int GetViewportSize();
static char *RewritePhysicalDisplay();
static char *RewriteViewportWidth();
static char *RewriteViewportHeight();

static Atom atom_ORL_TP_PHYSICAL_DISPLAY, atom_ORL_TP_VIEWPORT_SIZE;

typedef struct {
    Tcl_Interp *interp;
    Display *dpy;
    char *physDisplayName;
    int viewportWidth, viewportHeight;
} TpInfo;


int Tp_Init(interp)
    Tcl_Interp *interp;
{
    Tk_Window tkwin;
    TpInfo *ti;

    tkwin = Tk_MainWindow(interp);

    ti = (TpInfo *)malloc(sizeof(TpInfo));
    if (!ti) { fprintf(stderr,"tp: malloc failed\n"); exit(1); }
    ti->interp = interp;
    ti->dpy = Tk_Display(tkwin);
    ti->physDisplayName = NULL;
    ti->viewportWidth = ti->viewportHeight = 0;

    Tk_CreateGenericHandler(EventHandler, (ClientData)ti);

    XSelectInput(ti->dpy, DefaultRootWindow(ti->dpy), PropertyChangeMask);

    atom_ORL_TP_PHYSICAL_DISPLAY = XInternAtom(ti->dpy, "_ORL_TP_PHYSICAL_DISPLAY", 0);
    atom_ORL_TP_VIEWPORT_SIZE = XInternAtom(ti->dpy, "_ORL_TP_VIEWPORT_SIZE", 0);

    if (GetPhysicalDisplay(ti)) {
	Tcl_TraceVar(interp, "tp_physical_display", TCL_TRACE_WRITES,
		     RewritePhysicalDisplay, (ClientData)ti);
    }
    if (GetViewportSize(ti)) {
	Tcl_TraceVar(interp, "tp_viewport_width", TCL_TRACE_WRITES,
		     RewriteViewportWidth, (ClientData)ti);
	Tcl_TraceVar(interp, "tp_viewport_height", TCL_TRACE_WRITES,
		     RewriteViewportHeight, (ClientData)ti);
    }

    return TCL_OK;
}


static int EventHandler(cd, event)
    ClientData cd;
    XEvent *event;
{
    TpInfo *ti = (TpInfo *)cd;
    int result;

    if ((event->type == PropertyNotify) && (event->xproperty.window == DefaultRootWindow(ti->dpy))
	&& (event->xproperty.atom == atom_ORL_TP_PHYSICAL_DISPLAY))
    {
	GetPhysicalDisplay(ti);
	return 1;
    }

    if ((event->type == PropertyNotify) && (event->xproperty.window == DefaultRootWindow(ti->dpy))
	&& (event->xproperty.atom == atom_ORL_TP_VIEWPORT_SIZE))
    {
	GetViewportSize(ti);
	return 1;
    }

    return 0;
}


static int GetPhysicalDisplay(ti)
    TpInfo *ti;
{
    Atom actualType;
    int format;
    unsigned long nItems, bytesAfter;
    unsigned char *data;

    if (ti->physDisplayName) {
	XFree(ti->physDisplayName);
	ti->physDisplayName = NULL;
    }

    if (XGetWindowProperty(ti->dpy, DefaultRootWindow(ti->dpy),
			   atom_ORL_TP_PHYSICAL_DISPLAY, 0, 1024,
			   False, XA_STRING, &actualType, &format, &nItems,
			   &bytesAfter, (unsigned char **)&ti->physDisplayName) == Success)
    {
	if ((actualType == XA_STRING) && (format == 8)) {
	    Tcl_SetVar(ti->interp, "tp_physical_display", ti->physDisplayName, TCL_GLOBAL_ONLY);
	    return 1;
	}
    }
    return 0;
}


static int GetViewportSize(ti)
    TpInfo *ti;
{
    Atom actualType;
    int format;
    unsigned long nItems, bytesAfter;
    unsigned char *data;
    char str[20];

    if (XGetWindowProperty(ti->dpy, DefaultRootWindow(ti->dpy),
			   atom_ORL_TP_VIEWPORT_SIZE, 0, 2,
			   False, XA_INTEGER, &actualType, &format, &nItems,
			   &bytesAfter, &data) == Success)
    {
	if ((actualType == XA_INTEGER) && (format == 32) && (nItems == 2)) {
	    ti->viewportWidth = ((long *)data)[0];
	    ti->viewportHeight = ((long *)data)[1];
	    XFree(data);

	    sprintf(str, "%ld", ti->viewportWidth);
	    Tcl_SetVar(ti->interp, "tp_viewport_width", str, TCL_GLOBAL_ONLY);

	    sprintf(str, "%ld", ti->viewportHeight);
	    Tcl_SetVar(ti->interp, "tp_viewport_height", str, TCL_GLOBAL_ONLY);

	    return 1;
	}
    }
    return 0;
}


static char *RewritePhysicalDisplay(cd, interp, name1, name2, flags)
    ClientData cd;
    Tcl_Interp interp;
    char *name1;
    char *name2;
    int flags;
{
    TpInfo *ti = (TpInfo *)cd;

    Tcl_SetVar(ti->interp, "tp_physical_display", ti->physDisplayName, flags & TCL_GLOBAL_ONLY);
    return "variable is read-only";
}

static char *RewriteViewportWidth(cd, interp, name1, name2, flags)
    ClientData cd;
    Tcl_Interp interp;
    char *name1;
    char *name2;
    int flags;
{
    TpInfo *ti = (TpInfo *)cd;
    char str[20];

    sprintf(str, "%ld", ti->viewportWidth);
    Tcl_SetVar(ti->interp, "tp_viewport_width", str, flags & TCL_GLOBAL_ONLY);
    return "variable is read-only";
}

static char *RewriteViewportHeight(cd, interp, name1, name2, flags)
    ClientData cd;
    Tcl_Interp interp;
    char *name1;
    char *name2;
    int flags;
{
    TpInfo *ti = (TpInfo *)cd;
    char str[20];

    sprintf(str, "%ld", ti->viewportHeight);
    Tcl_SetVar(ti->interp, "tp_viewport_height", str, flags & TCL_GLOBAL_ONLY);
    return "variable is read-only";
}
