/*

Copyright (C) 1993-1996 Olivetti Research Limited, Cambridge, England.

THERE IS NO WARRANTY FOR THIS SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE
LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR
OTHER PARTIES PROVIDE THIS SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  NO
GUARANTEE IS MADE THAT THIS SOFTWARE IS FREE OF SOFTWARE VIRUSES.  THE ENTIRE
RISK AS TO THE QUALITY AND PERFORMANCE OF THIS SOFTWARE IS WITH YOU.  SHOULD
THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY
COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THIS
SOFTWARE AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
INABILITY TO USE THIS SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR
DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THIS SOFTWARE TO OPERATE WITH ANY OTHER SYSTEMS), EVEN IF SUCH
HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*/

/*
 * tpgetkbmap.c - get the keyboard and modifier mappings and store them in
 * properties on the root window.
 *
 * T J Richardson
 */

#include <stdio.h>
#include <malloc.h>
#include <X11/Xmd.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#define MAX_MODIFIERS 8

char *programName;

static void usage()
{
    fprintf(stderr,"usage: %s [-display dpy]\n", programName);
    exit(1);
}

int main(argc, argv)
    int argc;
    char **argv;
{
    char *displayname = NULL;
    Display *dpy;
    Atom propAtom, typeAtom;
    int i;
    KeySym *keysyms;
    int keysymsPerKeycode;
    int minKeycode, maxKeycode, noOfKeycodes;
    XModifierKeymap *modMap;
    long *propData;

    programName = argv[0];

    for (i = 1; i < argc; i++) {
	if (argv[i][0] != '-')
	    break;

	switch (argv[i][1]) {
	case 'd':			/* -display dpyname */
	    if (++i >= argc) usage();
	    displayname = argv[i];
	    break;
	default:
	    usage();
	}
    }

    if (!(dpy = XOpenDisplay(displayname))) {
	fprintf(stderr,"%s: unable to open display \"%s\"\r\n",
		programName, XDisplayName (displayname));
	exit(1);
    }

    XDisplayKeycodes(dpy, &minKeycode, &maxKeycode);

    noOfKeycodes = maxKeycode - minKeycode + 1;

    keysyms = XGetKeyboardMapping(dpy, minKeycode, noOfKeycodes, &keysymsPerKeycode);

    printf("nkc %d c/s %d\n",noOfKeycodes,noOfKeycodes * keysymsPerKeycode);

    /*
     * We need to convert from KeySyms to longs since they may not be the
     * same size e.g. on an alpha).
     */

    propData = (long *)malloc(sizeof(long) * noOfKeycodes * keysymsPerKeycode);

    for (i = 0; i < noOfKeycodes * keysymsPerKeycode; i++) {
	propData[i] = (long)keysyms[i];
    }

    typeAtom = XInternAtom(dpy, "_ORL_TP_KB_MAP", False);
    propAtom = XInternAtom(dpy, "_ORL_TP_DEFAULT_KB_MAP", False);

    XChangeProperty(dpy, DefaultRootWindow(dpy), propAtom, typeAtom, 32,
		    PropModeReplace, (unsigned char *)propData,
		    noOfKeycodes * keysymsPerKeycode);

    free(propData);

    /*
     * For the modifier mapping we assume that KeyCodes and chars are
     * the same size.
     */

    modMap = XGetModifierMapping(dpy);

    typeAtom = XInternAtom(dpy, "_ORL_TP_MOD_MAP", False);
    propAtom = XInternAtom(dpy, "_ORL_TP_DEFAULT_MOD_MAP", False);

    XChangeProperty(dpy, DefaultRootWindow(dpy), propAtom, typeAtom, 8,
		    PropModeReplace, (unsigned char *)modMap->modifiermap,
		    modMap->max_keypermod * MAX_MODIFIERS);
    XCloseDisplay(dpy);
    return 0;
}
