# [.mk]AfterDir.mms

# Concatenating options doesn't work in VMS like it does on other platforms.
# In particular, the /include supercedes rather than appends to the include
# path.  Therefore, to add directory specific /include's, you have to define
# DIR_CPPINCLUDES.

.IFDEF DIR_CPPINCLUDES
OMNIORB2_INCLUDE_SWITCH = \
/Include=($(CORBA_CPPINCLUDES),$(CORBA_STUB_DIR),$(DIR_CPPINCLUDES))
.ELSE
OMNIORB2_INCLUDE_SWITCH = \
/Include=($(CORBA_CPPINCLUDES),$(CORBA_STUB_DIR))
.ENDIF

# /Define is handled the same way.  However, CORBA_CPPMACROS currently isn't
# defined.

.IFDEF CORBA_CPPMACROS
.IFDEF DIR_CPPMACROS
OMNIORB2_DEFINE_SWITCH = /Define=($(CORBA_CPPMACROS),$(DIR_CPPMACROS))
.ELSE
OMNIORB2_DEFINE_SWITCH = /Define=($(CORBA_CPPMACROS))
.ENDIF
.ELSE
.IFDEF DIR_CPPMACROS
OMNIORB2_DEFINE_SWITCH = /Define=($(DIR_CPPMACROS))
.ELSE
OMNIORB2_DEFINE_SWITCH = 
.ENDIF

.IFDEF DEBUG

OMNIORB2_CPPFLAGS = /Mms/Except/Diag/NoOpt/Debug=all$(CORBA_CPPFLAGS)\
$(OMNIORB2_INCLUDE_SWITCH)$(OMNIORB2_DEFINE_SWITCH)
OMNIORB2_CXXLINKFLAGS = /Debug/NoTemplate_prelink

.ELSE

OMNIORB2_CPPFLAGS = /Mms/Except/Diag$(CORBA_CPPFLAGS)\
$(OMNIORB2_INCLUDE_SWITCH)$(OMNIORB2_DEFINE_SWITCH)
OMNIORB2_CXXLINKFLAGS = /NoTemplate_prelink

.ENDIF

MakeSubdirs=@$(top)mk]makesubdirs.dcl "$(MMSQUALIFIERS)" $(MMS$TARGET) \
"$(SUBDIRS)"

BuildCorbaStubs = @$(top)mk]BuildCorbaStubs.dcl "$(CORBA_INTERFACES)" \
"omniidls:" "omnistubs:" $(OMNIORB2_IDL) \
"$(OMNIORB2_CPPFLAGS)$(DIR_CPPFLAGS)" \
"$(OMNIORB2_IDL_FLAGS)" "$(DIR_IDLFLAGS)"

RM_FLAGS = /Exclude=(DESCRIP.MMS,DIR.MMS)/Log
RM = @omniMk:rm.dcl "$(RM_FLAGS)"
RemoveCorbaStubs = @$(top)mk]RemoveCorbaStubs.dcl @omniMk:rm.dcl \
"$(RM_FLAGS)" "$(CORBA_INTERFACES)" "omnistubs:"

clean ::
	@ purge
	@ $(RM) *.obj *.lis *.dia *.olb
	@ $(RM) [.cxx_repository]*.* cxx_repository.dir cxx_repository.opt
	@ targets = f$edit("$(MMS$TARGETS)","UPCASE")
	@ $(MakeSubDirs)

veryclean :: clean
	@ workingDir = f$environent("default")
	@ if f$locate(".SRC.",workingDir) .lt. f$length(workingDir) then-
		$(RM) *.mms
	@ $(RemoveCorbaStubs)
	@ $(MakeSubDirs)

.ifdef INITIALIZE_MMS

.ifdef CORBA_INTERFACES
.FIRST
	@ @$(TOP)MK]MAKECORBASTUBOBJ.DCL "$(CORBA_INTERFACES)" \
"$(CORBA_STUB_DIR)"
.endif

.else

.ifdef CORBA_INTERFACES
.include corba_interfaces.mms
.endif

.endif

CXXExecutable = @$(top)mk]CXXExecutable.dcl "$(MMS$TARGET)" "$(MMS$SOURCE)" -
"$(OBJ_LIBS)" "$(OMNIORB2_CXXLINKFLAGS)$(DIR_CXXLINKFLAGS)"
