#
# sun4_sosV_5.7.mk - make variables and rules specific to Solaris 7
#

SunOS = 1
SparcProcessor = 1


#
# Include general unix things
#

include $(THIS_IMPORT_TREE)/mk/unix.mk


#
# C preprocessor macro definitions for this architecture
#

IMPORT_CPPFLAGS += -D__sparc__ -D__sunos__ -D__OSVERSION__=5


#
# Standard programs
#

AR = ar cq

MKDIRHIER = omkdirhier

CPP = CC

CXX = CC
CXXMAKEDEPEND = $(OMKDEPEND) -D__SUNPRO_CC -D__cplusplus
CXXDEBUGFLAGS = -g -O2
CXXMTFLAG     = -mt

CXXLINK		= $(CXX)
CXXLINKOPTIONS  = $(CXXDEBUGFLAGS) $(CXXOPTIONS) \
		  $(patsubst %,-R %,$(IMPORT_LIBRARY_DIRS))
# Note: the -R linker option in CXXLINKOPTIONS instruct the Sun linker to
# record the pathname of the shared libraries in the executable.

#
# To use gcc uncomment the following lines:
#
#CPP = gcc
#
#CXX = g++
#CXXMAKEDEPEND = $(OMKDEPEND) -D__cplusplus -D__GNUG__ -D__GNUC__
#CXXDEBUGFLAGS = 
#CXXOPTIONS    =  -fhandle-exceptions -Wall -Wno-unused
#CXXMTFLAG     =
#
#CXXLINK		= $(CXX)
#CXXLINKOPTIONS  = $(CXXDEBUGFLAGS) $(CXXOPTIONS) \
#		  $(patsubst %,-R %,$(IMPORT_LIBRARY_DIRS))
# Note: the -R linker option in CXXLINKOPTIONS instruct the Sun linker to
# record the pathname of the shared libraries in the executable.

CC                = /opt/SUNWspro/bin/cc
CMAKEDEPEND       = $(OMKDEPEND)
CDEBUGFLAGS       = -g -O
COPTIONS	  = 

CLINK             = $(CC)


#
# Socket library
#

SOCKET_LIB = -lsocket -lnsl
THREAD_LIB = -lthread $(CXXMTFLAG)


#
# CORBA stuff
#

omniORB2GatekeeperImplementation = OMNIORB2_TCPWRAPGK
CorbaImplementation = OMNIORB2

#
# OMNI thread stuff
#

Solaris_OMNITHREAD_LIB = $(patsubst %,$(LibSearchPattern),omnithread) \
			 -lthread -lposix4 $(CXXMTFLAG)
Solaris_OMNITHREAD_CPPFLAGS = -D_REENTRANT $(CXXMTFLAG)

Posix_OMNITHREAD_LIB = $(patsubst %,$(LibSearchPattern),omnithread) -lpthread \
		 -lposix4 $(CXXMTFLAG)
Posix_OMNITHREAD_CPPFLAGS = -DUsePthread -D_REENTRANT $(CXXMTFLAG)
OMNITHREAD_POSIX_CPPFLAGS = -DPthreadDraftVersion=10 \
			    -DPthreadSupportThreadPriority

OMNITHREAD_LIB = $($(ThreadSystem)_OMNITHREAD_LIB)
OMNITHREAD_CPPFLAGS = $($(ThreadSystem)_OMNITHREAD_CPPFLAGS)

ThreadSystem = Posix

lib_depend := $(patsubst %,$(LibPattern),omnithread)
OMNITHREAD_LIB_DEPEND := $(GENERATE_LIB_DEPEND)


#
# OMNI ParTcl stuff
#

TCLTK_CPPFLAGS = -I/usr/local/include
TCLTK_LIB = -L/usr/local/lib -ltk8.0 -ltcl8.0 -lm $(SOCKET_LIB) -ldl -R /usr/local/lib
X11_CPPFLAGS = -I/usr/openwin/include
X11_LIB = -L/usr/openwin/lib -lX11 -R /usr/openwin/lib
WISH4 = /usr/local/bin/wish8.0

OMNIPARTCL_CPPFLAGS = $(TCLTK_CPPFLAGS) $(X11_CPPFLAGS) $(OMNITHREAD_CPPFLAGS)
OMNIPARTCL_LIB = $(patsubst %,$(LibSearchPattern),omniParTcl) $(TCLTK_LIB) \
		 $(X11_LIB) $(OMNITHREAD_LIB)
lib_depend := $(patsubst %,$(LibPattern),omniParTcl)
OMNIPARTCL_LIB_DEPEND := $(GENERATE_LIB_DEPEND) $(OMNITHREAD_LIB_DEPEND)


#
# Java stuff
#

JAVAC = /usr/local/java/bin/javac
JAR = /usr/local/java/bin/jar
JAVAC_FLAGS =
CORBA_STUB_JAVAC_FLAGS =

JAVA_SYSTEM_CLASSES = /usr/local/java/lib/classes.zip

CORBA_JAVA_IDL_ONLY = /usr/local/vbroker3.2/bin/idl2java

CORBA_JAVA_IDL = $(CORBA_JAVA_IDL_ONLY) -portable -strict -no_comments	 \
		 -no_examples -no_tie -idl2package ::CORBA org.omg.CORBA \
		 -idl2package ::CosNaming org.omg.CosNaming		 \
		 $(CORBA_INTERFACES_JAVA_PACKAGE:%=-package %)
