PYLIBROOT= $(EXPORT_TREE)/lib/python
PYLIBDIR = $(PYLIBROOT)/omniORB
INSTALLPYLIBDIR = $(INSTALLPYTHONDIR)/omniORB

ir_idl.py: ir.idl
	$(OMNIIDL) -v -p$(BASE_OMNI_TREE)/omniidl_be \
        -I$(BASE_OMNI_TREE)/idl -I$(OMNIORB_ROOT)/idl/omniORB \
         -bpython -Wbinline -Wbno_package $^

all:: ir_idl.py


FILES = __init__.py CORBA.py PortableServer.py PortableServer__POA.py \
        tcInternal.py URI.py ir_idl.py

export:: $(FILES)
	@(dir="$(PYLIBDIR)"; \
          for file in $^; do \
            $(ExportFileToDir) \
          done; \
          cd $(PYLIBDIR); \
	  $(PYTHON) -c "import compileall; compileall.compile_dir('.')"; \
	 )

ifdef INSTALLTARGET
install:: $(FILES)
	@(dir="$(INSTALLPYLIBDIR)"; \
          for file in $^; do \
            $(ExportFileToDir) \
          done; \
          cd $(INSTALLPYLIBDIR); \
	  $(PYTHON) -c "import compileall; compileall.compile_dir('.')"; \
	 )
endif
