# dir.mms for omniORB
#

.IFDEF USE_SHAREABLE_IMAGES
.IFDEF CXX5
# Creating shareable images is more complicated with C++ 5.6
SHAREABLE_SUBDIRS=orbcore.sharedlib dynamic.sharedlib
.ENDIF
.ENDIF

SUBDIRS = orbcore dynamic $(SHAREABLE_SUBDIRS)

all :: Naming.hh bootstrap.hh ir_defs.hh corbaidl_defs.hh omniLifeCycle.hh

clean ::
	@ $(MakeSubdirs)

omniORBInclude=[include.omniORB3]

Naming_header = $(omniORBInclude)Naming.hh
bootstrap_header = $(omniORBInclude)bootstrap.hh
ir_defs_header = $(omniORBInclude)ir_defs.hh
ir_operators_header = $(omniORBInclude)ir_operators.hh
ir_poa_header = $(omniORBInclude)ir_poa.hh
corbaidl_defs_header = $(omniORBInclude)corbaidl_defs.hh
corbaidl_operators_header = $(omniORBInclude)corbaidl_operators.hh
corbaidl_poa_header = $(omniORBInclude)corbaidl_poa.hh
omniLifeCycle_header = $(omniORBInclude)omniLifeCycle.hh

export :: NamingSK.cc NamingDynSK.cc bootstrapSK.cc bootstrapDynSK.cc\
	irSK.cc irDynSK.cc corbaidlSK.cc corbaidlDynSK.cc\
	omniLifeCycleSK.cc omniLifeCycleDynSK.cc\
	$(Naming_header) $(bootstrap_header) $(ir_defs_header)\
	$(ir_operators_header) $(ir_poa_header) $(corbaidl_defs_header)\
	$(corbaidl_operators_header) $(corbaidl_poa_header)\
	$(omniLifeCycle_header)
	@ $(ExportPythonFiles)
	@ $(MakeSubdirs)

veryclean ::
	$(RM)	Naming.idl Naming.hh NamingSK.cc NamingDynSK.cc
	$(RM)	bootstrap.idl bootstrap.hh bootstrapSK.cc bootstrapDynSK.cc
	$(RM)	ir.idl ir_defs.hh ir_operators.hh irSK.cc irDynSK.cc
	$(RM)	corbaidl.idl corbaidl_defs.hh corbaidl_operators.hh
	$(RM)	corbaidl_poa.hh ir_poa.hh
	$(RM)	corbaidlSK.cc corbaidlDynSK.cc
	$(RM)	omniLifeCycle.idl omniLifeCycle.hh omniLifeCycleSK.cc
	$(RM)	omniLifeCycleDynSK.cc

######################################################################
# Make rules for Stubs                                               #
######################################################################

.IFDEF VAX
OMNIORB_VAX_FLAGS="-DOMNIORB_NO_IR_CLIENT"
.ENDIF

OMNIORB_IDL_FPATH = $(OMNIORB_IDL) -p$(BASE_OMNI_TREE)/src/lib/omniORB2\
	$(OMNIORB_VAX_FLAGS)

Naming.hh NamingSK.cc NamingDynSK.cc : Naming.idl
	$(OMNIORB_IDL_FPATH) "Naming.idl"

bootstrap.hh bootstrapSK.cc bootstrapDynSK.cc : bootstrap.idl
	$(OMNIORB_IDL_FPATH) "bootstrap.idl"

ir_defs.hh ir_operators.hh irSK.cc irDynSK.cc : ir.idl corbaidl_defs.hh
	$(OMNIORB_IDL_FPATH) "-WbF" "-I." ir.idl

corbaidl_defs.hh corbaidl_operators.hh corbaidlSK.cc corbaidlDynSK.cc : corbaidl.idl
	$(OMNIORB_IDL_FPATH) "-WbF" corbaidl.idl

omniLifeCycle.hh omniLifeCycleSK.cc omniLifeCycleDynSK.cc : omniLifeCycle.idl
	$(OMNIORB_IDL_FPATH) omniLifeCycle.idl

# Make rules to import idls from ['top'.idl]

Naming.idl : [idl]Naming.idl
	copy $(mms$source) $(mms$target)

bootstrap.idl : [idl]bootstrap.idl
	copy $(mms$source) $(mms$target)

ir.idl : [idl]ir.idl
	copy $(mms$source) $(mms$target)

corbaidl.idl : [idl]corbaidl.idl
	copy $(mms$source) $(mms$target)

omniLifeCycle.idl : [idl]omniLifeCycle.idl
	copy $(mms$source) $(mms$target)

######################################################################
# Make rules for Exporting headers                                   #
######################################################################
$(Naming_header) : Naming.hh
	@ $(ExportHeader)

$(bootstrap_header) : bootstrap.hh
	@ $(ExportHeader)

$(ir_defs_header) : ir_defs.hh
	@ $(ExportHeader)

$(ir_operators_header) : ir_operators.hh
	@ $(ExportHeader)

$(ir_poa_header) : ir_poa.hh
	@ $(ExportHeader)

$(corbaidl_defs_header) : corbaidl_defs.hh
	@ $(ExportHeader)

$(corbaidl_operators_header) : corbaidl_operators.hh
	@ $(ExportHeader)

$(corbaidl_poa_header) : corbaidl_poa.hh
	@ $(ExportHeader)

$(omniLifeCycle_header) : omniLifeCycle.hh
	@ $(ExportHeader)

