################################################################################
# [.src.lib.omniORB2]dir.mms
################################################################################

CONFIG_DEFAULT_LOCATION = omniCFG:omniORB.cfg

.ifdef useTcpSocketVaxRoutines
DIR_CPPMACROS = "CONFIG_DEFAULT_LOCATION=""$(CONFIG_DEFAULT_LOCATION)""",\
"USE_omniORB_logStream","_OMNIORB2_LIBRARY","USE_tcpSocketVaxRoutines"
.else
DIR_CPPMACROS = "CONFIG_DEFAULT_LOCATION=""$(CONFIG_DEFAULT_LOCATION)""",\
"USE_omniORB_logStream","_OMNIORB2_LIBRARY"
.endif

DIR_CPPINCLUDES = "./","../"

# search local directory first for include file to avoid superfluous builds:
.ifdef cxx6
DIR_CPPFLAGS = /Nested_include=primary/Quiet
.else
DIR_CPPFLAGS = /Nested_include=primary
.endif

################################################################################
# MMS initiali[sz]ation
################################################################################

.ifdef INITIALIZE_MMS

all ::
	@ $(CreateMms) bootstrap_i .obj .cc
	@ $(CreateMms) bootstrapstub .obj .cc
	@ $(CreateMms) constants .obj .cc
	@ $(CreateMms) corbaBoa .obj .cc
	@ $(CreateMms) corbaObject .obj .cc
	@ $(CreateMms) corbaOrb .obj .cc
	@ $(CreateMms) corbaString .obj .cc
	@ $(CreateMms) exception .obj .cc
	@ $(CreateMms) giopClient .obj .cc
	@ $(CreateMms) giopServer .obj .cc
	@ $(CreateMms) initFile .obj .cc
	@ $(CreateMms) ior .obj .cc
	@ $(CreateMms) libcWrapper .obj .cc
	@ $(CreateMms) mbufferedStream .obj .cc
	@ $(CreateMms) nbufferedStream .obj .cc
	@ $(CreateMms) object .obj .cc
	@ $(CreateMms) objectKey .obj .cc
	@ $(CreateMms) objectRef .obj .cc
	@ $(CreateMms) ropeFactory .obj .cc
	@ $(CreateMms) strand .obj .cc
	@ $(CreateMms) scavenger .obj .cc
	@ $(CreateMms) exceptn .obj .cc
	@ $(CreateMms) proxyCall .obj .cc
	@ $(CreateMms) relStream .obj .cc
	@ $(CreateMms) tcpSocket .obj .cc
	@ $(CreateMms) tcpSocketMTfactory .obj .cc
	@ $(CreateMms) logIOstream .obj .cc
	@ $(CreateMms) Namingstub .obj .cc
	@ $(CreateMms) tcpSocketVaxRoutines .obj .cc
	@ $(CreateMms) current .obj .cc
	@ $(CreateMms) policy .obj .cc
	@ $(CreateMms) orbservice .obj .cc
	@ $(CreateMms) domainManager .obj .cc

################################################################################
# all rule
################################################################################

.else

#.first
#	@ $(FirstActions)
#	@ DEFINE DECC$CRTLMAP SYS$LIBRARY:DECC$CRTL.EXE
#	@ DEFINE LNK$LIBRARY  SYS$LIBRARY:DECC$CRTL.OLB

lib = omniORB2$(DebugSuffix).olb
DFloatLib = omniORB2DFloat$(DebugSuffix).olb
GFloatLib = omniORB2GFloat$(DebugSuffix).olb

.IFDEF ALPHA
IEEEFloatLib = omniORB2IEEEFloat$(DebugSuffix).olb
.ENDIF

DFLOAT_OBJS = $(DFloatLib)(corbaFloat=corbaDFloat.obj)
GFLOAT_OBJS = $(GFloatLib)(corbaFloat=corbaGFloat.obj)

.IFDEF ALPHA
IEEEFLOAT_OBJS = $(IEEEFloatLib)(corbaFloat=corbaIEEEFloat.obj)
.ENDIF

.IFDEF useTcpSocketVaxRoutines
tcpSocketVaxRoutines=$(lib)(tcpSocketVaxRoutines.OBJ)
.ELSE
tcpSocketVaxRoutines=
.ENDIF

ORB2_OBJS = $(lib)(bootstrap_i)\
	$(lib)(bootstrapstub)\
	$(lib)(constants)\
	$(lib)(corbaBoa)\
	$(lib)(corbaObject)\
	$(lib)(corbaOrb)\
	$(lib)(corbaString)\
	$(lib)(exception)\
	$(lib)(giopClient)\
	$(lib)(giopServer)\
	$(lib)(initFile)\
	$(lib)(ior)\
	$(lib)(libcWrapper)\
	$(lib)(mbufferedStream)\
	$(lib)(nbufferedStream)\
	$(lib)(object)\
	$(lib)(objectKey)\
	$(lib)(objectRef)\
	$(lib)(ropeFactory)\
	$(lib)(strand)\
	$(lib)(scavenger)\
	$(lib)(exceptn)\
	$(lib)(proxyCall)\
	$(lib)(relStream)\
	$(lib)(tcpSocket)\
	$(lib)(tcpSocketMTfactory)\
	$(lib)(logIOstream)\
	$(lib)(Namingstub)\
	$(lib)(gatekeeper.obj)\
	$(lib)(current.obj)\
	$(lib)(policy.obj)\
	$(lib)(orbservice.obj)\
	$(lib)(domainManager.obj)\
	$(tcpSocketVaxRoutines)

.first
	@ $(FirstActions)
	@ omniorb2_device=f$parse("[-]",,,"device")
	@ omniorb2_directory=f$parse("[-]",,,"directory")
	@ define/nolog omniorb2 -
		'omniorb2_device''omniorb2_directory','f$trnlnm("omniorb2")

.ifdef ALPHA
all :: $(ORB2_OBJS) $(DFLOAT_OBJS) $(GFLOAT_OBJS) $(IEEEFLOAT_OBJS)
.else
all :: $(ORB2_OBJS) $(DFLOAT_OBJS) $(GFLOAT_OBJS)
.endif

.include bootstrap_i.mms
.include bootstrapstub.mms
.include constants.mms
.include corbaBoa.mms
.include corbaObject.mms
.include corbaOrb.mms
.include corbaString.mms
.include exception.mms
.include giopClient.mms
.include giopServer.mms
.include initFile.mms
.include ior.mms
.include libcWrapper.mms
.include mbufferedStream.mms
.include nbufferedStream.mms
.include object.mms
.include objectKey.mms
.include objectRef.mms
.include ropeFactory.mms
.include strand.mms
.include scavenger.mms
.include exceptn.mms
.include proxyCall.mms
.include relStream.mms
.include tcpSocket.mms
.include tcpSocketMTfactory.mms
.include logIOstream.mms
.include tcpSocketVaxRoutines.mms
.include Namingstub.mms
.include current.mms
.include policy.mms
.include orbservice.mms
.include domainManager.mms

# see comments under Win32Platform in dir.mk

gatekeeper.obj : [.gatekeepers.dummystub]gatekeeper.cc

################################################################################
# export rule
################################################################################

export :: all

export :: $(lib)
	$(ExportLibrary)

export :: $(DFloatLib)
	$(ExportLibrary)

export :: $(GFloatLib)
	$(ExportLibrary)

.IFDEF ALPHA
export :: $(IEEEFloatLib)
	$(ExportLibrary)
.ENDIF

clean ::
	$(RM) $(lib)

corbaDFloat.obj : corbaFloat.cc
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(DIR_CPPFLAGS) \
$(OMNIORB2_CPPFLAGS)/Mms=file=$(mms$target_name)/Object=$(mms$target_name)\
/Float=D_Float
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS

corbaGFloat.obj : corbaFloat.cc
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(DIR_CPPFLAGS) \
$(OMNIORB2_CPPFLAGS)/Mms=file=$(mms$target_name)/Object=$(mms$target_name)\
/Float=G_Float
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS

.ifdef ALPHA
corbaIEEEFloat.obj : corbaFloat.cc
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(DIR_CPPFLAGS) \
$(OMNIORB2_CPPFLAGS)/Mms=file=$(mms$target_name)/Object=$(mms$target_name)\
/Float=IEEE_Float
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS
.endif
.endif
