################################################################################
# [.src.lib.omniORB2]dir.mms
################################################################################

CONFIG_DEFAULT_LOCATION = omniCFG:omniORB.cfg

.ifdef useTcpSocketVaxRoutines
DIR_CPPMACROS = "CONFIG_DEFAULT_LOCATION=""$(CONFIG_DEFAULT_LOCATION)""",\
"USE_omniORB_logStream","_OMNIORB2_LIBRARY","USE_tcpSocketVaxRoutines"
.else
DIR_CPPMACROS = "CONFIG_DEFAULT_LOCATION=""$(CONFIG_DEFAULT_LOCATION)""",\
"USE_omniORB_logStream","_OMNIORB2_LIBRARY"
.endif

DIR_CPPINCLUDES = [],[-]

# search local directory first for include file to avoid superfluous builds:
.ifdef cxx6
DIR_CPPFLAGS = /Nested_include=primary/Quiet
.else
DIR_CPPFLAGS = /Nested_include=primary
.endif

################################################################################
# MMS initiali[sz]ation
################################################################################

.ifdef INITIALIZE_MMS

all ::
	@ $(CreateMms) bootstrap_i .obj .cc
	@ $(CreateMms) bootstrapSK .obj .cc
	@ $(CreateMms) constants .obj .cc
	@ $(CreateMms) corbaBoa .obj .cc
	@ $(CreateMms) corbaObject .obj .cc
	@ $(CreateMms) corbaOrb .obj .cc
	@ $(CreateMms) corbaString .obj .cc
	@ $(CreateMms) exception .obj .cc
	@ $(CreateMms) giopClient .obj .cc
	@ $(CreateMms) giopServer .obj .cc
	@ $(CreateMms) initFile .obj .cc
	@ $(CreateMms) ior .obj .cc
	@ $(CreateMms) libcWrapper .obj .cc
	@ $(CreateMms) mbufferedStream .obj .cc
	@ $(CreateMms) nbufferedStream .obj .cc
	@ $(CreateMms) object .obj .cc
	@ $(CreateMms) objectKey .obj .cc
	@ $(CreateMms) objectRef .obj .cc
	@ $(CreateMms) ropeFactory .obj .cc
	@ $(CreateMms) strand .obj .cc
	@ $(CreateMms) scavenger .obj .cc
	@ $(CreateMms) exceptn .obj .cc
	@ $(CreateMms) proxyCall .obj .cc
	@ $(CreateMms) relStream .obj .cc
	@ $(CreateMms) tcpSocket .obj .cc
	@ $(CreateMms) tcpSocketMTfactory .obj .cc
	@ $(CreateMms) logIOstream .obj .cc
	@ $(CreateMms) NamingSK .obj .cc
	@ $(CreateMms) tcpSocketVaxRoutines .obj .cc

################################################################################
# all rule
################################################################################

.else

#.first
#	@ $(FirstActions)
#	@ DEFINE DECC$CRTLMAP SYS$LIBRARY:DECC$CRTL.EXE
#	@ DEFINE LNK$LIBRARY  SYS$LIBRARY:DECC$CRTL.OLB

lib = omniORB2$(DebugSuffix).olb
DFloatLib = omniORB2DFloat$(DebugSuffix).olb
GFloatLib = omniORB2GFloat$(DebugSuffix).olb

.IFDEF ALPHA
IEEEFloatLib = omniORB2IEEEFloat$(DebugSuffix).olb
.ENDIF

DFLOAT_OBJS = $(DFloatLib)(corbaFloat=corbaDFloat.obj)
GFLOAT_OBJS = $(GFloatLib)(corbaFloat=corbaGFloat.obj)

.IFDEF ALPHA
IEEEFLOAT_OBJS = $(IEEEFloatLib)(corbaFloat=corbaIEEEFloat.obj)
.ENDIF

.IFDEF useTcpSocketVaxRoutines
tcpSocketVaxRoutines=$(lib)(tcpSocketVaxRoutines.OBJ)
.ELSE
tcpSocketVaxRoutines=
.ENDIF

ORB2_OBJS = $(lib)(bootstrap_i)\
	$(lib)(bootstrapSK)\
	$(lib)(constants)\
	$(lib)(corbaBoa)\
	$(lib)(corbaObject)\
	$(lib)(corbaOrb)\
	$(lib)(corbaString)\
	$(lib)(exception)\
	$(lib)(giopClient)\
	$(lib)(giopServer)\
	$(lib)(initFile)\
	$(lib)(ior)\
	$(lib)(libcWrapper)\
	$(lib)(mbufferedStream)\
	$(lib)(nbufferedStream)\
	$(lib)(object)\
	$(lib)(objectKey)\
	$(lib)(objectRef)\
	$(lib)(ropeFactory)\
	$(lib)(strand)\
	$(lib)(scavenger)\
	$(lib)(exceptn)\
	$(lib)(proxyCall)\
	$(lib)(relStream)\
	$(lib)(tcpSocket)\
	$(lib)(tcpSocketMTfactory)\
	$(lib)(logIOstream)\
	$(lib)(NamingSK)\
	$(lib)(gatekeeper.obj)\
	$(tcpSocketVaxRoutines)

.ifdef ALPHA
all ::	Naming.hh bootstrap.hh $(ORB2_OBJS) \
$(DFLOAT_OBJS) $(GFLOAT_OBJS) $(IEEEFLOAT_OBJS)
.else
all ::	Naming.hh bootstrap.hh $(ORB2_OBJS) $(LC_OBJS) \
$(DFLOAT_OBJS) $(GFLOAT_OBJS)
.endif

Naming.idl : $(top)idl]Naming.idl
	copy $(mms$source) $(mms$target)

Naming.hh, NamingSK.cc NamingDynSK.cc : Naming.idl
	omniidl2 -a "Naming.idl"
  
bootstrap.idl : $(top)idl]bootstrap.idl
	copy $(mms$source) $(mms$target)

bootstrap.hh, bootstrapSK.cc bootstrapDynSK.cc : bootstrap.idl
	omniidl2 -a "bootstrap.idl"

ir.idl : $(top)idl]ir.idl
	copy $(mms$source) $(mms$target)

ir.hh irSK.cc irDynSK.cc : corbaidl.hh ir.idl
	omniidl2 -a -m "-I[]" ir.idl

corbaidl.idl : $(top)idl]corbaidl.idl
	copy $(mms$source) $(mms$target)

corbaidl.hh corbaidlSK.cc corbaidlDynSK.cc : corbaidl.idl
	omniidl2 -a -m corbaidl.idl

.include bootstrap_i.mms
.include bootstrapSK.mms
.include constants.mms
.include corbaBoa.mms
.include corbaObject.mms
.include corbaOrb.mms
.include corbaString.mms
.include exception.mms
.include giopClient.mms
.include giopServer.mms
.include initFile.mms
.include ior.mms
.include libcWrapper.mms
.include mbufferedStream.mms
.include nbufferedStream.mms
.include object.mms
.include objectKey.mms
.include objectRef.mms
.include ropeFactory.mms
.include strand.mms
.include scavenger.mms
.include exceptn.mms
.include proxyCall.mms
.include relStream.mms
.include tcpSocket.mms
.include tcpSocketMTfactory.mms
.include logIOstream.mms
.include tcpSocketVaxRoutines.mms
.include NamingSK.mms

# see comments under Win32Platform in dir.mk

gatekeeper.obj : [.gatekeepers.dummystub]gatekeeper.cc

################################################################################
# export rule
################################################################################

export :: all

export :: $(lib)
	@ $(ExportLibrary)

export :: $(DFloatLib)
	@ $(ExportLibrary)

export :: $(GFloatLib)
	@ $(ExportLibrary)

.IFDEF ALPHA
export :: $(IEEEFloatLib)
	@ $(ExportLibrary)
.ENDIF

BOOTSTRAP_HDR = $(EXPORT_TREE)$(INCDIR).omniORB2]bootstrap.hh
NAMING_HDR = $(EXPORT_TREE)$(INCDIR).omniORB2]Naming.hh
IR_HDR = $(EXPORT_TREE)$(INCDIR).omniORB2]ir.hh
CORBAIDL_HDR = $(EXPORT_TREE)$(INCDIR).omniORB2]corbaidl.hh

export :: $(NAMING_HDR) $(BOOTSTRAP_HDR) $(IR_HDR) $(CORBAIDL_HDR)

$(BOOTSTRAP_HDR) : bootstrap.hh
	$(ExportHeader)

$(NAMING_HDR) : naming.hh
	$(ExportHeader)

$(IR_HDR) : ir.hh
	$(ExportHeader)

$(CORBAIDL_HDR) : corbaidl.hh
	$(ExportHeader)

clean ::
	$(RM) $(lib) NamingSK.cc bootstrapSK.cc NamingDynSK.cc bootstrapDynSK.cc

corbaDFloat.obj : corbaFloat.cc
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(DIR_CPPFLAGS) \
$(OMNIORB2_CPPFLAGS)/Mms=file=$(mms$target_name)/Object=$(mms$target_name)\
/Float=D_Float
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS

corbaGFloat.obj : corbaFloat.cc
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(DIR_CPPFLAGS) \
$(OMNIORB2_CPPFLAGS)/Mms=file=$(mms$target_name)/Object=$(mms$target_name)\
/Float=G_Float
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS

.ifdef ALPHA
corbaIEEEFloat.obj : corbaFloat.cc
	@ write sys$output "Compiling $(MMS$SOURCE)..."
	$(CXX) $(CXXFLAGS) $(MMS$SOURCE) $(DIR_CPPFLAGS) \
$(OMNIORB2_CPPFLAGS)/Mms=file=$(mms$target_name)/Object=$(mms$target_name)\
/Float=IEEE_Float
	@ If "''F$Search("$(MMS$TARGET_NAME).DIA")'" .NES. "" Then -
		delete $(MMS$TARGET_NAME).DIA;*
	@ If "''F$Search("$(MMS$TARGET_NAME).OBJ")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).OBJ
	@ If "''F$Search("$(MMS$TARGET_NAME).LIS")'" .NES. "" Then -
		purge $(MMS$TARGET_NAME).LIS
.endif
.endif
