# [.MK]OpenVMS.MMS.  This file is .included from [.platform]'platform'.mms
# (where 'platform' is OpenVMS_Alpha_n_m or OpenVms_VAX_n_m).  The platform
# specific file sets the macro, $(POSIX_LIB_DEPEND) used below.

# Obviously, OpenVMS.MMS is redundant (since MMS only runs on VMS).
# This is because the overall structure of the omniORB2 for VMS
# build system is based on the standard build.  It was hoped that the build
# could have been redone in GNUmake using the POSIX shell.  Alas, Digital has
# decided to drop support for the POSIX shell so that may never happen.

OMNIORB2_IDL_LC_FLAGS = -l
OMNIORB2_IDL_ANY_FLAGS = -a
OMNIORB2_IDL_ONLY = omniidl2
OMNIORB2_IDL = "$(OMNIORB2_IDL_ONLY) ""$(OMNIORB2_IDL_ANY_FLAGS)"""

# bcv 15-JUL-1999 14:14:40.77 Can't use omnilib for the depend variables
# because MMS may do the translation before the $(FirstActions) rule.
libpath=$(EXPORT_TREE)$(LIBDIR)]

OMNITHREAD_SHAREDLIB_DEPEND = $(libpath)omni_share$(DebugSuffix).olb $(POSIX_LIB_DEPEND)
OMNITHREAD_SHAREDLIB = omnilib:omni_share$(DebugSuffix).olb omnilib:share.opt
OMNITHREAD_STATICLIB_DEPEND = $(libpath)omnithread$(DebugSuffix).olb $(POSIX_LIB_DEPEND)
OMNITHREAD_STATICLIB = omnilib:omnithread$(DebugSuffix).olb omnilib:share.opt

.ifdef USE_SHAREABLE_IMAGES
OMNITHREAD_LIB_DEPEND	= $(OMNITHREAD_SHAREDLIB_DEPEND)
OMNITHREAD_LIB		= $(OMNITHREAD_SHAREDLIB)
.else
OMNITHREAD_LIB_DEPEND	= $(OMNITHREAD_STATICLIB_DEPEND)
OMNITHREAD_LIB		= $(OMNITHREAD_STATICLIB)
.endif

# set compiler switch and library for floating point option.

# enforce mutual exclusion of D_FLOAT|G_FLOAT|IEEE_FLOAT:
.IFDEF D_FLOAT
FloatType = D
.ENDIF

.IFDEF G_FLOAT
FloatType = G
.ENDIF

.IFDEF IEEE_FLOAT
FloatType = IEEE
.ENDIF

# handle default case:
.IFDEF D_FLOAT
.ELSE
# ifndef D_FLOAT
.IFDEF G_FLOAT
.ELSE
# ifndef G_FLOAT
.IFDEF IEEE_FLOAT
.ELSE
# ifndef IEEE_FLOAT

.IFDEF ALPHA
# Alpha default
FloatType = G
.ELSE
# VAX default
FloatType = D
.ENDIF	! Alpha vs VAX

.ENDIF	! IEEE_FLOAT else clause
.ENDIF	! G_FLOAT else clause
.ENDIF	! D_FLOAT else clause

CORBA_CPPFLOAT = /Float=$(FloatType)_Float
# Obsolete:
# CORBA_FLOATLIB = omnilib:omniorb2$(FloatType)Float$(DebugSuffix).olb

.IFDEF USE_SHAREABLE_IMAGES
CORBA_LIB_DEPEND = $(OMNITHREAD_LIB_DEPEND)
CORBA_LIB = $(OMNITHREAD_LIB)
.ELSE
CORBA_LIB_DEPEND = omnilib:omniDynamic2$(DebugSuffix).olb\
 omnilib:omniORB2$(DebugSuffix).olb\
 $(OMNITHREAD_LIB_DEPEND)
CORBA_LIB = omnilib:omniDynamic2$(DebugSuffix).olb\
 omnilib:omniORB2$(DebugSuffix).olb\
 $(OMNITHREAD_LIB)
.ENDIF

# bcv 28-JUL-1999 14:08:37.62 make repository path equal to the library path.
# Note that the main effect of this is to create a demangler database that won't
# disappear after a make veryclean.

.IFDEF CXX6
# 6.0 compiler warns about idl generated code.
CORBA_CPPFLAGS = $(CORBA_CPPFLOAT)/Quiet/Repo=omnilib:
.ELSE
CORBA_CPPFLAGS = $(CORBA_CPPFLOAT)/Repo=omnilib:/Warning=(Disable=CANTCOMPLETE)
.ENDIF
CORBA_CPPINCLUDES = [],omni:
OMNIORB2_IDL_FLAGS = "-IomniIdls:"

Export = @$(top)mk]Export.dcl

# ExportHeader differs from other Export rules in that you give the full path of
# the target only.

ExportHeader = @$(top)mk]ExportHeader.dcl \
'f$parse("$@","","","name")''f$parse("$@","","","type")' \
'f$parse("$@","","","device")''f$parse("$@","","","directory")'

ExportExecutable = $(Export) $(MMS$SOURCE) $(EXPORT_TREE)$(BINDIR)]
ExportLibrary = $(Export) $(MMS$SOURCE) $(libpath)
ExportShareable = @$(top)mk]ExportShareable.dcl $(MMS$SOURCE) omnilib: \
$(DebugSuffix)

# rule to create initial dependency file initially or after a veryclean

CreateMms = @$(top)mk]CreateMms.dcl

