#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

vpath %.idl ../idl

EXPORT_TREE	= ..

INTERFACES	= Naming \
		  CosLifeCycle \
		  CosEventComm \
		  CosEventChannelAdmin \
		  EventChannelAdmin

CORBAOBJS	 = $(INTERFACES:%=../idl/%SK.o)

CXXSRCS		= omniEvents.cc \
 		  CosEvent_i.cc \
		  omniEventsLog.cc \
		  EventChannelFactory_i.cc

LIBOBJS		= ../util/args.o \
		  ../util/naming.o \
		  ../fe/y.tab.o \
		  ../fe/lex.yy.o \
		  ../fe/oep_types.o \
		  ../fe/oep_global.o \
		  CosEvent_i.o \
		  omniEventsLog.o \
		  EventChannelFactory_i.o

OMNIEVENTSOBJS	= omniEvents.o

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

ifdef OMNIEVENTS_LOG_DEFAULT_LOCATION
DEFAULT_LOGDIR = $(OMNIEVENTS_LOG_DEFAULT_LOCATION)
else
DEFAULT_LOGDIR = C:\\TEMP
endif

SUBDIRS		= sharedlib
OMNIEVENTSOBJS	+= ../util/getopt.o
DIR_CPPFLAGS	+= -I../include $(CORBA_CPPFLAGS)
DIR_CPPFLAGS	+= -DDEFAULT_LOGDIR='"$(DEFAULT_LOGDIR)"'

else

#############################################################################
#   Make variables for Unix platforms                                       #
#############################################################################

ifdef OMNIEVENTS_LOG_DEFAULT_LOCATION
DEFAULT_LOGDIR = $(OMNIEVENTS_LOG_DEFAULT_LOCATION)
else
DEFAULT_LOGDIR = /var/omniEvents
endif

SUBDIRS		= sharedlib

ifdef AIX
DIR_CPPFLAGS    += -I../include $(CORBA_CPPFLAGS)
else
DIR_CPPFLAGS    += -I../include $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES
endif

DIR_CPPFLAGS	+= -DDEFAULT_LOGDIR='"$(DEFAULT_LOGDIR)"'

endif

#############################################################################
#   Make variables for AIX                                                  #
#############################################################################

ifdef AIX

#STL_INCLUDES	= /vob/tips/include/STL
#DIR_CPPFLAGS	+= -I$(STL_INCLUDES)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

omniEvents	= $(patsubst %,$(BinPattern),omniEvents)
lib		= $(patsubst %,$(LibPattern),omniEvents)
EXECS		= $(omniEvents)

all:: $(lib) $(EXECS)

all::
	@$(MakeSubdirs)

clean::
	$(RM) $(EXECS) $(lib) *.d

export:: $(omniEvents)
	@$(ExportExecutable)

export:: $(lib)
	@$(ExportLibrary)

export::
	@$(MakeSubdirs)

$(lib): $(LIBOBJS) $(CORBAOBJS)
	@$(StaticLinkLibrary)

$(omniEvents): $(OMNIEVENTSOBJS) $(lib)
	@(libs="$(CORBA_LIB) $(lib)"; $(CXXExecutable))
