#############################################################################
#   Make variables common to all platforms                                  #
#############################################################################

EXPORT_TREE	= ..

CORBA_STUB_DIR = .

CORBA_INTERFACES = Naming \
		   CosLifeCycle \
                   CosEventComm \
                   CosEventChannelAdmin \
                   EventChannelAdmin

#############################################################################
#   Make variables for Win32 platforms                                      #
#############################################################################

ifdef Win32Platform

DIR_CPPFLAGS += $(CORBA_CPPFLAGS)

else


ifdef AIX
DIR_CPPFLAGS    += $(CORBA_CPPFLAGS)
else
DIR_CPPFLAGS    += $(CORBA_CPPFLAGS) -D__STL_NO_NAMESPACES
endif


endif

#############################################################################
#   Make variables for AIX                                                  #
#############################################################################

ifdef AIX

#STL_INCLUDES = /vob/tips/include/STL
#DIR_CPPFLAGS += -I$(STL_INCLUDES)

endif

#############################################################################
#   Make rules common to all platforms                                      #
#############################################################################

all:: $(CORBA_STUB_HDRS) $(CORBA_STUB_OBJS)

clean::
	$(RM) $(CORBA_STUB_HDRS) $(CORBA_STUB_SRCS) *.d

export:: $(CORBA_STUB_HDRS) $(CORBA_STUB_OBJS)
	( for file in $(CORBA_STUB_HDRS); do \
	  dir="$(EXPORT_TREE)/$(INCDIR)"; $(ExportFileToDir) \
	done)

######################################################################
# Make rules for stubs.                                              #
######################################################################

$(CORBA_STUB_HDR_PATTERN) $(CORBA_STUB_SRC_PATTERN) $(CORBA_DYN_STUB_SRC_PATTERN): %.idl
	( cd $(CORBA_STUB_DIR); \
	 $(OMNIORB2_IDL) $(notdir $^); \
	)
